# 画面設計書 55-マイルストーン編集

## 概要

本ドキュメントは、GitLabにおけるプロジェクトマイルストーン編集画面に関する設計書です。既存のマイルストーン情報を更新するためのフォーム画面の仕様を定義します。

### 本画面の処理概要

**業務上の目的・背景**：プロジェクトの進行に伴い、マイルストーンのスケジュールや説明を変更する必要が生じることがあります。編集画面では、マイルストーンのタイトル、説明、開始日、終了日を変更し、プロジェクト計画の見直しを反映できます。スプリント期間の調整やリリース日の変更などに使用されます。

**画面へのアクセス方法**：マイルストーン詳細画面の「Edit」ボタンをクリック、または直接URL `/:namespace/:project/-/milestones/:id/edit` にアクセスします。

**主要な操作・処理内容**：
1. マイルストーンタイトルの編集（必須）
2. マイルストーン説明の編集（任意、Markdown対応）
3. 開始日の変更（任意）
4. 終了日（期限）の変更（任意）
5. 変更内容の保存
6. キャンセルして詳細画面へ戻る

**画面遷移**：
- 遷移元：マイルストーン詳細画面、マイルストーン一覧画面
- 遷移先：マイルストーン詳細画面（保存成功時）、マイルストーン詳細画面（キャンセル時）

**権限による表示制御**：
- `admin_milestone`権限：マイルストーンの編集が可能。権限がない場合は404エラー

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 41 | マイルストーン管理 | 主機能 | マイルストーンの編集処理 |

## 画面種別

編集画面（フォーム）

## URL/ルーティング

```
GET   /:namespace/:project/-/milestones/:id/edit
PATCH /:namespace/:project/-/milestones/:id
PUT   /:namespace/:project/-/milestones/:id
```

コントローラー: `Projects::MilestonesController#edit`, `Projects::MilestonesController#update`

## 入出力項目

### 入力項目

| 項目名 | データ型 | 必須 | 最大長 | 説明 |
|--------|---------|------|--------|------|
| title | String | ○ | 255文字 | マイルストーンのタイトル |
| description | Text | - | - | マイルストーンの説明（Markdown対応） |
| start_date | Date | - | - | マイルストーン開始日 |
| due_date | Date | - | - | マイルストーン終了日（期限） |

### 隠し項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| lock_version | Integer | 楽観的ロック用バージョン |

## 表示項目

### フォーム構成

| 項目名 | 入力タイプ | 説明 |
|--------|-----------|------|
| Title | テキストフィールド | マイルストーン名（必須、autofocus） |
| Start date | 日付ピッカー | 開始日 |
| Due date | 日付ピッカー | 終了日 |
| Description | Markdownエディタ | 説明文（プレビュー機能付き） |

### ボタン

| ボタン名 | 説明 |
|---------|------|
| Save changes | 変更を保存 |
| Cancel | 編集をキャンセルして詳細画面へ戻る |

## イベント仕様

### 1-Save changesボタン押下

フォームに入力された内容でマイルストーンを更新します。

**処理フロー**：
1. フォームデータをPATCH/PUTリクエストで送信
2. `Milestones::UpdateService`を呼び出してマイルストーンを更新
3. バリデーション成功時：マイルストーン詳細画面へリダイレクト
4. バリデーション失敗時：エラーメッセージを表示し、フォームを再表示
5. 楽観的ロックエラー時：コンフリクトメッセージを表示

### 2-Cancelボタン押下

マイルストーン詳細画面へ遷移します。

### 3-Markdownプレビュー

説明フィールドでプレビュータブを選択すると、入力されたMarkdownがレンダリングされて表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Save changes押下 | milestones | UPDATE | マイルストーン更新 |
| Save changes押下 | events | INSERT | 更新イベント記録 |

### テーブル別更新項目詳細

#### milestones

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | title | 入力されたタイトル | 必須 |
| UPDATE | description | 入力された説明 | 任意 |
| UPDATE | start_date | 入力された開始日 | 任意 |
| UPDATE | due_date | 入力された終了日 | 任意 |
| UPDATE | updated_at | 現在時刻 | |
| UPDATE | lock_version | +1 インクリメント | 楽観的ロック |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|---------|
| エラー | Title is too long (maximum is 255 characters) | タイトルが255文字を超える場合 |
| エラー | Title can't be blank | タイトルが空の場合 |
| エラー | already being used for another group or project milestone | 同名のマイルストーンが存在する場合 |
| エラー | Someone edited this milestone at the same time... | 楽観的ロックエラー時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| マイルストーンが存在しない | 404ページを表示 |
| 編集権限がない | 404ページを表示 |
| バリデーションエラー | フォームを再表示し、エラーメッセージを表示 |
| 楽観的ロックエラー（StaleObjectError） | コンフリクトメッセージを表示しフォームを再表示 |

## 備考

- 楽観的ロック（lock_version）により、同時編集時のデータ競合を検出します
- 同一プロジェクト・グループ内でマイルストーン名は一意である必要があります
- 説明フィールドはMarkdown形式に対応しています
- 日付フィールドはブラウザネイティブの日付ピッカーを使用します

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

マイルストーンのモデルとバリデーションを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | milestone.rb | `app/models/milestone.rb` | validates、lock_version |

**読解のコツ**: MilestoneモデルはOptimistic Locking（楽観的ロック）を使用しており、lock_versionカラムで同時編集を検出します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | milestones_controller.rb | `app/controllers/projects/milestones_controller.rb` | edit/updateアクション |

**主要処理フロー**:
1. **L51-53**: editアクションでフォームを表示
2. **L75-96**: updateアクションで更新処理
3. **L76**: `Milestones::UpdateService`を使用
4. **L97-115**: StaleObjectError（楽観的ロックエラー）のハンドリング

#### Step 3: サービスクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | update_service.rb | `app/services/milestones/update_service.rb` | マイルストーン更新ロジック |

#### Step 4: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | edit.html.haml | `app/views/projects/milestones/edit.html.haml` | 編集画面 |
| 4-2 | _form.html.haml | `app/views/projects/milestones/_form.html.haml` | フォームパーシャル（新規作成と共有） |

**主要処理フロー**:
- **edit.html.haml L7**: フォームパーシャルをレンダリング
- **_form.html.haml L4-5**: コンフリクト時のメッセージ表示
- **_form.html.haml L29**: lock_version隠しフィールド

### プログラム呼び出し階層図

```
Projects::MilestonesController#edit
    │
    └─ app/views/projects/milestones/edit.html.haml
           └─ _form.html.haml

Projects::MilestonesController#update
    │
    ├─ Milestones::UpdateService.new.execute
    │      ├─ Milestone.update
    │      └─ バリデーション実行
    │
    ├─ 成功時 → リダイレクト（詳細画面）
    │
    ├─ 失敗時 → フォーム再表示
    │
    └─ StaleObjectError → コンフリクトメッセージ表示
```

### データフロー図

```
[入力]                       [処理]                          [出力]

フォーム入力 ───▶ MilestonesController#update
(title, description,         │
 start_date, due_date,       ▼
 lock_version)      Milestones::UpdateService#execute
                             │
                             ▼
                   Milestone.update (ActiveRecord)
                             │
           ┌─────────────────┼─────────────────┐
           ▼                 ▼                 ▼
     バリデーション成功  バリデーション失敗  StaleObjectError
           │                 │                 │
           ▼                 ▼                 ▼
     リダイレクト      フォーム再表示   コンフリクト表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| milestones_controller.rb | `app/controllers/projects/milestones_controller.rb` | コントローラー | edit/updateアクション |
| milestone.rb | `app/models/milestone.rb` | モデル | マイルストーンのデータモデル |
| update_service.rb | `app/services/milestones/update_service.rb` | サービス | 更新処理ロジック |
| edit.html.haml | `app/views/projects/milestones/edit.html.haml` | テンプレート | 編集画面 |
| _form.html.haml | `app/views/projects/milestones/_form.html.haml` | 部分テンプレート | フォームパーシャル |
| _model_version_conflict.html.haml | `app/views/shared/_model_version_conflict.html.haml` | 部分テンプレート | コンフリクトメッセージ |
