# 画面設計書 56-ラベル一覧

## 概要

本ドキュメントは、GitLabにおけるプロジェクトラベル一覧画面に関する設計書です。プロジェクト内のラベルを一覧表示し、優先順位付けや管理を行うための画面仕様を定義します。

### 本画面の処理概要

**業務上の目的・背景**：ラベルは課題やマージリクエストを分類・フィルタリングするための重要な機能です。バグ、機能追加、優先度などのカテゴリでラベルを作成し、課題管理を効率化します。一覧画面では、ラベルの確認・優先順位付け・編集・削除を行い、プロジェクトのワークフローを整備します。

**画面へのアクセス方法**：プロジェクトのサイドナビゲーションから「Manage」→「Labels」を選択、または直接URL `/:namespace/:project/-/labels` にアクセスします。

**主要な操作・処理内容**：
1. ラベル一覧の表示（優先順位付きラベル・その他ラベル）
2. ラベルの検索（名前・説明による検索）
3. ラベルの優先順位付け（スター付与によるドラッグ＆ドロップ並び替え）
4. ラベルの購読/購読解除
5. 新規ラベルの作成（作成画面への遷移）
6. ラベルの編集（編集画面への遷移）
7. ラベルの削除
8. グループラベルへの昇格（権限がある場合）
9. ラベルのアーカイブ/アーカイブ解除

**画面遷移**：
- 遷移元：プロジェクトトップページ、課題一覧画面、課題ボード画面
- 遷移先：ラベル新規作成画面、ラベル編集画面

**権限による表示制御**：
- `read_label`権限：ラベルの閲覧が可能
- `admin_label`権限：ラベルの作成・編集・削除・優先順位変更が可能
- グループへの`admin_label`権限：グループラベルへの昇格が可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 40 | ラベル管理 | 主機能 | プロジェクトラベルの一覧表示 |
| 36 | イシュー作成 | 遷移先機能 | 課題へのラベル付与 |
| 39 | イシューボード | 補助機能 | ボードリストのラベル管理 |

## 画面種別

一覧画面

## URL/ルーティング

```
GET /:namespace/:project/-/labels
```

コントローラー: `Projects::LabelsController#index`

## 入出力項目

### フィルター項目

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| search | String | - | 名前・説明による検索 |
| subscribed | String | - | 購読中のラベルのみ表示 |
| archived | Boolean | - | アーカイブ済みラベルのみ表示 |
| sort | String | - | 並び順 |

### ページネーション

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| page | Integer | - | ページ番号 |

## 表示項目

### ヘッダー部

| 項目名 | 説明 |
|--------|------|
| ナビゲーションタブ | Labels / Subscribed / Archived（アーカイブ機能有効時） |
| 検索フォーム | ラベル検索入力欄 |
| ソートドロップダウン | 並び順の選択 |
| 新規作成ボタン | 新規ラベル作成画面への遷移（権限がある場合） |

### 優先ラベルセクション

| 項目名 | 説明 |
|--------|------|
| セクションタイトル | 「Prioritized labels」 |
| ラベル件数 | 優先ラベルの件数 |
| ラベルリスト | ドラッグ可能なラベル一覧 |

### その他ラベルセクション

| 項目名 | 説明 |
|--------|------|
| セクションタイトル | 「Other labels」 |
| ラベル件数 | その他ラベルの件数 |
| ラベルリスト | ラベル一覧 |
| ページネーション | ページ切り替え |

### ラベル項目

| 項目名 | 説明 |
|--------|------|
| ラベル色 | 背景色のプレビュー |
| ラベル名 | ラベルのタイトル |
| 説明 | ラベルの説明文 |
| 課題数リンク | 関連する課題一覧へのリンク |
| MR数リンク | 関連するMR一覧へのリンク |
| 購読ボタン | 購読/購読解除 |
| アクションボタン | 編集・削除・昇格・アーカイブ |

## イベント仕様

### 1-優先ラベルのドラッグ＆ドロップ

優先ラベルセクション内でラベルをドラッグ＆ドロップすると、優先順位が変更されます。

### 2-スター（優先化）ボタン押下

ラベルにスターを付けると、優先ラベルセクションに移動します。スターを外すとその他ラベルに戻ります。

### 3-検索実行

検索フォームに名前または説明を入力して検索すると、部分一致するラベルが表示されます。

### 4-購読/購読解除ボタン押下

ラベルを購読すると、そのラベルが付いた課題やMRの通知を受け取れます。

### 5-新規作成ボタン押下

新規ラベル作成画面（`/:namespace/:project/-/labels/new`）に遷移します。

### 6-編集ボタン押下

該当ラベルの編集画面（`/:namespace/:project/-/labels/:id/edit`）に遷移します。

### 7-削除ボタン押下

確認モーダルを表示後、ラベルを削除します。ロックされたラベルは削除できません。

### 8-グループへ昇格

プロジェクトラベルをグループラベルに昇格させます（グループへのadmin_label権限が必要）。

### 9-アーカイブ/アーカイブ解除

ラベルをアーカイブすると、課題やMRへの適用ができなくなります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | labels | SELECT | ラベル取得 |
| 優先順位変更 | label_priorities | INSERT/UPDATE/DELETE | 優先順位設定 |
| 購読/購読解除 | subscriptions | INSERT/UPDATE | 購読設定 |
| 削除 | labels | DELETE | ラベル削除 |
| 削除 | label_links | DELETE | ラベルリンク削除 |

### テーブル別更新項目詳細

#### label_priorities

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | project_id | 現在のプロジェクトID | |
| INSERT | label_id | 対象ラベルID | |
| INSERT | priority | 優先順位値 | |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|---------|
| 成功 | {label_name} was removed | 削除成功時 |
| 成功 | {label_name} promoted to group label | 昇格成功時 |
| 情報 | Labels can be applied to issues and merge requests. Star a label to make it a priority label. | 通常表示 |
| 情報 | Archived labels are not available for use. | アーカイブタブ表示時 |
| エラー | {label_name} is locked and was not removed | ロックされたラベルの削除試行時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| プロジェクトが存在しない | 404ページを表示 |
| 閲覧権限がない | 403エラーを返却 |
| ロックされたラベルの削除 | エラーメッセージを表示 |

## 備考

- ラベルはプロジェクトラベルとグループラベルがあり、両方がこの画面に表示されます
- 優先ラベルはドラッグ＆ドロップで並び替えが可能です（admin_label権限が必要）
- ラベルのアーカイブ機能はフィーチャーフラグ（labels_archive）で制御されます
- lock_on_merge属性が設定されたラベルは削除できません
- JSON形式でのレスポンスにも対応しており、APIからの取得も可能です

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ラベルのモデルと関連を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | label.rb | `app/models/label.rb` | Labelモデルの定義、スコープ |
| 1-2 | label_priority.rb | `app/models/label_priority.rb` | 優先順位管理 |

**読解のコツ**: LabelはProjectまたはGroupに属し、LabelPriorityを通じて優先順位が管理されます。prioritized/unprioritizedスコープに注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | labels_controller.rb | `app/controllers/projects/labels_controller.rb` | indexアクション |

**主要処理フロー**:
1. **L24-42**: indexアクションでラベル一覧を取得
2. **L27-31**: @prioritized_labelsと@labelsを分離
3. **L35-36**: LabelsPreloaderで関連データをプリロード
4. **L112-127**: set_prioritiesで優先順位を一括設定

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/projects/labels/index.html.haml` | 一覧画面テンプレート |
| 3-2 | _label.html.haml | `app/views/shared/_label.html.haml` | 個別ラベルパーシャル |

**主要処理フロー**:
- **L15-18**: labels_archiveフィーチャーフラグによるナビゲーション表示
- **L30-52**: 優先ラベルとその他ラベルのセクション分離
- **L37**: ドラッグ可能なラベルリスト

### プログラム呼び出し階層図

```
Projects::LabelsController#index
    │
    ├─ LabelsFinder#execute
    │      ├─ 検索フィルタリング
    │      ├─ 購読フィルタ
    │      └─ アーカイブフィルタ
    │
    ├─ Label.prioritized / Label.unprioritized
    │      └─ 優先順位による分類
    │
    ├─ Preloaders::LabelsPreloader
    │      └─ 関連データのプリロード
    │
    └─ app/views/projects/labels/index.html.haml
           ├─ shared/labels/_nav
           ├─ Prioritized labels セクション
           │      └─ shared/_label パーシャル
           └─ Other labels セクション
                  └─ shared/_label パーシャル
```

### データフロー図

```
[入力]                       [処理]                          [出力]

URLパラメータ ───▶ LabelsController#index
(search, subscribed,         │
 archived, sort)             ▼
                   LabelsFinder#execute ───▶ @available_labels
                             │
                   ┌─────────┴─────────┐
                   ▼                   ▼
             prioritized         unprioritized
                   │                   │
                   ▼                   ▼
           @prioritized_labels    @labels
                   │                   │
                   └───────┬───────────┘
                           ▼
                   index.html.haml ───▶ HTML応答
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| labels_controller.rb | `app/controllers/projects/labels_controller.rb` | コントローラー | ラベル画面のエントリーポイント |
| label.rb | `app/models/label.rb` | モデル | ラベルのデータモデル |
| label_priority.rb | `app/models/label_priority.rb` | モデル | 優先順位管理 |
| labels_finder.rb | `app/finders/labels_finder.rb` | Finder | 検索ロジック |
| labels_preloader.rb | `app/models/preloaders/labels_preloader.rb` | Preloader | 関連データのプリロード |
| index.html.haml | `app/views/projects/labels/index.html.haml` | テンプレート | 一覧画面 |
| _label.html.haml | `app/views/shared/_label.html.haml` | 部分テンプレート | 個別ラベル表示 |
| promote_service.rb | `app/services/labels/promote_service.rb` | サービス | 昇格処理 |
