# 画面設計書 59-作業アイテム一覧

## 概要

本ドキュメントは、GitLabにおけるプロジェクト作業アイテム（Work Items）一覧画面に関する設計書です。Epics、Tasks、Objectivesなどの様々なタイプの作業アイテムを一覧表示し、管理するための画面仕様を定義します。

### 本画面の処理概要

**業務上の目的・背景**：Work Items（作業アイテム）は、従来のIssueを発展させた新しいワークアイテム管理システムです。Epics、Tasks、Objectives、Key Resultsなど、様々なタイプのワークアイテムを統一的なインターフェースで管理できます。この機能はGitLabのプランニング機能を強化し、より柔軟なプロジェクト管理を可能にします。

**画面へのアクセス方法**：プロジェクトのサイドナビゲーションから「Plan」→「Work items」を選択、または直接URL `/:namespace/:project/-/work_items` にアクセスします。

**主要な操作・処理内容**：
1. 作業アイテム一覧の表示（タイプ別フィルタリング）
2. 作業アイテムの検索・フィルタリング
3. 作業アイテムの並び替え
4. 新規作業アイテムの作成
5. 作業アイテム詳細の閲覧（詳細画面への遷移）
6. CSVインポート機能（権限がある場合）

**画面遷移**：
- 遷移元：プロジェクトトップページ、課題一覧画面
- 遷移先：作業アイテム詳細画面、作業アイテム新規作成画面

**権限による表示制御**：
- プロジェクトメンバー：作業アイテムの閲覧・作成が可能
- `import_work_items`権限：CSVインポートが可能
- work_items_consolidated_list_enabled：統合一覧ビューの有効化

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 46 | ワークアイテム管理 | 主機能 | 作業アイテムの一覧表示 |
| 36 | イシュー作成 | 補助機能 | 作業アイテムとしてのIssue管理 |

## 画面種別

一覧画面（Vue.js SPA）

## URL/ルーティング

```
GET /:namespace/:project/-/work_items
```

コントローラー: `Projects::WorkItemsController#index`

## 入出力項目

### フィルター項目

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| type | Array[String] | - | 作業アイテムタイプによるフィルタ（Epic, Task等） |
| state | String | - | 状態フィルタ（opened/closed/all） |
| assignee | Array[String] | - | 担当者によるフィルタ |
| label | Array[String] | - | ラベルによるフィルタ |
| milestone | String | - | マイルストーンによるフィルタ |
| search | String | - | キーワード検索 |

## 表示項目

### ヘッダー部

| 項目名 | 説明 |
|--------|------|
| タイトル | 「Work items」 |
| フィルターバー | 各種フィルタ条件の設定 |
| 並び替えドロップダウン | 並び順の選択 |
| 新規作成ボタン | 新規作業アイテム作成 |

### 作業アイテム一覧

| 項目名 | 説明 |
|--------|------|
| アイテムアイコン | 作業アイテムタイプのアイコン |
| タイトル | 作業アイテムのタイトル（リンク） |
| IID | 作業アイテムの識別番号 |
| ラベル | 付与されているラベル |
| 担当者アバター | 担当者のアバター画像 |
| マイルストーン | 関連付けられたマイルストーン |
| 作成日時 | 作成日時の相対表示 |
| コメント数 | コメント数のアイコン表示 |

## イベント仕様

### 1-フィルター変更

フィルターバーで条件を変更すると、該当する作業アイテムのみが表示されます。GraphQL APIを通じて非同期でデータを取得します。

### 2-検索実行

検索フォームにキーワードを入力して検索すると、タイトルや説明に一致する作業アイテムが表示されます。

### 3-並び替え変更

並び替えドロップダウンで選択すると、指定した順序で作業アイテムが再表示されます。

### 4-新規作成ボタン押下

作業アイテム新規作成画面に遷移、またはモーダルが表示されます。

### 5-作業アイテム行クリック

該当作業アイテムの詳細画面（`/:namespace/:project/-/work_items/:iid`）に遷移します。

### 6-CSVインポート

CSVファイルをアップロードして作業アイテムを一括インポートします（権限がある場合）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | issues | SELECT | 作業アイテム取得（WorkItemはIssueを継承） |
| CSVインポート | issues | INSERT | 作業アイテム一括作成 |
| CSVインポート | label_links | INSERT | ラベル関連付け |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|---------|
| 成功 | Import started | CSVインポート開始時 |
| 情報 | No work items to show | 作業アイテムが存在しない場合 |
| エラー | The uploaded file was invalid | 不正なファイル形式の場合 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| プロジェクトが存在しない | 404ページを表示 |
| 閲覧権限がない | 403エラーを返却 |
| インポート権限がない | インポート機能を非表示 |

## 備考

- Work Items機能はVue.jsベースのSPAとして実装されており、GraphQL APIを通じてデータを取得します
- Work ItemsはIssueモデルを継承しており、内部的には同じテーブル（issues）を使用します
- フィーチャーフラグ（work_item_planning_view）で統合一覧ビューの表示が制御されます
- CSVインポートは非同期で処理され、完了時に通知されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Work Itemのモデルと継承関係を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | work_item.rb | `app/models/work_item.rb` | WorkItemモデル、Issueからの継承 |
| 1-2 | issue.rb | `app/models/issue.rb` | 基底クラスの構造 |
| 1-3 | work_item_type.rb | `app/models/work_items/type.rb` | 作業アイテムタイプの定義 |

**読解のコツ**: WorkItemはIssueを継承しており、table_nameは'issues'です。work_item_type_idで種別を区別します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | work_items_controller.rb | `app/controllers/projects/work_items_controller.rb` | indexアクション |

**主要処理フロー**:
1. **L11-17**: before_actionでフラグ設定
2. **L43**: indexアクションは空（Vue.jsでレンダリング）
3. **L30-41**: import_csvアクションでCSVインポート

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/projects/work_items/index.html.haml` | 一覧画面テンプレート |

**主要処理フロー**:
- **L6**: `#js-work-items`がVue.jsアプリケーションのマウントポイント
- **L6**: `work_item_views_only_data`ヘルパーでフロントエンドにデータを渡す

#### Step 4: GraphQL APIを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | work_items_finder.rb | `app/finders/work_items/work_items_finder.rb` | 作業アイテム検索ロジック |

### プログラム呼び出し階層図

```
Projects::WorkItemsController#index
    │
    └─ app/views/projects/work_items/index.html.haml
           │
           └─ #js-work-items (Vue.js Application)
                  │
                  ├─ GraphQL API呼び出し
                  │      └─ WorkItems::WorkItemsFinder
                  │
                  └─ Vuex Store / Apollo Client
                         └─ 一覧レンダリング

Projects::WorkItemsController#import_csv
    │
    ├─ WorkItems::PrepareImportCsvService
    │      └─ 非同期インポート処理のキューイング
    │
    └─ JSON応答
```

### データフロー図

```
[入力]                       [処理]                          [出力]

URLアクセス ───▶ WorkItemsController#index
                        │
                        ▼
               Vue.js Application マウント
                        │
                        ▼
               GraphQL API呼び出し ───▶ WorkItemsFinder
                        │
                        ▼
               作業アイテム一覧取得 ───▶ 画面レンダリング
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| work_items_controller.rb | `app/controllers/projects/work_items_controller.rb` | コントローラー | 作業アイテム画面のエントリーポイント |
| work_item.rb | `app/models/work_item.rb` | モデル | 作業アイテムのデータモデル |
| work_items_finder.rb | `app/finders/work_items/work_items_finder.rb` | Finder | 検索ロジック |
| index.html.haml | `app/views/projects/work_items/index.html.haml` | テンプレート | 一覧画面 |
| work_items_helper.rb | `app/helpers/work_items_helper.rb` | ヘルパー | work_item_views_only_data等 |
| prepare_import_csv_service.rb | `app/services/work_items/prepare_import_csv_service.rb` | サービス | CSVインポート準備 |
