# 画面設計書 6-メール確認再送画面

## 概要

本ドキュメントは、GitLabのメール確認再送画面の設計仕様を記載したものです。メールアドレス確認メールを再送するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：メール確認再送画面は、ユーザー登録時の確認メールを受け取れなかった場合や、確認メールの有効期限が切れた場合に、再度確認メールを送信するための機能を提供します。メールアドレスの確認はアカウントセキュリティの重要な要素であり、この画面によりユーザーは自身でメール確認プロセスを再開できます。reCAPTCHAによるボット対策も実装されています。

**画面へのアクセス方法**：
- ログイン画面で「メールアドレス未確認」エラーが表示された際のリンクをクリック
- パスワード変更画面からのリンクをクリック
- 直接 `/users/confirmation/new` URLにアクセス

**主要な操作・処理内容**：
1. プライマリメールアドレスの入力
2. reCAPTCHAの完了（設定時）
3. 確認メールの再送要求
4. 送信完了メッセージの表示

**画面遷移**：
- 遷移元：ログイン画面（メール未確認時）、パスワード変更画面
- 遷移先：メール確認待ち画面（再送成功時）、ダッシュボード（ソフト確認モード時）

**権限による表示制御**：
- 未認証ユーザーがアクセス可能
- セカンダリメールの確認はプロフィール設定画面から行う（本画面はプライマリメール専用）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 82 | メール管理 | 主機能 | 確認メールの再送要求処理 |

## 画面種別

入力フォーム

## URL/ルーティング

| HTTPメソッド | URL | アクション |
|-------------|-----|----------|
| GET | `/users/confirmation/new` | メール確認再送画面表示 |
| POST | `/users/confirmation` | 確認メール再送処理 |
| GET | `/users/confirmation` | メール確認処理（トークン付き） |

## 入出力項目

### 入力項目

| 項目名 | 物理名 | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| メールアドレス | user[email] | string | Yes | 255 | プライマリメールアドレス |
| reCAPTCHA | - | token | 条件付き | - | reCAPTCHA有効時に必要 |

## 表示項目

| 項目名 | 説明 | 条件 |
|--------|------|------|
| タイトル | 「Resend confirmation instructions」 | 常時表示 |
| メール入力フォーム | メールアドレス入力欄 | 常時表示 |
| 説明テキスト | プライマリメールが必要、セカンダリはEmails設定からの説明 | 常時表示 |
| reCAPTCHA | ボット対策用ウィジェット | reCAPTCHA設定時 |
| Resendボタン | 確認メール再送ボタン | 常時表示 |
| Sign inリンク | ログイン画面へのリンク | 常時表示 |
| エラーメッセージ | 入力エラー表示領域 | エラー発生時 |

## イベント仕様

### 1-Resendボタン押下

**トリガー**: 「Resend」ボタンクリック

**処理フロー**:
1. フォームバリデーション（クライアントサイド）
2. reCAPTCHA検証（設定時）
3. メールアドレスでユーザー検索
4. 確認トークン生成
5. 確認メール再送
6. リダイレクト（設定による）

**成功時**:
- ハード確認モード: メール確認待ち画面にリダイレクト
- ソフト確認モード: ダッシュボードにリダイレクト

**失敗時**: エラーメッセージを表示してフォームに戻る

### 2-Sign inリンククリック

**トリガー**: 「Sign in」リンククリック

**処理**: ログイン画面（`/users/sign_in`）にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 確認メール再送 | users | UPDATE | 確認トークン更新 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | confirmation_token | ハッシュ化されたトークン | Devise token generator使用 |
| UPDATE | confirmation_sent_at | 現在時刻 | 再送時刻記録 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|---------------|----------|
| MSG001 | 情報 | If your email address exists in our database, you will receive an email with instructions on how to confirm your email address in a few minutes. | 確認メール再送成功時 |
| MSG002 | エラー | Email can't be blank | メールアドレス未入力時 |
| MSG003 | エラー | Email is invalid | メールアドレス形式不正時 |
| MSG004 | エラー | There was an error with the reCAPTCHA | reCAPTCHA失敗時 |
| MSG005 | 説明 | Requires your primary GitLab email address. If you want to confirm a secondary email address, go to Emails | 画面説明文 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| メールアドレス未登録 | セキュリティ上、成功時と同じメッセージを表示 |
| 既に確認済み | セキュリティ上、成功時と同じメッセージを表示 |
| reCAPTCHA失敗 | エラーメッセージを表示してフォームに戻る |
| メール送信失敗 | システムエラーとしてログに記録 |

## 備考

- Deviseの `confirmable` モジュールにより実装
- プライマリメールアドレス専用（セカンダリメールはProfile > Emailsから確認）
- セキュリティ上、メールアドレスの存在有無に関わらず同じメッセージを表示する
- 確認トークンの有効期限はDevise設定で定義
- ソフト確認モードでは確認前でもログイン可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メール確認に関連するユーザーモデルの属性を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | Deviseの`:confirmable`モジュール、confirmation_token属性 |

**読解のコツ**: `devise :confirmable` によりメール確認機能が有効化される（120行目）。

#### Step 2: エントリーポイントを理解する

コントローラーの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | confirmations_controller.rb | `app/controllers/confirmations_controller.rb` | new/createアクション |

**主要処理フロー**:
- **8-9行目**: reCAPTCHA検証のbefore_action
- **74-78行目**: 確認メール再送後のリダイレクト先決定

#### Step 3: ビューテンプレートを理解する

画面の構成要素を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/devise/confirmations/new.html.haml` | フォーム構成 |

**主要処理フロー**:
- **1行目**: タブタイトル「Resend confirmation instructions」
- **5-10行目**: メールアドレス入力と説明テキスト
- **12-14行目**: reCAPTCHAタグ（条件付き）
- **16-17行目**: 送信ボタン

### プログラム呼び出し階層図

```
ConfirmationsController#create
    │
    ├─ check_recaptcha (prepend_before_action)
    │      └─ verify_recaptcha
    │
    ├─ Devise::ConfirmationsController#create (super)
    │      ├─ User.send_confirmation_instructions(email: params[:email])
    │      │      ├─ find_by_email
    │      │      ├─ generate_confirmation_token!
    │      │      └─ DeviseMailer.confirmation_instructions
    │      │
    │      └─ redirect_to after_resending_confirmation_instructions_path
    │
    └─ after_resending_confirmation_instructions_path_for
           └─ users_almost_there_path または dashboard_projects_path
```

### データフロー図

```
[入力]                    [処理]                              [出力]

user[email]      ───▶ ConfirmationsController#create ───▶ リダイレクト
                        │
                        ├─ User.find_by_email ───▶ users テーブル SELECT
                        │
                        ├─ generate_confirmation_token! ───▶ users テーブル UPDATE
                        │      (confirmation_token, confirmation_sent_at)
                        │
                        └─ DeviseMailer.confirmation_instructions ───▶ メール送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| confirmations_controller.rb | `app/controllers/confirmations_controller.rb` | コントローラー | メール確認処理の制御 |
| user.rb | `app/models/user.rb` | モデル | ユーザーデータと確認管理 |
| new.html.haml | `app/views/devise/confirmations/new.html.haml` | ビュー | メール確認再送画面テンプレート |
| gitlab_recaptcha.rb | `app/controllers/concerns/gitlab_recaptcha.rb` | Concern | reCAPTCHA検証処理 |
| _sign_in_link.html.haml | `app/views/devise/shared/_sign_in_link.html.haml` | ビュー | ログインリンクパーシャル |
