# 画面設計書 66-パイプライン一覧

## 概要

本ドキュメントは、GitLabプロジェクトのCI/CDパイプライン一覧画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、プロジェクト内のCI/CDパイプラインを一覧形式で表示し、継続的インテグレーション/継続的デリバリーの実行状況を管理するための画面である。パイプラインの状態確認、手動実行、キャンセル、リトライなどの操作を提供する。

**業務上の目的・背景**：CI/CDはモダンなソフトウェア開発において必須のプラクティスであり、コードの品質維持と迅速なデリバリーを実現する。本画面は、プロジェクト内で実行されるすべてのパイプラインを一元管理し、ビルド、テスト、デプロイの状況を可視化することで、開発チームが迅速に問題を検知し対応できる環境を提供する。

**画面へのアクセス方法**：
1. プロジェクトページの左側ナビゲーションメニューから「Build」>「Pipelines」を選択
2. URLに直接`/-/pipelines`を入力

**主要な操作・処理内容**：
1. パイプライン一覧の表示（状態、ブランチ、コミット情報）
2. 状態別フィルタリング（running, pending, success, failed等）
3. ブランチ、ユーザー、ソース別フィルタリング
4. 新規パイプラインの手動実行
5. パイプラインのキャンセル
6. 失敗したパイプラインのリトライ
7. パイプライン詳細画面への遷移
8. パイプラインアナリティクスへの遷移

**画面遷移**：
- 遷移元：プロジェクトトップページ、ナビゲーションメニュー、MR詳細画面
- 遷移先：パイプライン詳細画面、パイプライン新規作成画面、パイプラインエディタ

**権限による表示制御**：
- 閲覧権限（Guest以上、設定による）：パイプライン一覧の表示
- 実行権限（Developer以上）：手動パイプライン実行
- キャンセル権限（Developer以上）：パイプラインのキャンセル

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | パイプライン実行 | 主機能 | CI/CDパイプラインの一覧表示 |

## 画面種別

一覧

## URL/ルーティング

| メソッド | URL | アクション | 説明 |
|----------|-----|-----------|------|
| GET | `/:namespace_id/:project_id/-/pipelines` | index | パイプライン一覧画面表示 |
| GET | `/:namespace_id/:project_id/-/pipelines.json` | index | JSON形式データ取得 |

## 入出力項目

### フィルタリング項目

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| scope | string | - | スコープ（running/pending/finished/branches/tags） |
| status | string | - | 状態（running/pending/success/failed/canceled/skipped/manual） |
| ref | string | - | ブランチ/タグ名 |
| username | string | - | 実行ユーザー名 |
| source | string | - | ソース（push/web/trigger/schedule/api等） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| パイプラインID | integer | パイプラインのID |
| 状態 | string | running/pending/success/failed等 |
| コミットSHA | string | 対象コミットのSHA |
| コミットタイトル | string | コミットメッセージの先頭行 |
| ブランチ/タグ | string | 対象のref |
| ステージ | object[] | パイプラインのステージ一覧 |
| 実行ユーザー | object | パイプラインを実行したユーザー |
| 実行時間 | duration | パイプラインの実行時間 |
| 作成日時 | datetime | パイプライン作成日時 |
| 完了日時 | datetime | パイプライン完了日時 |
| アクション | array | 利用可能なアクション（retry, cancel等） |

## イベント仕様

### 1-フィルター適用

フィルター条件を変更すると、URLパラメータが更新され、APIリクエストで一覧が再取得される。

### 2-新規パイプライン作成ボタン押下

「Run pipeline」ボタンをクリックすると、パイプライン新規作成画面に遷移する。

### 3-パイプラインキャンセル

パイプライン行のキャンセルボタンをクリックすると、確認なしでパイプラインがキャンセルされる。

### 4-パイプラインリトライ

パイプライン行のリトライボタンをクリックすると、失敗したジョブが再実行される。

### 5-パイプライン行クリック

パイプライン一覧の行をクリックすると、該当パイプラインの詳細画面に遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | ci_pipelines | SELECT | パイプライン一覧の取得 |
| 一覧表示 | ci_stages | SELECT | ステージ情報の取得 |
| 一覧表示 | ci_builds | SELECT | ジョブ状態の取得 |
| キャンセル | ci_pipelines | UPDATE | status更新 |
| キャンセル | ci_builds | UPDATE | 各ジョブのstatus更新 |
| リトライ | ci_builds | INSERT | 新規ジョブレコード作成 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 情報 | No pipelines to show | パイプラインがない場合 |
| 情報 | Get started with Pipelines | CI設定がない場合 |
| 警告 | CI/CD configuration file is invalid | gitlab-ci.yml構文エラー |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| プロジェクトが見つからない | 404エラーページを表示 |
| 閲覧権限がない | 403エラーページを表示 |
| APIタイムアウト | エラーメッセージを表示 |

## 備考

- ポーリング間隔は10秒（POLLING_INTERVAL）
- Vue.jsコンポーネントで実装（#pipelines-list-vue）
- ページネーションあり
- パイプラインアナリティクスへのリンク提供

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pipelines_controller.rb | `app/controllers/projects/pipelines_controller.rb` | indexアクションの処理フロー |

**主要処理フロー**:
1. **行58-79**: `index`アクション - Finderでパイプライン取得、HTML/JSON応答
2. **行47**: POLLING_INTERVAL定数（10,000ms）

#### Step 2: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html.haml | `app/views/projects/pipelines/index.html.haml` | Vueマウントポイント |
| 2-2 | pipelines_helper.rb | `app/helpers/ci/pipelines_helper.rb` | `pipelines_list_data`メソッド（行50-76） |

**主要処理フロー**:
- **行10**: `#pipelines-list-vue`でVueコンポーネントをマウント
- **行7-8**: API URLの設定

### プログラム呼び出し階層図

```
HTTP Request (GET /project/-/pipelines)
    │
    ├─ PipelinesController#index
    │      │
    │      ├─ Ci::PipelinesFinder#execute
    │      │      └─ パイプラインのフィルタリング
    │      │
    │      └─ respond_to
    │             ├─ format.html → render index.html.haml
    │             │                    └─ Vue.js マウント
    │             └─ format.json → PipelineSerializer
    │
    └─ Vue.js コンポーネント (フロントエンド)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pipelines_controller.rb | `app/controllers/projects/pipelines_controller.rb` | コントローラー | リクエストハンドリング |
| index.html.haml | `app/views/projects/pipelines/index.html.haml` | ビュー | HTMLテンプレート |
| pipelines_helper.rb | `app/helpers/ci/pipelines_helper.rb` | ヘルパー | ビューヘルパー |
| pipeline_serializer.rb | `app/serializers/pipeline_serializer.rb` | シリアライザー | JSON変換 |
| pipelines.rb | `config/routes/pipelines.rb` | ルーティング | URL定義 |
