# 画面設計書 67-パイプライン新規作成

## 概要

本ドキュメントは、GitLabプロジェクトのパイプライン新規作成画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、CI/CDパイプラインを手動で実行するための画面である。対象ブランチの選択、変数の設定を行い、新しいパイプラインを作成・実行できる。

**業務上の目的・背景**：通常パイプラインはコードのプッシュや定期スケジュールによって自動実行されるが、特定の条件でのテストやデバッグ目的で手動実行が必要となるケースがある。本画面は、開発者やCI/CD管理者が任意のタイミングでパイプラインを実行できる機能を提供する。変数を指定することで、同じパイプライン定義でも異なる動作を実現できる。

**画面へのアクセス方法**：
1. パイプライン一覧画面から「Run pipeline」ボタンをクリック
2. URLに直接`/-/pipelines/new`を入力

**主要な操作・処理内容**：
1. 対象ブランチ/タグの選択
2. パイプライン変数の追加
3. パイプラインの実行

**画面遷移**：
- 遷移元：パイプライン一覧画面
- 遷移先：パイプライン詳細画面（作成成功時）、同画面（エラー時）

**権限による表示制御**：
- パイプライン作成権限（Developer以上）：画面へのアクセス
- 変数設定権限：パイプライン変数の設定可否

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | パイプライン実行 | 主機能 | 新規パイプラインの作成と実行 |

## 画面種別

新規作成

## URL/ルーティング

| メソッド | URL | アクション | 説明 |
|----------|-----|-----------|------|
| GET | `/:namespace_id/:project_id/-/pipelines/new` | new | 新規作成画面表示 |
| POST | `/:namespace_id/:project_id/-/pipelines` | create | パイプライン作成実行 |
| POST | `/:namespace_id/:project_id/-/pipelines.json` | create | パイプライン作成（JSON） |

## 入出力項目

### 入力項目

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| ref | string | ○ | 対象ブランチ/タグ |
| variables_attributes | array | - | パイプライン変数 |
| variables_attributes[].key | string | - | 変数キー |
| variables_attributes[].variable_type | string | - | 変数タイプ（env_var/file） |
| variables_attributes[].secret_value | string | - | 変数値 |
| inputs | hash | - | パイプライン入力パラメータ |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| プロジェクト名 | string | 対象プロジェクトの名前 |
| デフォルトブランチ | string | プロジェクトのデフォルトブランチ |
| ブランチ/タグ選択 | select | ref一覧（ブランチ・タグ） |
| 変数入力フォーム | form | 動的に追加可能な変数入力欄 |
| パイプラインエディタリンク | link | .gitlab-ci.yml編集画面へのリンク |
| 設定リンク | link | CI/CD設定画面へのリンク |
| 警告メッセージ | array | CI設定に関する警告 |

## イベント仕様

### 1-ブランチ/タグ選択

ブランチ/タグのドロップダウンから対象のrefを選択する。選択時にrefs_project_pathエンドポイントからref一覧を取得する。

### 2-変数追加

「Add variable」ボタンをクリックすると、新しい変数入力フォーム（キー、値、タイプ）が追加される。

### 3-変数削除

各変数入力フォームの削除ボタンをクリックすると、該当の変数フォームが削除される。

### 4-パイプライン実行

「Run pipeline」ボタンをクリックすると、入力内容でPOSTリクエストが送信され、パイプラインが作成される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パイプライン作成 | ci_pipelines | INSERT | パイプラインレコード作成 |
| パイプライン作成 | ci_stages | INSERT | ステージレコード作成 |
| パイプライン作成 | ci_builds | INSERT | ジョブレコード作成 |
| パイプライン作成 | ci_pipeline_variables | INSERT | パイプライン変数の保存 |

### テーブル別更新項目詳細

#### ci_pipelines

| 項目 | 説明 |
|------|------|
| project_id | プロジェクトID |
| ref | 対象ブランチ/タグ |
| sha | 対象コミットのSHA |
| source | 'web'（手動実行のため） |
| user_id | 実行ユーザーID |
| status | 初期状態（pending/created） |

#### ci_pipeline_variables

| 項目 | 説明 |
|------|------|
| pipeline_id | パイプラインID |
| key | 変数キー |
| value | 変数値（暗号化） |
| variable_type | 変数タイプ |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| エラー | (バリデーションエラー) | 入力不正時 |
| 警告 | (CI設定警告) | .gitlab-ci.ymlに警告がある場合 |
| 情報 | Pipeline created successfully | 作成成功時（リダイレクト） |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| プロジェクトが見つからない | 404エラーページを表示 |
| 作成権限がない | 403エラーページを表示 |
| CI設定が無効 | エラーメッセージを表示 |
| .gitlab-ci.ymlが存在しない | エラーメッセージを表示 |
| refが無効 | バリデーションエラーを表示 |

## 備考

- Vue.jsコンポーネントで実装（#js-new-pipeline）
- 最大警告数はMAX_LIMIT（25件）
- パイプラインエディタへのリンクを提供
- ユーザーロールに応じた権限制御

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pipelines_controller.rb | `app/controllers/projects/pipelines_controller.rb` | newとcreateアクション |

**主要処理フロー**:
1. **行81-83**: `new`アクション - 新規パイプラインオブジェクトの初期化
2. **行85-114**: `create`アクション - CreatePipelineServiceによるパイプライン作成
3. **行252-254**: `create_params` - 許可されるパラメータの定義
4. **行256-258**: `create_execute_params` - 実行時パラメータの定義

#### Step 2: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | new.html.haml | `app/views/projects/pipelines/new.html.haml` | メインビュー（行1-7） |
| 2-2 | pipelines_helper.rb | `app/helpers/ci/pipelines_helper.rb` | `new_pipeline_data`メソッド（行84-101） |

**主要処理フロー**:
- **行7**: `#js-new-pipeline`でVueコンポーネントをマウント
- `new_pipeline_data`メソッドで以下のデータを設定：
  - project_id, pipelines_path, default_branch
  - pipeline_editor_path, ref_param, var_param
  - project_refs_endpoint, settings_link
  - max_warnings, user_role, can_set_pipeline_variables

### プログラム呼び出し階層図

```
HTTP Request (GET /project/-/pipelines/new)
    │
    ├─ PipelinesController#new
    │      │
    │      └─ @pipeline = project.all_pipelines.new(ref: default_branch)
    │             │
    │             └─ render 'new'
    │                    └─ Vue.js マウント (#js-new-pipeline)
    │
    └─ Vue.js コンポーネント (フロントエンド)
           └─ refs_project_path → ref一覧取得

HTTP Request (POST /project/-/pipelines)
    │
    ├─ PipelinesController#create
    │      │
    │      ├─ create_params (ref, variables_attributes)
    │      │
    │      ├─ create_execute_params (inputs)
    │      │
    │      └─ Ci::CreatePipelineService#execute
    │             │
    │             ├─ パイプライン作成
    │             ├─ ステージ・ジョブ作成
    │             └─ 変数保存
    │                    │
    │                    └─ 成功: redirect_to pipeline_path
    │                    └─ 失敗: render 'new', status: :bad_request
    │
    └─ JSON応答（Ajax時）
           ├─ 成功: PipelineSerializer → 201 Created
           └─ 失敗: errors, warnings → 400 Bad Request
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ref（ブランチ/タグ） ──▶ PipelinesController#create ──▶ パイプライン作成
                              │
variables ──────────────────▶ │
                              │
inputs ─────────────────────▶ └─ Ci::CreatePipelineService
                                       │
                                       ├─ .gitlab-ci.yml 解析
                                       │
                                       ├─ ステージ・ジョブ生成
                                       │
                                       └─ ci_pipelines, ci_stages,
                                          ci_builds テーブル
                                                 │
                                                 ▼
                                   ──────────▶ パイプライン詳細画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pipelines_controller.rb | `app/controllers/projects/pipelines_controller.rb` | コントローラー | リクエストハンドリング |
| new.html.haml | `app/views/projects/pipelines/new.html.haml` | ビュー | メインビュー |
| pipelines_helper.rb | `app/helpers/ci/pipelines_helper.rb` | ヘルパー | データ準備 |
| create_pipeline_service.rb | `app/services/ci/create_pipeline_service.rb` | サービス | パイプライン作成ロジック |
| pipelines.rb | `config/routes/pipelines.rb` | ルーティング | URL定義 |
