# 画面設計書 68-パイプライン詳細

## 概要

本ドキュメントは、GitLabプロジェクトのパイプライン詳細画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、特定のCI/CDパイプラインの詳細情報を表示する画面である。パイプラインのステータス、ステージ構成、ジョブの実行状況、テストレポート、アーティファクトなどを確認できる。

**業務上の目的・背景**：CI/CDパイプラインの実行状況を詳細に把握し、問題が発生した場合の原因特定や、実行結果の確認を行うための画面である。開発者やCI/CD管理者がパイプラインの進捗をリアルタイムで監視し、必要に応じて操作（キャンセル、リトライ）を行える。

**画面へのアクセス方法**：
1. パイプライン一覧画面からパイプライン行をクリック
2. MR詳細画面のパイプラインウィジェットからリンク
3. URLに直接`/-/pipelines/:id`を入力

**主要な操作・処理内容**：
1. パイプライン全体の状態確認
2. ステージ別のジョブ状況確認
3. 失敗したジョブの確認
4. テストレポートの確認
5. パイプラインのキャンセル
6. 失敗したジョブのリトライ
7. アーティファクトのダウンロード

**画面遷移**：
- 遷移元：パイプライン一覧画面、MR詳細画面、コミット詳細画面
- 遷移先：ジョブ詳細画面、パイプラインエディタ、パイプライン一覧画面

**権限による表示制御**：
- 閲覧権限（Guest以上、設定による）：パイプライン詳細の表示
- 更新権限（Developer以上）：リトライ、キャンセル操作
- 変数閲覧権限：パイプライン変数の表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | パイプライン実行 | 主機能 | パイプライン詳細の表示 |

## 画面種別

詳細

## URL/ルーティング

| メソッド | URL | アクション | 説明 |
|----------|-----|-----------|------|
| GET | `/:namespace_id/:project_id/-/pipelines/:id` | show | パイプライン詳細画面表示 |
| GET | `/:namespace_id/:project_id/-/pipelines/:id.json` | show | パイプライン詳細（JSON） |
| POST | `/:namespace_id/:project_id/-/pipelines/:id/cancel` | cancel | パイプラインキャンセル |
| POST | `/:namespace_id/:project_id/-/pipelines/:id/retry` | retry | パイプラインリトライ |
| GET | `/:namespace_id/:project_id/-/pipelines/:id/builds` | builds | ビルド一覧タブ |
| GET | `/:namespace_id/:project_id/-/pipelines/:id/failures` | failures | 失敗ジョブタブ |
| GET | `/:namespace_id/:project_id/-/pipelines/:id/test_report` | test_report | テストレポートタブ |
| GET | `/:namespace_id/:project_id/-/pipelines/:id/status` | status | ステータス取得（JSON） |
| GET | `/:namespace_id/:project_id/-/pipelines/:id/stage` | stage | ステージ情報取得（JSON） |

## 入出力項目

### 入力パラメータ

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| id | integer | ○ | パイプラインID |
| stage | string | - | ステージ名（stage取得時） |
| expanded | array | - | 展開するグループID |
| retried | boolean | - | リトライジョブ含む |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| パイプラインID | integer | パイプラインのID |
| パイプラインIID | integer | プロジェクト内の連番 |
| 状態 | string | running/pending/success/failed等 |
| コミットSHA | string | 対象コミットのSHA |
| コミットタイトル | string | コミットメッセージ |
| ブランチ | string | 対象ブランチ |
| 実行ユーザー | object | パイプライン実行者 |
| 作成日時 | datetime | パイプライン作成日時 |
| 完了日時 | datetime | パイプライン完了日時 |
| 実行時間 | duration | パイプラインの実行時間 |
| ステージ一覧 | array | パイプラインのステージ |
| ジョブ一覧 | array | 各ステージのジョブ |
| 失敗ジョブ数 | integer | 失敗したジョブの数 |
| 総ジョブ数 | integer | 全ジョブの数 |
| テストレポート | object | テスト結果サマリー |
| アーティファクト | array | ダウンロード可能なアーティファクト |
| パイプライン変数 | array | 設定された変数（権限により） |

## イベント仕様

### 1-タブ切り替え

「Pipeline」「Jobs」「Failed Jobs」「Tests」などのタブをクリックすると、対応するコンテンツが表示される。

### 2-ステージ展開/折り畳み

各ステージをクリックすると、ステージ内のジョブ一覧が展開または折り畳まれる。

### 3-ジョブクリック

ジョブをクリックすると、ジョブ詳細画面に遷移する。

### 4-パイプラインキャンセル

「Cancel」ボタンをクリックすると、実行中のパイプラインがキャンセルされる。

### 5-パイプラインリトライ

「Retry」ボタンをクリックすると、失敗したジョブが再実行される。リトライはRetryPipelineWorkerで非同期実行される。

### 6-アーティファクトダウンロード

「Download artifacts」ボタンをクリックすると、ビルドアーティファクトがダウンロードされる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | ci_pipelines | SELECT | パイプライン情報取得 |
| 画面表示 | ci_stages | SELECT | ステージ情報取得 |
| 画面表示 | ci_builds | SELECT | ジョブ情報取得 |
| キャンセル | ci_pipelines | UPDATE | ステータス更新 |
| キャンセル | ci_builds | UPDATE | 各ジョブのステータス更新 |
| リトライ | ci_builds | INSERT | 新規ジョブレコード作成 |
| リトライ | ci_stages | UPDATE | ステージのステータス更新 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| エラー | Unable to run pipeline | パイプラインにエラーがある場合 |
| 情報 | (failure_reason) | composite_identity_forbiddenの場合 |
| エラー | (エラーリスト) | パイプラインエラー時 |
| リンク | Go to the pipeline editor | CI設定エラー時 |
| リンク | Verify changes | 変更確認リンク |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| パイプラインが見つからない | 404エラーページを表示 |
| 閲覧権限がない | 403エラーページを表示 |
| キャンセル権限がない | アクセス拒否 |
| リトライ失敗 | エラーJSONを返却 |

## 備考

- ポーリング間隔は10秒（POLLING_INTERVAL）
- GraphQLを使用してリアルタイム更新
- Vue.jsコンポーネントで実装
- タブ構成：Pipeline（デフォルト）、Jobs、Failed Jobs、Tests
- 変数表示はci_display_pipeline_variables?設定による

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pipelines_controller.rb | `app/controllers/projects/pipelines_controller.rb` | showアクションと関連アクション |

**主要処理フロー**:
1. **行116-129**: `show`アクション - HTML/JSON形式の分岐、ポーリング設定
2. **行238-246**: `render_show` - ステージ情報取得とレンダリング
3. **行164-180**: `retry`アクション - リトライ権限チェックと非同期実行
4. **行182-192**: `cancel`アクション - キャンセル処理
5. **行149-153**: `status`アクション - ステータスJSON
6. **行155-162**: `stage`アクション - ステージ詳細JSON

#### Step 2: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | show.html.haml | `app/views/projects/pipelines/show.html.haml` | メインビュー（行1-44） |
| 2-2 | pipeline_helper.rb | `app/helpers/projects/pipeline_helper.rb` | ヘルパーメソッド |

**主要処理フロー**:
- **行11**: `#js-pipeline-header`でヘッダーコンポーネントをマウント
- **行13-41**: エラー時のアラート表示（composite_identity_forbidden、その他エラー）
- **行43**: `#js-pipeline-tabs`でタブコンポーネントをマウント
- `js_pipeline_tabs_data`で以下のデータを設定：
  - failed_jobs_count, total_job_count
  - summary_endpoint, suite_endpoint
  - tests_count, manual_variables_count

### プログラム呼び出し階層図

```
HTTP Request (GET /project/-/pipelines/:id)
    │
    ├─ PipelinesController#show
    │      │
    │      ├─ Gitlab::QueryLimiting.disable!
    │      │
    │      └─ respond_to
    │             │
    │             ├─ format.html → render_show
    │             │      │
    │             │      ├─ @stages = @pipeline.stages
    │             │      │
    │             │      └─ render 'show'
    │             │             ├─ js_pipeline_header_data
    │             │             └─ js_pipeline_tabs_data
    │             │
    │             └─ format.json
    │                    ├─ PollingInterval.set_header (10秒)
    │                    └─ PipelineSerializer#represent
    │
    └─ Vue.js コンポーネント (フロントエンド)
           ├─ Pipeline Header
           └─ Pipeline Tabs
                  ├─ Pipeline Graph
                  ├─ Jobs List
                  ├─ Failed Jobs
                  └─ Test Report

HTTP Request (POST /project/-/pipelines/:id/retry)
    │
    └─ PipelinesController#retry
           │
           ├─ RetryPipelineService#check_access
           │
           └─ RetryPipelineWorker.perform_async
                  └─ 非同期リトライ実行
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Pipeline ID ──────────▶ PipelinesController#show ──────▶ パイプライン詳細画面
                              │
                              ├─ @pipeline.stages
                              │
                              ├─ js_pipeline_header_data
                              │      └─ full_path, pipeline_iid
                              │
                              └─ js_pipeline_tabs_data
                                     ├─ failed_jobs_count
                                     ├─ total_job_count
                                     ├─ tests_count
                                     └─ manual_variables_count
                                            │
                                            ▼
                              ──────────▶ Vue.js タブ表示

Cancel Request ────────▶ cancel ──────────────────────▶ パイプライン一覧/詳細
                              │
                              └─ CancelPipelineService
                                     └─ ジョブキャンセル

Retry Request ─────────▶ retry ───────────────────────▶ 202 Accepted
                              │
                              └─ RetryPipelineWorker
                                     └─ 非同期リトライ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pipelines_controller.rb | `app/controllers/projects/pipelines_controller.rb` | コントローラー | リクエストハンドリング |
| show.html.haml | `app/views/projects/pipelines/show.html.haml` | ビュー | メインビュー |
| pipeline_helper.rb | `app/helpers/projects/pipeline_helper.rb` | ヘルパー | データ準備 |
| pipeline_serializer.rb | `app/serializers/pipeline_serializer.rb` | シリアライザー | JSON変換 |
| cancel_pipeline_service.rb | `app/services/ci/cancel_pipeline_service.rb` | サービス | キャンセル処理 |
| retry_pipeline_service.rb | `app/services/ci/retry_pipeline_service.rb` | サービス | リトライ処理 |
| pipelines.rb | `config/routes/pipelines.rb` | ルーティング | URL定義 |
