# 画面設計書 69-ジョブ一覧

## 概要

本ドキュメントは、GitLabプロジェクトのジョブ一覧画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、プロジェクト内のCI/CDジョブを一覧形式で表示する画面である。パイプラインで実行されたすべてのジョブの状態を確認し、フィルタリングや個別ジョブへのアクセスが可能。

**業務上の目的・背景**：CI/CDジョブはパイプラインを構成する実行単位であり、ビルド、テスト、デプロイなどの具体的な処理を担う。本画面では、プロジェクト全体のジョブ実行状況を横断的に確認でき、特定のジョブの検索や状態確認を効率的に行える。

**画面へのアクセス方法**：
1. プロジェクトページの左側ナビゲーションメニューから「Build」>「Jobs」を選択
2. URLに直接`/-/jobs`を入力

**主要な操作・処理内容**：
1. ジョブ一覧の表示
2. 状態別フィルタリング（running, pending, success, failed等）
3. ジョブ詳細画面への遷移
4. ジョブのキャンセル、リトライ、プレイ

**画面遷移**：
- 遷移元：ナビゲーションメニュー、パイプライン詳細画面
- 遷移先：ジョブ詳細画面、パイプライン詳細画面

**権限による表示制御**：
- 閲覧権限（Guest以上、設定による）：ジョブ一覧の表示
- 実行権限（Developer以上）：ジョブのキャンセル、リトライ、プレイ

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | パイプライン実行 | 主機能 | CI/CDジョブの一覧表示 |

## 画面種別

一覧

## URL/ルーティング

| メソッド | URL | アクション | 説明 |
|----------|-----|-----------|------|
| GET | `/:namespace_id/:project_id/-/jobs` | index | ジョブ一覧画面表示 |

## 入出力項目

### フィルタリング項目

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| status | string | - | ジョブ状態（running/pending/success/failed等） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| ジョブID | integer | ジョブのID |
| ジョブ名 | string | ジョブの名前 |
| 状態 | string | running/pending/success/failed等 |
| ステージ | string | 所属ステージ名 |
| パイプライン | object | 所属パイプライン情報 |
| コミット情報 | object | 関連コミット情報 |
| ブランチ | string | 対象ブランチ |
| 実行ユーザー | object | ジョブ実行者 |
| 実行時間 | duration | ジョブの実行時間 |
| 作成日時 | datetime | ジョブ作成日時 |
| 完了日時 | datetime | ジョブ完了日時 |
| アクション | array | 利用可能なアクション（retry, cancel, play等） |
| カバレッジ | float | コードカバレッジ（ある場合） |
| アーティファクト | array | 生成されたアーティファクト |

## イベント仕様

### 1-フィルター適用

ステータスフィルターを選択すると、選択した状態のジョブのみが表示される。

### 2-ジョブ行クリック

ジョブ一覧の行をクリックすると、該当ジョブの詳細画面に遷移する。

### 3-パイプラインリンククリック

パイプライン番号をクリックすると、該当パイプラインの詳細画面に遷移する。

### 4-ジョブアクション

各ジョブ行のアクションボタン（キャンセル、リトライ、プレイ）をクリックすると、対応する操作が実行される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | ci_builds | SELECT | ジョブ一覧取得 |
| 一覧表示 | ci_pipelines | SELECT | パイプライン情報取得 |
| 一覧表示 | ci_stages | SELECT | ステージ情報取得 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 情報 | No jobs to show | ジョブがない場合 |
| 情報 | Get started with Pipelines | CI設定がない場合 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| プロジェクトが見つからない | 404エラーページを表示 |
| 閲覧権限がない | 403エラーページを表示 |

## 備考

- Vue.jsコンポーネントで実装（#js-jobs-table）
- GraphQLを使用してデータ取得
- ジョブステータス定数はCi::HasStatus::AVAILABLE_STATUSESで定義
- パイプラインエディタへのリンクを提供
- empty_state_svg_pathで空状態のイラストを表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | jobs_controller.rb | `app/controllers/projects/jobs_controller.rb` | indexアクション |

**主要処理フロー**:
1. **行32**: `index`アクション - 空のメソッド（ビューレンダリングのみ）
2. **行9-10**: urgencyとbefore_actionの設定
3. **行306-308**: `push_job_subscription_feature_flag` - Feature Flag設定

#### Step 2: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html.haml | `app/views/projects/jobs/index.html.haml` | メインビュー（行1-5） |
| 2-2 | jobs_helper.rb | `app/helpers/ci/jobs_helper.rb` | ヘルパーメソッド |

**主要処理フロー**:
- **行5**: `#js-jobs-table`でVueコンポーネントをマウント
- data属性に以下を設定：
  - `full_path`: プロジェクトフルパス
  - `job_statuses`: ステータス定数
  - `pipeline_editor_path`: エディタパス
  - `empty_state_svg_path`: 空状態画像

### プログラム呼び出し階層図

```
HTTP Request (GET /project/-/jobs)
    │
    ├─ JobsController#index
    │      │
    │      ├─ before_action :authorize_read_build!
    │      │
    │      ├─ before_action :push_job_subscription_feature_flag
    │      │
    │      └─ render 'index' (暗黙的)
    │             │
    │             └─ index.html.haml
    │                    └─ #js-jobs-table
    │                           └─ Vue.jsマウント
    │
    └─ Vue.js コンポーネント (フロントエンド)
           │
           └─ GraphQL API
                  └─ ジョブ一覧取得
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Project ─────────────▶ JobsController#index ───────▶ ジョブ一覧画面
                              │
                              └─ render index.html.haml
                                     │
                                     └─ data属性設定
                                            ├─ full_path
                                            ├─ job_statuses
                                            ├─ pipeline_editor_path
                                            └─ empty_state_svg_path
                                                   │
                                                   ▼
                                   ──────────▶ Vue.js Table

GraphQL Query ─────────▶ Backend ─────────────────▶ Jobs Data
                              │
                              └─ ci_builds (GraphQL)
                                     └─ フィルタリング、ページネーション
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| jobs_controller.rb | `app/controllers/projects/jobs_controller.rb` | コントローラー | リクエストハンドリング |
| index.html.haml | `app/views/projects/jobs/index.html.haml` | ビュー | メインビュー |
| jobs_helper.rb | `app/helpers/ci/jobs_helper.rb` | ヘルパー | データ準備 |
| project.rb | `config/routes/project.rb` | ルーティング | URL定義（行53） |
