# 画面設計書 74-パイプラインエディタ

## 概要

本ドキュメントは、GitLabのパイプラインエディタ（Pipeline Editor）画面の設計を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：パイプラインエディタは、GitLab CI/CDの設定ファイル（`.gitlab-ci.yml`）を視覚的に編集・検証するための専用エディタ画面である。開発者がCI/CDパイプラインを構築・修正する際に、構文チェック、パイプライン構成の可視化、マージリクエスト作成までをワンストップで行える。これにより、CI/CD設定のエラーを事前に検出し、パイプライン構築の生産性を向上させる。

**画面へのアクセス方法**：プロジェクト画面の左サイドメニューから「Build」>「Pipeline editor」を選択、またはURL直接アクセス（`/:namespace/:project/-/ci/editor`）によりアクセスする。

**主要な操作・処理内容**：
1. `.gitlab-ci.yml`ファイルのMonacoエディタによる編集
2. CI設定の構文検証（Lint）
3. パイプライン構成の可視化（Visualize）
4. 設定ファイルのコミット
5. マージリクエストの作成
6. ブランチの切り替え
7. CI/CDカタログからのコンポーネント参照
8. パイプラインシミュレーション

**画面遷移**：
- 遷移元：プロジェクトダッシュボード、CI/CDメニュー、パイプライン一覧
- 遷移先：CI Lint画面、マージリクエスト作成画面、パイプライン一覧画面

**権限による表示制御**：
- プロジェクトへのコラボレーション権限がない場合はアクセス不可（404エラー）
- `create_pipeline`権限がない場合は「Run Pipeline」ボタンが非表示
- ブランチへの書き込み権限がない場合はコミットボタンが無効

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 53 | パイプラインエディタ | 主機能 | .gitlab-ci.ymlの編集・検証・コミット |
| 47 | パイプライン実行 | 遷移先機能 | パイプラインの手動実行 |

## 画面種別

編集

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|-------------|-----------|
| `/:namespace/:project/-/ci/editor` | GET | show |
| `/:namespace/:project/-/ci/editor/:branch` | GET | show（ブランチ指定） |

## 入出力項目

### URLパラメータ

| 項目名 | 必須 | 型 | 説明 |
|--------|------|-----|------|
| branch_name | 任意 | string | 編集対象のブランチ名（デフォルト: デフォルトブランチ） |

### 編集内容

| 項目名 | 必須 | 型 | 説明 |
|--------|------|-----|------|
| CI設定内容 | 必須 | string | .gitlab-ci.ymlのYAML内容 |
| コミットメッセージ | 必須 | string | 変更をコミットする際のメッセージ |
| ブランチ名 | 必須 | string | コミット先のブランチ |

## 表示項目

### メインエリア

| セクション | 項目 | 説明 |
|-----------|------|------|
| エディタ | Monaco Editor | シンタックスハイライト付きYAMLエディタ |
| タブ | Edit | ソースコード編集タブ |
| タブ | Visualize | パイプライン構成の視覚化タブ |
| タブ | Lint | 構文チェック結果タブ |
| タブ | Full configuration | 展開後の完全な設定表示タブ |

### ヘッダーエリア

| 項目 | 説明 |
|------|------|
| ブランチセレクター | 編集対象ブランチの選択 |
| CI/CDカタログリンク | コンポーネントカタログへのリンク |
| ヘルプリンク | ドキュメントへのリンク |

### フッターエリア

| 項目 | 説明 |
|------|------|
| コミットボタン | 変更をコミット |
| MR作成オプション | マージリクエスト作成チェックボックス |
| パイプライン実行ボタン | 新規パイプラインの実行 |

### 状態表示

| 項目 | 説明 |
|------|------|
| Lintステータス | Valid/Invalid/Checking |
| パイプラインステータス | 最新コミットのパイプライン状態 |
| 最終コミット情報 | SHA、作成者、日時 |

## イベント仕様

### 1-CI設定編集

**処理内容**：Monacoエディタで.gitlab-ci.ymlの内容を編集する。

**処理フロー**：
1. エディタでYAMLを編集
2. 編集内容は自動的にLint APIに送信（デバウンス処理あり）
3. Lint結果がリアルタイムで表示
4. 構文エラーがある場合はエディタ内でハイライト

### 2-構文検証（Lint）

**処理内容**：CI設定の構文をサーバーサイドで検証する。

**処理フロー**：
1. 編集内容の変更を検知
2. GraphQL APIで`ciConfigLint`クエリを実行
3. バリデーション結果を取得
4. エラー/警告をLintタブに表示
5. エディタ内にエラーマーカーを表示

### 3-パイプライン可視化（Visualize）

**処理内容**：CI設定をパイプラインのDAG（有向非巡回グラフ）として視覚化する。

**処理フロー**：
1. Visualizeタブをクリック
2. 現在の設定内容を解析
3. ステージとジョブの関係をグラフ描画
4. `needs`キーワードによる依存関係を矢印で表示

### 4-設定コミット

**処理内容**：編集した.gitlab-ci.ymlをリポジトリにコミットする。

**処理フロー**：
1. コミットボタンをクリック
2. コミットモーダルが表示
3. コミットメッセージを入力
4. ブランチを選択（現在のブランチまたは新規ブランチ）
5. MR作成オプションを選択
6. GraphQL mutationでコミット実行
7. 成功時：パイプラインステータスを更新
8. MR作成オプション選択時：MR作成画面にリダイレクト

### 5-ブランチ切り替え

**処理内容**：編集対象のブランチを切り替える。

**処理フロー**：
1. ブランチセレクターでブランチを選択
2. URLを更新（?branch_name=...）
3. 選択したブランチの.gitlab-ci.ymlを取得
4. エディタ内容を更新

### 6-パイプラインシミュレーション

**処理内容**：CI設定をシミュレートして実行結果を予測する。

**処理フロー**：
1. シミュレーションボタンをクリック
2. dry_run=trueでLint APIを実行
3. 実際のパイプライン構成を確認
4. 変数展開後の結果を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ファイル読み込み | - | Git操作 | リポジトリから.gitlab-ci.yml取得 |
| Lint実行 | - | - | バリデーションのみ、DBアクセスなし |
| コミット | - | Git操作 | リポジトリへのコミット |
| パイプライン作成 | ci_pipelines | INSERT | MR作成時のパイプライン生成 |

### 補足

この画面は主にGit操作とGraphQL APIを使用し、直接的なデータベース操作は限定的である。パイプラインの作成はコミット後のCI/CDトリガーによって行われる。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 成功 | Changes committed successfully | コミット成功時 |
| 成功 | CI configuration is valid | Lint検証成功時 |
| エラー | CI configuration is invalid | Lint検証失敗時 |
| エラー | Unable to load CI configuration | ファイル読み込み失敗時 |
| 警告 | This project uses an external CI/CD configuration file | 外部設定ファイル使用時 |
| 情報 | No .gitlab-ci.yml file found in this branch | ファイルが存在しない場合 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| コラボレーション権限なし | 404 Not Foundを返す |
| ファイル未存在 | エンプティステート表示、新規作成オプション提供 |
| 外部設定ファイル | 警告メッセージ表示、編集機能は制限 |
| コミット失敗 | エラーメッセージ表示、フォームに留まる |
| ブランチ未存在 | デフォルトブランチにフォールバック |

## 備考

- Monacoエディタはwebpack_preload_asset_tagでプリロードされる
- Lint結果はGraphQL APIを通じて取得
- 大きなリポジトリでは読み込みに時間がかかる場合がある
- `ci_config_path`が設定されている場合は代替パスを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project.rb | `app/models/project.rb` | ci_config_path_or_default、repository関連メソッド |
| 1-2 | ci_config.rb | `lib/gitlab/ci/config.rb` | CI設定のパースロジック |

**読解のコツ**: CI設定ファイルのパスは`ci_config_path`で設定可能。デフォルトは`.gitlab-ci.yml`。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pipeline_editor_controller.rb | `app/controllers/projects/ci/pipeline_editor_controller.rb` | showアクション、権限チェック |
| 2-2 | show.html.haml | `app/views/projects/ci/pipeline_editor/show.html.haml` | Vueコンポーネントのマウント |

**主要処理フロー**:
1. **13行目**: showアクションは空（ビューのみ）
2. **17-18行目**: check_can_collaborate!で権限チェック
3. **4-5行目**: ページ固有のスタイルを読み込み

#### Step 3: ヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pipeline_editor_helper.rb | `app/helpers/ci/pipeline_editor_helper.rb` | js_pipeline_editor_data、各種パス生成 |

**主要処理フロー**:
- **15-46行目**: js_pipeline_editor_dataで必要なデータを生成
- **51-54行目**: uses_external_config?で外部設定を判定

#### Step 4: フロントエンドコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pipeline_editor_app.vue | `app/assets/javascripts/ci/pipeline_editor/pipeline_editor_app.vue` | メインアプリコンポーネント |
| 4-2 | ci_config_merged_preview.vue | `app/assets/javascripts/ci/pipeline_editor/components/ci_config_merged_preview.vue` | 設定プレビュー |
| 4-3 | editor_tab.vue | `app/assets/javascripts/ci/pipeline_editor/components/editor/editor_tab.vue` | エディタタブ |

### プログラム呼び出し階層図

```
[ブラウザ] GET /project/-/ci/editor
    │
    ├─ PipelineEditorController#show
    │      └─ check_can_collaborate!
    │             └─ can_collaborate_with_project?
    │
    └─ [Vue.js] pipeline_editor_app.vue
           │
           ├─ EditorTab
           │      └─ MonacoEditor
           │
           ├─ VisualizeTab
           │      └─ PipelineGraph
           │
           ├─ LintTab
           │      └─ CiLint
           │
           └─ FullConfigurationTab
                  └─ MergedPreview

[GraphQL API]
    │
    ├─ ciConfigLint (Lint検証)
    │      └─ Gitlab::Ci::Lint
    │
    ├─ getBlobContent (ファイル取得)
    │      └─ Repository#blob_at
    │
    └─ commitCreate (コミット)
           └─ Files::CreateService
```

### データフロー図

```
[入力]                         [処理]                                    [出力]

URL(branch_name) ──────────▶ Controller#show ───────────────────▶ HTML + Vueマウント
                                   │
                                   └─ js_pipeline_editor_data
                                          │
                                          ▼
GraphQL Query ─────────────────────▶ getBlobContent ────────────▶ .gitlab-ci.yml内容
  (projectPath, ref)                                                   │
                                                                       ▼
                                                              MonacoEditor表示

編集内容 ──────────────────▶ ciConfigLint Query ────────────────▶ Lint結果
  (content)                        │
                                   └─ Gitlab::Ci::Lint#validate
                                          │
                                          ▼
                                   バリデーション結果JSON

コミット操作 ──────────────▶ commitCreate Mutation ─────────────▶ コミット結果
  (content, message,              │
   branch, startBranch)           └─ Files::CreateService
                                          │
                                          ▼
                                   ┌───────┴───────┐
                                   │               │
                                   ▼               ▼
                                成功           失敗
                                   │               │
                                   ▼               ▼
                           パイプライン開始    エラー表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pipeline_editor_controller.rb | `app/controllers/projects/ci/pipeline_editor_controller.rb` | コントローラー | showアクション |
| show.html.haml | `app/views/projects/ci/pipeline_editor/show.html.haml` | ビュー | Vueマウントポイント |
| pipeline_editor_helper.rb | `app/helpers/ci/pipeline_editor_helper.rb` | ヘルパー | データ生成 |
| pipeline_editor_app.vue | `app/assets/javascripts/ci/pipeline_editor/pipeline_editor_app.vue` | Vueコンポーネント | メインアプリ |
| editor_tab.vue | `app/assets/javascripts/ci/pipeline_editor/components/editor/editor_tab.vue` | Vueコンポーネント | エディタタブ |
| lint.rb | `lib/gitlab/ci/lint.rb` | ライブラリ | Lintロジック |
| config.rb | `lib/gitlab/ci/config.rb` | ライブラリ | CI設定パーサー |
