# 画面設計書 75-CI Lint

## 概要

本ドキュメントは、GitLabのCI Lint画面の設計を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：CI Lint画面は、GitLab CI/CD設定ファイル（`.gitlab-ci.yml`）の構文をコミット前に検証するための専用ツールである。開発者がCI/CD設定を作成・修正した際に、構文エラーや設定ミスを事前に検出できる。パイプラインエディタと連携しながら、より詳細な検証やシミュレーションを行う場合に使用される。

**画面へのアクセス方法**：プロジェクト画面の左サイドメニューから「Build」>「Pipeline editor」>「CI Lint」タブ、またはURL直接アクセス（`/:namespace/:project/-/ci/lint`）によりアクセスする。

**主要な操作・処理内容**：
1. CI設定（YAML）の入力
2. 構文検証の実行
3. パイプラインシミュレーション（dry_run）
4. 検証結果の表示（エラー/警告/ジョブ一覧）
5. 展開後の設定確認

**画面遷移**：
- 遷移元：パイプラインエディタ、プロジェクトメニュー
- 遷移先：パイプラインエディタ、ヘルプドキュメント

**権限による表示制御**：
- `create_pipeline`権限がない場合はアクセス不可（403エラー）
- プロジェクトへのアクセス権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 53 | パイプラインエディタ | 主機能 | CI設定の構文チェック |

## 画面種別

ツール

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|-------------|-----------|
| `/:namespace/:project/-/ci/lint` | GET | show |
| `/:namespace/:project/-/ci/lint` | POST | create |

## 入出力項目

### 入力フォーム

| 項目名 | 必須 | 型 | 説明 |
|--------|------|-----|------|
| content | 必須 | string | 検証するCI設定（YAML形式） |
| dry_run | 任意 | boolean | パイプラインシミュレーションモード |

## 表示項目

### 入力エリア

| 項目 | 説明 |
|------|------|
| YAMLテキストエリア | CI設定を入力するエリア |
| Validate | 検証実行ボタン |
| Simulate pipeline | シミュレーション実行チェックボックス |

### 結果表示エリア

| 項目 | 説明 |
|------|------|
| ステータス | Valid/Invalid |
| エラー一覧 | 構文エラーの詳細 |
| 警告一覧 | 警告メッセージ |
| ジョブ一覧 | 検出されたジョブとその設定 |
| 展開後設定 | include/extend展開後の完全な設定 |

## イベント仕様

### 1-構文検証

**処理内容**：入力されたCI設定の構文を検証する。

**処理フロー**：
1. Validateボタンをクリック
2. POSTリクエストで`content`を送信
3. `Gitlab::Ci::Lint`で検証実行
4. 検証結果をJSON形式で返却
5. 画面に結果を表示

### 2-パイプラインシミュレーション

**処理内容**：CI設定を実際のパイプラインとしてシミュレートする。

**処理フロー**：
1. 「Simulate pipeline」をチェック
2. Validateボタンをクリック
3. `dry_run: true`でLint実行
4. 変数展開、条件評価を含む詳細な検証
5. 結果を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 検証実行 | - | - | データベース操作なし |

### 補足

CI Lint機能はデータベースへの書き込みを行わない読み取り専用の機能である。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 成功 | Syntax is valid | 検証成功時 |
| エラー | Syntax is invalid | 検証失敗時 |
| エラー | (具体的なエラー内容) | 各エラーの詳細 |
| 警告 | (警告内容) | 非推奨機能使用時等 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 権限不足 | 403 Forbiddenを返す |
| 無効なYAML | エラーメッセージを表示 |
| タイムアウト | タイムアウトエラーを表示 |

## 備考

- `legacy_validate`メソッドを使用して検証
- dry_runモードでは実際にパイプラインは作成されない
- ヘルプページへのリンクを提供

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lints_controller.rb | `app/controllers/projects/ci/lints_controller.rb` | show/createアクション |
| 1-2 | show.html.haml | `app/views/projects/ci/lints/show.html.haml` | Vueコンポーネントマウント |

**主要処理フロー**:
1. **4行目**: authorize_create_pipeline!で権限チェック
2. **11行目**: showアクションは空
3. **13-21行目**: createアクションでLint実行

#### Step 2: Lintロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lint.rb | `lib/gitlab/ci/lint.rb` | legacy_validateメソッド |

### プログラム呼び出し階層図

```
[ブラウザ] GET /project/-/ci/lint
    │
    └─ LintsController#show
           └─ ビューレンダリング

[ブラウザ] POST /project/-/ci/lint
    │
    └─ LintsController#create
           │
           └─ Gitlab::Ci::Lint#legacy_validate
                  │
                  └─ Ci::Lint::ResultSerializer#represent
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lints_controller.rb | `app/controllers/projects/ci/lints_controller.rb` | コントローラー | show/createアクション |
| show.html.haml | `app/views/projects/ci/lints/show.html.haml` | ビュー | Vueマウントポイント |
| lint.rb | `lib/gitlab/ci/lint.rb` | ライブラリ | 検証ロジック |
| result_serializer.rb | `app/serializers/ci/lint/result_serializer.rb` | シリアライザー | 結果のJSON変換 |
