# 画面設計書 76-アーティファクト一覧

## 概要

本ドキュメントは、GitLabのジョブアーティファクト一覧画面の設計を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：アーティファクト一覧画面は、プロジェクトのCI/CDジョブによって生成されたアーティファクト（ビルド成果物、テストレポート、カバレッジレポート等）を一元管理するための画面である。ストレージ使用量の管理、不要なアーティファクトの削除、アーティファクトの一括操作を通じて、プロジェクトのストレージコストを最適化する。

**画面へのアクセス方法**：プロジェクト画面の左サイドメニューから「Build」>「Artifacts」を選択、またはURL直接アクセス（`/:namespace/:project/-/artifacts`）によりアクセスする。

**主要な操作・処理内容**：
1. プロジェクトのアーティファクト一覧表示
2. アーティファクトの検索・フィルタリング
3. アーティファクトの削除
4. アーティファクトの一括削除
5. アーティファクトのダウンロード
6. アーティファクトの詳細確認

**画面遷移**：
- 遷移元：プロジェクトダッシュボード、ジョブ詳細画面、パイプライン詳細画面
- 遷移先：ジョブ詳細画面、アーティファクトダウンロード

**権限による表示制御**：
- `read_build`権限がない場合はアクセス不可
- `delete_job_artifact`権限がある場合のみ削除ボタンが表示
- `read_job_artifacts`権限がない場合はダウンロード不可

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 52 | アーティファクト管理 | 主機能 | アーティファクト一覧表示・削除 |

## 画面種別

一覧

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|-------------|-----------|
| `/:namespace/:project/-/artifacts` | GET | index |
| `/:namespace/:project/-/artifacts/:id` | DELETE | destroy |

## 入出力項目

### URLパラメータ

| 項目名 | 必須 | 型 | 説明 |
|--------|------|-----|------|
| sort | 任意 | string | ソート順 |

## 表示項目

### アーティファクト一覧テーブル

| 項目名 | 説明 | 型 |
|--------|------|-----|
| アーティファクト名 | アーティファクトのファイル名/タイプ | string |
| ジョブ名 | 関連するジョブ名 | string |
| パイプライン | 関連するパイプライン情報 | string |
| サイズ | アーティファクトのファイルサイズ | number |
| 作成日時 | アーティファクトの作成日時 | datetime |
| 有効期限 | アーティファクトの有効期限 | datetime |
| アクション | ダウンロード、削除ボタン | - |

### サマリー情報

| 項目 | 説明 |
|------|------|
| 総数 | アーティファクトの総数 |
| 総サイズ | 全アーティファクトの合計サイズ |

## イベント仕様

### 1-アーティファクト削除

**処理内容**：選択したアーティファクトを削除する。

**処理フロー**：
1. 削除ボタンをクリック
2. 確認ダイアログ表示
3. DELETEリクエスト送信
4. 成功時：一覧を更新、成功メッセージ表示
5. 失敗時：エラーメッセージ表示

### 2-一括削除

**処理内容**：複数のアーティファクトを一括で削除する。

**処理フロー**：
1. チェックボックスでアーティファクトを選択
2. 一括削除ボタンをクリック
3. 確認ダイアログ表示
4. BulkDeleteByProjectServiceで削除実行
5. 結果を表示

### 3-ダウンロード

**処理内容**：アーティファクトをダウンロードする。

**処理フロー**：
1. ダウンロードボタンをクリック
2. ダウンロードURLにリダイレクト
3. ファイルのダウンロード開始

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | p_ci_job_artifacts | SELECT | アーティファクト一覧取得 |
| 削除 | p_ci_job_artifacts | DELETE | アーティファクトの削除 |
| 削除 | project_statistics | UPDATE | プロジェクト統計の更新 |

### テーブル別更新項目詳細

#### p_ci_job_artifacts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | project_idでフィルタ | ページネーション対応 |
| DELETE | - | idで特定 | 物理削除 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 成功 | Artifact was successfully deleted. | 削除成功時 |
| エラー | Artifact could not be deleted. | 削除失敗時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 権限不足 | 403 Forbiddenを返す |
| アーティファクト未検出 | 404 Not Foundを返す |

## 備考

- アーティファクトの削除は物理削除
- 削除後にプロジェクト統計が自動更新される
- JOB_ARTIFACTS_COUNT_LIMITで一括削除の上限を制限

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job_artifact.rb | `app/models/ci/job_artifact.rb` | アーティファクトの構造、スコープ |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | artifacts_controller.rb | `app/controllers/projects/artifacts_controller.rb` | index/destroyアクション |
| 2-2 | index.html.haml | `app/views/projects/artifacts/index.html.haml` | Vueコンポーネントマウント |

**主要処理フロー**:
1. **25行目**: indexアクションは空
2. **27-35行目**: destroyアクションでアーティファクト削除
3. **13-16行目**: 各種権限チェック

### プログラム呼び出し階層図

```
[ブラウザ] GET /project/-/artifacts
    │
    └─ ArtifactsController#index
           └─ ビューレンダリング

[ブラウザ] DELETE /project/-/artifacts/:id
    │
    └─ ArtifactsController#destroy
           │
           └─ artifact.destroy
                  └─ UpdateProjectStatistics
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| artifacts_controller.rb | `app/controllers/projects/artifacts_controller.rb` | コントローラー | CRUD操作 |
| index.html.haml | `app/views/projects/artifacts/index.html.haml` | ビュー | Vueマウント |
| job_artifact.rb | `app/models/ci/job_artifact.rb` | モデル | データモデル |
| artifacts_helper.rb | `app/helpers/artifacts_helper.rb` | ヘルパー | ビューヘルパー |
