# 画面設計書 78-環境詳細

## 概要

本ドキュメントは、GitLabの環境詳細画面の設計を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：環境詳細画面は、特定のデプロイ環境の詳細情報、デプロイ履歴、環境の状態を確認するための画面である。開発者やDevOpsエンジニアが環境の現在の状態、過去のデプロイ履歴、Kubernetes連携情報などを確認し、環境に対する操作（停止、ロールバック、ターミナルアクセス）を行う。

**画面へのアクセス方法**：環境一覧画面の環境名リンクをクリック、またはURL直接アクセス（`/:namespace/:project/-/environments/:id`）によりアクセスする。

**主要な操作・処理内容**：
1. 環境の詳細情報表示
2. デプロイ履歴の表示
3. 環境の停止
4. 自動停止のキャンセル
5. 環境の削除
6. ターミナルアクセス（Kubernetes環境）
7. 外部URLへのアクセス
8. ロールバック操作
9. Kubernetes情報の表示（k8sタブ）

**画面遷移**：
- 遷移元：環境一覧画面、パイプライン詳細画面、ジョブ詳細画面
- 遷移先：環境編集画面、ジョブ詳細画面、ターミナル画面

**権限による表示制御**：
- `read_environment`権限がない場合はアクセス不可
- `update_environment`権限がある場合のみ編集ボタンが表示
- `stop_environment`権限がある場合のみ停止ボタンが表示
- `destroy_environment`権限がある場合のみ削除ボタンが表示
- `admin_environment`権限がある場合のみターミナルアクセスが可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 55 | 環境管理 | 主機能 | 環境詳細表示・状態管理 |
| 56 | デプロイメント履歴 | 補助機能 | デプロイ履歴の表示 |

## 画面種別

詳細

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|-------------|-----------|
| `/:namespace/:project/-/environments/:id` | GET | show |
| `/:namespace/:project/-/environments/:id/k8s/*` | GET | k8s |
| `/:namespace/:project/-/environments/:id/terminal` | GET | terminal |
| `/:namespace/:project/-/environments/:id/terminal.ws/authorize` | GET | terminal_websocket_authorize |

## 入出力項目

### URLパラメータ

| 項目名 | 必須 | 型 | 説明 |
|--------|------|-----|------|
| id | 必須 | integer | 環境ID |

## 表示項目

### 環境基本情報

| 項目名 | 説明 | 型 |
|--------|------|-----|
| 環境名 | 環境の名前 | string |
| 状態 | 環境の状態（available/stopping/stopped） | string |
| 外部URL | 環境の外部URL | string |
| 説明 | 環境の説明（Markdown対応） | string |
| 自動停止時刻 | 自動停止が設定されている場合の停止予定時刻 | datetime |

### デプロイ履歴

| 項目名 | 説明 | 型 |
|--------|------|-----|
| デプロイID | デプロイメントのIID | integer |
| コミット | デプロイされたコミット情報 | object |
| ステータス | デプロイのステータス | string |
| 作成日時 | デプロイ日時 | datetime |
| 実行者 | デプロイを実行したユーザー | User |
| アクション | ロールバック、ジョブ表示等のボタン | - |

### Kubernetes情報（k8sタブ）

| 項目名 | 説明 |
|--------|------|
| 接続状態 | Kubernetesクラスターへの接続状態 |
| Pod一覧 | 環境に関連するPodの一覧 |
| Service一覧 | 関連するServiceの一覧 |
| リソースツリー | Kubernetesリソースの階層表示 |

## イベント仕様

### 1-環境停止

**処理内容**：環境を停止する。

**処理フロー**：
1. 停止ボタンをクリック
2. 確認モーダル表示
3. POSTリクエストで`stop`アクションを実行
4. stop_actionが定義されている場合はそのジョブを実行
5. 成功時：ジョブページまたは環境ページにリダイレクト

### 2-自動停止キャンセル

**処理内容**：環境の自動停止をキャンセルする。

**処理フロー**：
1. 自動停止キャンセルボタンをクリック
2. POSTリクエストで`cancel_auto_stop`を実行
3. 成功時：メッセージ表示、画面更新

### 3-環境削除

**処理内容**：環境を削除する（停止済みの場合のみ）。

**処理フロー**：
1. 削除ボタンをクリック
2. 確認モーダル表示
3. 成功時：環境一覧にリダイレクト

### 4-ターミナルアクセス

**処理内容**：Kubernetes環境のターミナルにアクセスする。

**処理フロー**：
1. ターミナルボタンをクリック
2. terminal画面に遷移
3. WebSocket接続を確立
4. Workhorse経由でコンテナに接続

### 5-ロールバック

**処理内容**：以前のデプロイにロールバックする。

**処理フロー**：
1. デプロイ履歴からロールバック対象を選択
2. 確認モーダル表示
3. 対応するデプロイジョブを再実行
4. 新しいデプロイが作成される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 詳細表示 | environments | SELECT | 環境情報の取得 |
| 詳細表示 | deployments | SELECT | デプロイ履歴の取得 |
| 停止 | environments | UPDATE | 状態の更新 |
| 削除 | environments | DELETE | 環境の削除 |
| 自動停止キャンセル | environments | UPDATE | auto_stop_atのクリア |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| 成功 | Auto stop successfully canceled. | 自動停止キャンセル成功時 |
| エラー | Unauthorized to stop the environment | 停止権限不足時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 環境未検出 | 404 Not Foundを返す |
| 権限不足 | 403 Forbiddenを返す |
| ターミナル利用不可 | 404を返す（証明書ベースクラスター未有効） |

## 備考

- デプロイ履歴はページネーション対応
- Kubernetes情報はReactiveCachingを使用
- ターミナル機能は証明書ベースクラスターが有効な場合のみ
- 説明欄はMarkdownレンダリング対応

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | environments_controller.rb | `app/controllers/projects/environments_controller.rb` | showアクション、terminalアクション |
| 1-2 | show.html.haml | `app/views/projects/environments/show.html.haml` | Vueコンポーネントマウント |

**主要処理フロー**:
1. **85行目**: showアクションは空
2. **157-162行目**: terminalアクションでターミナル情報を取得
3. **22-23行目**: environment取得

#### Step 2: ヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | environment_helper.rb | `app/helpers/environment_helper.rb` | environments_detail_data、各種パス生成 |

**主要処理フロー**:
- **16-38行目**: environments_detail_dataで詳細データを生成

### プログラム呼び出し階層図

```
[ブラウザ] GET /project/-/environments/:id
    │
    └─ EnvironmentsController#show
           │
           └─ environment (find by id)

[Vue.js] environment_details/index.vue
    │
    ├─ environments_detail_data_json
    │      └─ 各種パス、権限情報
    │
    ├─ DeploymentsTable
    │      └─ deployments.ordered
    │
    └─ KubernetesTabs（k8sの場合）
           └─ KAS Tunnel API
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| environments_controller.rb | `app/controllers/projects/environments_controller.rb` | コントローラー | show/terminal/k8sアクション |
| show.html.haml | `app/views/projects/environments/show.html.haml` | ビュー | Vueマウント |
| environment.rb | `app/models/environment.rb` | モデル | データモデル |
| environment_helper.rb | `app/helpers/environment_helper.rb` | ヘルパー | 詳細データ生成 |
| index.vue | `app/assets/javascripts/environments/environment_details/index.vue` | Vueコンポーネント | 詳細UI |
| deployments_table.vue | `app/assets/javascripts/environments/environment_details/deployments_table.vue` | Vueコンポーネント | デプロイ履歴 |
