# 画面設計書 79-環境新規作成

## 概要

本ドキュメントは、GitLabの環境新規作成画面の設計を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：環境新規作成画面は、プロジェクトにデプロイ環境を手動で追加するための画面である。通常はCI/CDパイプラインによって自動的に環境が作成されるが、本画面では事前に環境を定義したり、外部システムとの連携用に環境を手動で作成することができる。Kubernetes Agentとの連携設定も可能。

**画面へのアクセス方法**：環境一覧画面の「New environment」ボタンをクリック、またはURL直接アクセス（`/:namespace/:project/-/environments/new`）によりアクセスする。

**主要な操作・処理内容**：
1. 環境名の入力
2. 説明の入力（Markdown対応）
3. 外部URLの設定
4. GitLab Agentの選択（Kubernetes連携）
5. Kubernetes Namespaceの選択
6. Flux Resourceの設定
7. 環境の作成

**画面遷移**：
- 遷移元：環境一覧画面
- 遷移先：環境詳細画面（作成成功時）、環境一覧画面（キャンセル時）

**権限による表示制御**：
- `create_environment`権限がない場合はアクセス不可

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 55 | 環境管理 | 主機能 | 環境の作成 |

## 画面種別

新規作成

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|-------------|-----------|
| `/:namespace/:project/-/environments/new` | GET | new |
| `/:namespace/:project/-/environments` | POST | create |

## 入出力項目

### フォーム入力項目

| 項目名 | 必須 | 型 | 説明 | バリデーション |
|--------|------|-----|------|---------------|
| name | 必須 | string | 環境名 | 空でないこと |
| description | 任意 | string | 環境の説明（Markdown対応） | - |
| external_url | 任意 | string | 外部URL | http://またはhttps://で始まること |
| cluster_agent_id | 任意 | string | GitLab Agent ID | - |
| kubernetes_namespace | 任意 | string | Kubernetes Namespace | Agent選択時のみ |
| flux_resource_path | 任意 | string | Flux Resourceパス | Agent選択時のみ |

## 表示項目

### フォーム

| 項目名 | 説明 |
|--------|------|
| タイトル | "New environment" |
| 環境名入力欄 | 環境名を入力するテキストボックス |
| 説明入力欄 | Markdownエディタ（プレビュー機能付き） |
| 外部URL入力欄 | URLを入力するテキストボックス |
| GitLab Agent選択 | プロジェクトで利用可能なAgentのドロップダウン |
| Namespace選択 | Agent選択時に表示されるNamespaceセレクター |
| Flux Resource選択 | Agent選択時に表示されるFluxリソースセレクター |
| 保存ボタン | フォームを送信して環境を作成 |
| キャンセルボタン | 環境一覧に戻る |

## イベント仕様

### 1-環境作成

**処理内容**：新しい環境を作成する。

**処理フロー**：
1. フォームに必要事項を入力
2. 保存ボタンをクリック
3. GraphQL `environmentCreate` mutationを実行
4. 成功時：作成された環境の詳細画面にリダイレクト
5. 失敗時：エラーメッセージをアラート表示

### 2-Agent選択

**処理内容**：GitLab Agentを選択する。

**処理フロー**：
1. Agentドロップダウンをクリック
2. `getUserAuthorizedAgents` GraphQLクエリで利用可能なAgentを取得
3. Agentを選択
4. Namespace選択とFlux Resource選択UIが表示される

### 3-キャンセル

**処理内容**：環境作成をキャンセルする。

**処理フロー**：
1. キャンセルボタンをクリック
2. 環境一覧画面にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 環境作成 | environments | INSERT | 新規環境の作成 |

### テーブル別更新項目詳細

#### environments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | 入力値 | 必須 |
| INSERT | external_url | 入力値 | 任意 |
| INSERT | state | 'available' | 初期状態 |
| INSERT | project_id | 現在のプロジェクトID | - |
| INSERT | cluster_agent_id | 選択されたAgent ID | 任意 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|---------|
| エラー | This field is required | 環境名が空の場合 |
| エラー | The URL should start with http:// or https:// | URL形式が不正な場合 |
| エラー | GraphQL mutation errors | 作成失敗時（エラー内容を表示） |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 権限不足 | 403 Forbiddenを返す |
| 環境名重複 | GraphQLエラーでメッセージを表示 |
| バリデーションエラー | エラーメッセージをアラート表示 |

## 備考

- 環境名は作成後に変更できない（リネームは不可）
- 説明欄はMarkdownレンダリング対応
- GitLab Agentを選択するとKubernetes連携設定が可能になる
- KAS Tunnel URLを使用してKubernetes APIにアクセス

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | environments_controller.rb | `app/controllers/projects/environments_controller.rb` | new/createアクション |
| 1-2 | new.html.haml | `app/views/projects/environments/new.html.haml` | Vueコンポーネントマウント |

**主要処理フロー**:
1. **87-89行目**: newアクションで新規環境オブジェクトを初期化
2. **97-105行目**: createアクションで環境を作成し、JSON応答
3. **18行目**: authorize_create_environment!で権限チェック

#### Step 2: フロントエンドコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | new_environment.vue | `app/assets/javascripts/environments/components/new_environment.vue` | 新規作成ロジック |
| 2-2 | environment_form.vue | `app/assets/javascripts/environments/components/environment_form.vue` | フォーム共通部品 |

**主要処理フロー**:
1. **27-62行目** (new_environment.vue): onSubmitでGraphQL mutationを実行
2. **176-214行目** (environment_form.vue): フォーム入力のイベントハンドリング

#### Step 3: GraphQL APIを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | create_environment.mutation.graphql | `app/assets/javascripts/environments/graphql/mutations/create_environment.mutation.graphql` | 作成mutation |

### プログラム呼び出し階層図

```
[ブラウザ] GET /project/-/environments/new
    │
    └─ EnvironmentsController#new
           │
           └─ @environment = project.environments.new
                  │
                  └─ new.html.haml
                         │
                         └─ #js-new-environment

[Vue.js] new_environment.vue
    │
    ├─ environment_form.vue
    │      │
    │      ├─ MarkdownEditor（説明入力）
    │      ├─ GlCollapsibleListbox（Agent選択）
    │      ├─ EnvironmentNamespaceSelector
    │      └─ EnvironmentFluxResourceSelector
    │
    └─ onSubmit()
           │
           └─ GraphQL: environmentCreate mutation
                  │
                  ├─ 成功: visitUrl(path)
                  └─ 失敗: createAlert(message)
```

### データフロー図

```
[入力]                         [処理]                                    [出力]

フォーム入力 ─────────────▶ new_environment.vue
  (name, description,          │
   externalUrl, agentId)       └─ environment_form.vue
                                      │
                                      ├─ バリデーション
                                      │
                                      └─ onSubmit
                                            │
                                            ▼
                               GraphQL environmentCreate ─────────▶ environments INSERT
                                            │
                                            ├─ 成功 ────▶ 環境詳細画面へリダイレクト
                                            │
                                            └─ 失敗 ────▶ エラーアラート表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| environments_controller.rb | `app/controllers/projects/environments_controller.rb` | コントローラー | new/createアクション |
| new.html.haml | `app/views/projects/environments/new.html.haml` | ビュー | Vueマウント |
| new_environment.vue | `app/assets/javascripts/environments/components/new_environment.vue` | Vueコンポーネント | 新規作成UI |
| environment_form.vue | `app/assets/javascripts/environments/components/environment_form.vue` | Vueコンポーネント | フォーム共通部品 |
| create_environment.mutation.graphql | `app/assets/javascripts/environments/graphql/mutations/create_environment.mutation.graphql` | GraphQL | 作成mutation |
| environment.rb | `app/models/environment.rb` | モデル | データモデル |
