# 画面設計書 81-デプロイ詳細

## 概要

本ドキュメントは、GitLabのデプロイ詳細画面の設計仕様を定義するものである。

### 本画面の処理概要

デプロイ詳細画面は、個別のデプロイメントに関する詳細情報を表示するための画面である。この画面では、特定のデプロイメントのステータス、関連するコミット情報、パイプライン情報、および承認状況を確認できる。

**業務上の目的・背景**：DevOpsプロセスにおいて、個々のデプロイメントの状態を詳細に把握することは、本番環境への変更追跡、障害調査、リリース管理において不可欠である。この画面は、開発者・運用担当者がデプロイメントの詳細を一元的に確認し、必要に応じて承認や手動実行などのアクションを実行できる場を提供する。特にエンタープライズ環境では、Protected Environments機能と連携した承認ワークフローの管理が重要な役割を果たす。

**画面へのアクセス方法**：環境詳細画面から特定のデプロイメントを選択、またはパイプライン詳細画面からデプロイジョブ経由でアクセスする。URLパターンは `/:namespace/:project/-/environments/:environment_id/deployments/:deployment_iid` となる。

**主要な操作・処理内容**：
1. デプロイメントのステータス確認（created, running, success, failed, canceled, blocked）
2. 関連するコミット情報の参照（SHA、コミットメッセージ、作成者）
3. トリガーしたユーザーの確認
4. 関連するパイプライン・ジョブへの遷移
5. 手動デプロイジョブの実行（権限がある場合）
6. デプロイ承認の実施（Protected Environments有効時、EE機能）
7. 関連タグ・リリース情報の参照

**画面遷移**：
- 遷移元：環境詳細画面、パイプライン詳細画面、ジョブ詳細画面
- 遷移先：コミット詳細画面、パイプライン詳細画面、ジョブ詳細画面、リリース詳細画面、環境詳細画面、Protected Environments設定画面

**権限による表示制御**：
- `read_deployment`権限がない場合はアクセス不可
- `admin_pipeline`権限を持つユーザーのみProtected Environments設定へのリンクが表示される
- `update_deployment`権限を持つユーザーのみデプロイ承認操作が可能（EE機能）
- デプロイジョブの実行権限（`can_play_job`）がある場合のみ手動デプロイブロックが表示される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 56 | デプロイメント履歴 | 主機能 | 個別デプロイの詳細表示 |
| 55 | 環境管理 | 補助機能 | 環境情報の参照・連携 |
| 47 | パイプライン実行 | 遷移先機能 | パイプライン詳細画面への遷移 |
| 48 | ジョブ管理 | 遷移先機能 | ジョブ詳細画面への遷移 |
| 73 | リリース作成 | 遷移先機能 | リリース詳細画面への遷移 |

## 画面種別

詳細

## URL/ルーティング

```
GET /:namespace/:project/-/environments/:environment_id/deployments/:id
```

**ルート定義** (`config/routes/project.rb`):
```ruby
resources :environments do
  resources :deployments, only: [:index, :show]
end
```

## 入出力項目

本画面は参照専用の詳細画面であり、フォーム入力項目はない。

## 表示項目

### ヘッダー情報

| 項目名 | データ型 | 説明 | ソース |
|--------|----------|------|--------|
| デプロイメントIID | String | プロジェクト内でのデプロイメント識別子 | deployment.iid |
| ステータス | Enum | デプロイメントの状態（created/running/success/failed/canceled/blocked） | deployment.status |
| 参照ブランチ/タグ | String | デプロイ対象のGit参照 | deployment.ref |
| タグフラグ | Boolean | タグからのデプロイかどうか | deployment.tag |

### コミット情報

| 項目名 | データ型 | 説明 | ソース |
|--------|----------|------|--------|
| コミットSHA（短縮） | String | コミットハッシュの短縮形 | deployment.commit.shortId |
| コミットタイトル | String | コミットメッセージの1行目 | deployment.commit.title |
| 作成者名 | String | コミット作成者名 | deployment.commit.authorName |
| 作成者アバター | String | 作成者のGravatarまたはアバターURL | deployment.commit.authorGravatar |

### 実行情報

| 項目名 | データ型 | 説明 | ソース |
|--------|----------|------|--------|
| トリガーユーザー | User | デプロイを実行したユーザー | deployment.triggerer |
| 作成日時 | DateTime | デプロイメントレコード作成日時 | deployment.createdAt |
| 完了日時 | DateTime | デプロイメント完了日時 | deployment.finishedAt |
| 関連ジョブ | Job | 関連するCI/CDジョブ | deployment.job |
| パイプライン | Pipeline | 関連するパイプライン | deployment.job.pipeline |

### タグ情報

| 項目名 | データ型 | 説明 | ソース |
|--------|----------|------|--------|
| 関連タグ一覧 | Array<DeploymentTag> | このデプロイメントを含むGitタグ | deployment.tags |

### 承認情報（EE機能）

| 項目名 | データ型 | 説明 | ソース |
|--------|----------|------|--------|
| 承認サマリー | ApprovalSummary | デプロイ承認の状況 | deployment.approvalSummary |

## イベント仕様

### 1-手動デプロイ実行

**トリガー**: 手動デプロイブロック内の「Deploy」ボタン押下

**前提条件**:
- デプロイジョブが手動（manual）状態である
- ユーザーが`can_play_job`権限を持つ

**処理フロー**:
1. GraphQL Mutation `ciJobPlay`を実行
2. ジョブのステータスが`pending`に更新
3. デプロイメントのステータスが`running`に更新
4. 画面がポーリングで最新状態を取得

**遷移先**: 画面更新（同一画面）

### 2-承認操作（EE機能）

**トリガー**: 承認ブロック内の承認ボタン押下

**前提条件**:
- Protected Environments機能が有効
- ユーザーが承認権限を持つ
- デプロイメントが承認待ち状態

**処理フロー**:
1. GraphQL Mutation `environmentsApproveDeployment`を実行
2. 承認状態が更新
3. 全承認が完了した場合、デプロイメントが実行される

**遷移先**: 画面更新（同一画面）

### 3-コミット詳細への遷移

**トリガー**: コミットSHAリンクのクリック

**処理フロー**: コミット詳細画面へ遷移

**遷移先**: `/:namespace/:project/-/commit/:sha`

### 4-パイプライン詳細への遷移

**トリガー**: パイプラインリンクのクリック

**処理フロー**: パイプライン詳細画面へ遷移

**遷移先**: `/:namespace/:project/-/pipelines/:id`

### 5-ジョブ詳細への遷移

**トリガー**: ジョブリンクのクリック

**処理フロー**: ジョブ詳細画面へ遷移

**遷移先**: `/:namespace/:project/-/jobs/:id`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | deployments | SELECT | デプロイメント情報の取得 |
| 画面表示 | environments | SELECT | 環境情報の取得 |
| 画面表示 | ci_builds | SELECT | 関連ジョブ情報の取得 |
| 手動デプロイ実行 | ci_builds | UPDATE | ジョブステータスの更新 |
| 手動デプロイ実行 | deployments | UPDATE | デプロイメントステータスの更新 |

### テーブル別更新項目詳細

#### deployments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, iid, project_id, environment_id, sha, ref, tag, user_id, deployable_id, deployable_type, status, finished_at, created_at | project_id = プロジェクトID AND iid = デプロイメントIID | |
| UPDATE | status | 'running', 'success', 'failed', 'canceled' | 手動デプロイ実行時 |
| UPDATE | finished_at | 現在時刻 | ステータスがFINISHED_STATUSESの場合 |

#### ci_builds（deployable経由）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, status, user_id, pipeline_id | deployments.deployable_idで結合 | |
| UPDATE | status | 'pending' | 手動ジョブ実行時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | エラー | There was an issue fetching the deployment, please try again later. | GraphQLクエリエラー時 |
| MSG-002 | 成功 | Deployment approved successfully | 承認成功時（EE） |
| MSG-003 | エラー | Failed to approve deployment | 承認失敗時（EE） |

## 例外処理

| 例外 | 原因 | 対処 |
|------|------|------|
| 404 Not Found | 指定されたデプロイメントが存在しない | エラーページ表示 |
| 403 Forbidden | read_deployment権限がない | アクセス拒否画面へリダイレクト |
| GraphQL Error | APIリクエスト失敗 | エラーアラート表示、リトライ促進 |

## 備考

- 画面はVue.jsとGraphQLで実装されている
- デプロイメント情報は3秒間隔でポーリングされ、リアルタイムに更新される
- Protected Environments機能（EE）が有効な場合、承認ワークフロー関連のコンポーネントが表示される
- `protected_environments_available`属性がtrueの場合、Protected Environments設定へのリンクが表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Deploymentモデルの構造とGraphQL型定義を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | deployment.rb | `app/models/deployment.rb` | Deploymentモデルの属性、アソシエーション、状態遷移を理解 |
| 1-2 | deployment_type.rb | `app/graphql/types/deployment_type.rb` | GraphQL経由で公開されるフィールドを確認 |
| 1-3 | deployment.query.graphql | `app/assets/javascripts/deployments/graphql/queries/deployment.query.graphql` | フロントエンドが取得するデータ構造を確認 |

**読解のコツ**: Deploymentモデルは`state_machine`を使用して状態遷移を管理している。`VISIBLE_STATUSES`、`FINISHED_STATUSES`などの定数で状態グループを定義している点に注目。

#### Step 2: エントリーポイントを理解する

コントローラーとビューテンプレートの処理起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | deployments_controller.rb | `app/controllers/projects/deployments_controller.rb` | showアクションの実装、認可処理を確認 |
| 2-2 | show.html.haml | `app/views/projects/deployments/show.html.haml` | Vue.jsマウントポイントとdata属性の受け渡しを確認 |

**主要処理フロー**:
1. **20-26行目**: `show`アクション - `project.deployments.find_by_iid!`でデプロイメント取得
2. **4行目**: `authorize_read_deployment!`で読み取り権限チェック
3. **30-32行目**: `environment`メソッドで関連環境を取得

#### Step 3: フロントエンド（Vue.js）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show_deployment.vue | `app/assets/javascripts/deployments/components/show_deployment.vue` | メインコンポーネント、Apollo Clientによるデータ取得 |
| 3-2 | deployment_header.vue | `app/assets/javascripts/deployments/components/deployment_header.vue` | ヘッダー表示コンポーネント |
| 3-3 | deployment_aside.vue | `app/assets/javascripts/deployments/components/deployment_aside.vue` | サイドバー情報表示 |
| 3-4 | deployment_deploy_block.vue | `app/assets/javascripts/deployments/components/deployment_deploy_block.vue` | 手動デプロイブロック |

**主要処理フロー**:
- **31-48行目** (show_deployment.vue): Apollo Client設定、3秒ポーリング
- **96-100行目** (show_deployment.vue): ビジビリティ変更時のポーリング制御

#### Step 4: GraphQL層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | deployment_resolver.rb | `app/graphql/resolvers/deployment_resolver.rb` | デプロイメント取得のリゾルバー |
| 4-2 | deployment_type.rb | `app/graphql/types/deployment_type.rb` | 型定義とフィールド |

### プログラム呼び出し階層図

```
[ブラウザ]
    │
    ├─ GET /deployments/:id (HTML)
    │      └─ DeploymentsController#show
    │             └─ project.deployments.find_by_iid!
    │
    └─ POST /api/graphql (GraphQL)
           └─ fetchDeployment Query
                  └─ DeploymentResolver
                         └─ project.deployment(iid: iid)
                                └─ Deployment.find_by_iid!
```

### データフロー図

```
[入力]                     [処理]                           [出力]

ブラウザリクエスト    ───▶  DeploymentsController#show  ───▶  HTML (Vueマウントポイント)
(environment_id, iid)              │
                                   ▼
                           @deployment, @environment
                                   │
                                   ▼
Vue.js mounted           ───▶  Apollo Client            ───▶  GraphQL Query
                                   │
                                   ▼
                           DeploymentResolver
                                   │
                                   ▼
                           Deployment Model
                                   │
                                   ▼
                           PostgreSQL
                           (deployments, environments, ci_builds)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| deployment.rb | `app/models/deployment.rb` | モデル | Deploymentモデル定義 |
| deployments_controller.rb | `app/controllers/projects/deployments_controller.rb` | コントローラー | HTTPリクエスト処理 |
| show.html.haml | `app/views/projects/deployments/show.html.haml` | ビュー | HTMLテンプレート |
| show_deployment.vue | `app/assets/javascripts/deployments/components/show_deployment.vue` | Vueコンポーネント | メイン表示コンポーネント |
| deployment_header.vue | `app/assets/javascripts/deployments/components/deployment_header.vue` | Vueコンポーネント | ヘッダー部 |
| deployment_aside.vue | `app/assets/javascripts/deployments/components/deployment_aside.vue` | Vueコンポーネント | サイドバー部 |
| deployment_deploy_block.vue | `app/assets/javascripts/deployments/components/deployment_deploy_block.vue` | Vueコンポーネント | デプロイ実行ブロック |
| deployment.query.graphql | `app/assets/javascripts/deployments/graphql/queries/deployment.query.graphql` | GraphQL | データ取得クエリ |
| deployment_type.rb | `app/graphql/types/deployment_type.rb` | GraphQL型 | Deployment型定義 |
| deployment_resolver.rb | `app/graphql/resolvers/deployment_resolver.rb` | GraphQLリゾルバー | クエリ解決 |
| project.rb | `config/routes/project.rb` | ルーティング | URL定義 |
