# 画面設計書 85-リリース一覧

## 概要

本ドキュメントは、GitLabのリリース一覧画面の設計仕様を定義するものである。

### 本画面の処理概要

リリース一覧画面は、プロジェクトのリリース（ソフトウェアバージョンの公開単位）を一覧表示し、管理するための画面である。リリースはGitタグと関連付けられ、リリースノート、バイナリアセット、マイルストーンなどの情報を含む。

**業務上の目的・背景**：ソフトウェア開発において、特定のバージョンを正式に公開・配布する際にリリースを作成する。リリース一覧画面は、プロジェクトの公開履歴を俯瞰し、各バージョンのリリースノートや添付ファイルへのアクセスを提供する。ユーザーや利用者は、この画面からプロジェクトの最新バージョンや過去のバージョンを確認し、必要なアセットをダウンロードできる。また、ATOMフィード機能により、新しいリリースの通知を購読することも可能。

**画面へのアクセス方法**：プロジェクトのサイドメニューから「Deploy」>「Releases」を選択、またはURL直接アクセス。URLパターンは `/:namespace/:project/-/releases` となる。

**主要な操作・処理内容**：
1. リリース一覧の表示（リリース名、タグ、日時、説明）
2. リリースの新規作成画面への遷移
3. リリース詳細画面への遷移
4. リリースアセット（ソースコード、添付ファイル）のダウンロード
5. ATOMフィード購読
6. ページネーション（カーソルベース）

**画面遷移**：
- 遷移元：プロジェクトサイドメニュー、プロジェクト詳細画面、タグ詳細画面
- 遷移先：リリース新規作成画面、リリース詳細画面、リリース編集画面

**権限による表示制御**：
- `read_release`権限がない場合はアクセス不可
- `create_release`権限を持つユーザーのみ「New release」ボタンが表示される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 73 | リリース作成 | 主機能 | プロジェクトのリリース一覧表示 |

## 画面種別

一覧

## URL/ルーティング

```
GET /:namespace/:project/-/releases
GET /:namespace/:project/-/releases.json (JSON API)
GET /:namespace/:project/-/releases.atom (ATOM Feed)
```

## 入出力項目

### フィルタ/ソート項目

| 項目名 | データ型 | 必須 | 説明 |
|--------|----------|------|------|
| sort | String | - | ソート順（デフォルト: RELEASED_AT_DESC） |
| before | String | - | カーソルベースページネーション（前ページ） |
| after | String | - | カーソルベースページネーション（次ページ） |

## 表示項目

### リリースカード

| 項目名 | データ型 | 説明 | ソース |
|--------|----------|------|--------|
| リリース名 | String | リリースの名前（なければタグ名） | release.name |
| タグ名 | String | 関連するGitタグ | release.tag |
| リリース日時 | DateTime | リリース日時 | release.releasedAt |
| 作成者 | User | リリースを作成したユーザー | release.author |
| 説明 | String | リリースノート（Markdown） | release.description |
| アセット | Array | ソースコードダウンロードリンク、添付ファイル | release.assets |
| マイルストーン | Array<Milestone> | 関連するマイルストーン | release.milestones |
| エビデンス | Array<Evidence> | リリースエビデンス | release.evidences |

### ヘッダー情報

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| タイトル | String | "Releases" |
| ATOMフィードリンク | URL | リリースフィードへのリンク |

## イベント仕様

### 1-リリース新規作成

**トリガー**: 「New release」ボタン押下

**前提条件**:
- `create_release`権限を持つ

**処理フロー**: 新規作成画面へ遷移

**遷移先**: `/:namespace/:project/-/releases/new`

### 2-リリース詳細表示

**トリガー**: リリース名またはタグ名クリック

**処理フロー**: リリース詳細画面へ遷移

**遷移先**: `/:namespace/:project/-/releases/:tag`

### 3-アセットダウンロード

**トリガー**: ダウンロードリンククリック

**処理フロー**:
1. ソースコード（zip/tar.gz）の場合：アーカイブ生成・ダウンロード
2. 添付ファイルの場合：ファイルダウンロード

**遷移先**: ファイルダウンロード

### 4-ページネーション

**トリガー**: 「次へ」「前へ」ボタン押下

**処理フロー**:
1. GraphQLクエリを実行（カーソルベース）
2. 新しいページのリリースを表示
3. URLパラメータを更新

**遷移先**: 同一画面（パラメータ変更）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | releases | SELECT | リリース一覧の取得 |
| 画面表示 | releases_links | SELECT | リリースアセットの取得 |
| 画面表示 | milestone_releases | SELECT | マイルストーン関連の取得 |
| 画面表示 | releases_evidences | SELECT | エビデンスの取得 |

### テーブル別更新項目詳細

#### releases

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, project_id, tag, name, description, description_html, released_at, created_at, author_id | project_id = プロジェクトID, ORDER BY released_at DESC | GraphQL経由 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 情報 | Getting started with releases | 空状態時のタイトル |
| MSG-002 | 情報 | Releases are snapshots of your project... | 空状態時の説明 |
| MSG-003 | エラー | Something went wrong fetching the releases | 取得エラー時 |

## 例外処理

| 例外 | 原因 | 対処 |
|------|------|------|
| 403 Forbidden | read_release権限がない | アクセス拒否画面へリダイレクト |
| GraphQL Error | データ取得失敗 | エラーメッセージ表示 |

## 備考

- リリース一覧はGraphQL APIで取得される
- デフォルトソートは`RELEASED_AT_DESC`（リリース日時の降順）
- ページネーションはカーソルベース（GraphQL Relay形式）
- ATOMフィードが提供され、RSS購読が可能
- 起動時クエリ最適化（startup query）が実装されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | release.rb | `app/models/release.rb` | Releaseモデルの属性、アソシエーションを確認 |

**読解のコツ**: Releaseは`tag`をプライマリ識別子として使用。`released_at`でリリース日時を管理し、`upcoming_release?`で将来リリースを判定。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | releases_controller.rb | `app/controllers/projects/releases_controller.rb` | indexアクション、認可処理 |
| 2-2 | index.html.haml | `app/views/projects/releases/index.html.haml` | Vueマウントポイント |
| 2-3 | releases_helper.rb | `app/helpers/releases_helper.rb` | data属性の生成 |

**主要処理フロー**:
1. **7行目**: `authorize_read_release!`で読み取り権限チェック
2. **20-32行目**: `index`アクションでHTML/JSON/ATOMに対応
3. **14-26行目** (helper): `data_for_releases_page`でVueにデータ渡し

#### Step 3: フロントエンド（Vue.js + GraphQL）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | releases_index_app.vue | `app/assets/javascripts/releases/components/releases_index_app.vue` | メインコンポーネント |

**主要処理フロー**:
- GraphQLクエリ`allReleases`でリリース一覧を取得
- カーソルベースページネーションを実装

### プログラム呼び出し階層図

```
[ブラウザ]
    │
    ├─ GET /releases (HTML)
    │      └─ ReleasesController#index
    │             └─ HTML response (Vue mount point)
    │
    ├─ POST /api/graphql (GraphQL)
    │      └─ allReleases Query
    │             └─ ReleasesFinder
    │                    └─ Release.sorted
    │
    └─ GET /releases.atom (ATOM)
           └─ ReleasesController#index
                  └─ ReleasesFinder
                         └─ XML response
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| release.rb | `app/models/release.rb` | モデル | Releaseモデル定義 |
| releases_controller.rb | `app/controllers/projects/releases_controller.rb` | コントローラー | HTTPリクエスト処理 |
| index.html.haml | `app/views/projects/releases/index.html.haml` | ビュー | HTMLテンプレート |
| releases_helper.rb | `app/helpers/releases_helper.rb` | ヘルパー | ビューデータ生成 |
| releases_finder.rb | `app/finders/releases_finder.rb` | ファインダー | 検索・フィルタリング |
