# 画面設計書 86-リリース新規作成

## 概要

本ドキュメントは、GitLabのリリース新規作成画面の設計仕様を定義するものである。

### 本画面の処理概要

リリース新規作成画面は、プロジェクトの新しいリリースを作成するための画面である。Gitタグを選択または作成し、リリースノート、アセット、マイルストーンなどを設定してリリースを公開する。

**業務上の目的・背景**：ソフトウェアの特定バージョンを正式にリリースする際に使用する。リリースを作成することで、そのバージョンに関する情報（変更履歴、ダウンロードリンク、関連マイルストーン等）を一元管理し、利用者に提供できる。CI/CDパイプラインからの自動リリースだけでなく、手動でのリリース作成も可能。

**画面へのアクセス方法**：リリース一覧画面から「New release」ボタンをクリック、タグ詳細画面から「Create release」をクリック、またはURL直接アクセス。URLパターンは `/:namespace/:project/-/releases/new` となる。タグ名を指定する場合は `?tag_name=v1.0.0` パラメータ付き。

**主要な操作・処理内容**：
1. タグの選択または新規作成
2. リリース名の入力（オプション、デフォルトはタグ名）
3. リリースノートの入力（Markdown対応）
4. リリース日時の設定（デフォルトは現在、将来日時で予約可能）
5. マイルストーンの関連付け
6. アセット（リンク）の追加
7. リリースの作成実行

**画面遷移**：
- 遷移元：リリース一覧画面、タグ詳細画面
- 遷移先：リリース一覧画面（作成成功時）

**権限による表示制御**：
- `create_release`権限がない場合はアクセス不可

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 73 | リリース作成 | 主機能 | 新規リリースの作成 |
| 74 | リリースアセット | 補助機能 | リリースアセットの添付 |

## 画面種別

登録

## URL/ルーティング

```
GET /:namespace/:project/-/releases/new
POST /api/graphql (GraphQL Mutation: releaseCreate)
```

## 入出力項目

### 入力項目

| 項目名 | データ型 | 必須 | バリデーション | 説明 |
|--------|----------|------|----------------|------|
| Tag name | String | 必須 | - | 関連付けるGitタグ名 |
| Create from | String | - | 有効なブランチ/タグ/SHA | 新規タグ作成時の基点 |
| Release title | String | - | 最大255文字 | リリース名（空の場合タグ名を使用） |
| Release notes | String | - | - | リリースノート（Markdown） |
| Released at | DateTime | - | - | リリース日時 |
| Milestones | Array<String> | - | 有効なマイルストーン | 関連マイルストーン |
| Release assets | Array<Link> | - | - | アセットリンク |

### アセットリンク項目

| 項目名 | データ型 | 必須 | 説明 |
|--------|----------|------|------|
| name | String | 必須 | リンク名 |
| url | String | 必須 | リンクURL |
| type | String | - | リンクタイプ（other/runbook/image/package） |
| filepath | String | - | 直接ダウンロード用パス |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| タイトル | String | "New release" |
| Markdownプレビュー | - | リリースノートのプレビュー表示 |

## イベント仕様

### 1-リリース作成

**トリガー**: 「Create release」ボタン押下

**処理フロー**:
1. GraphQL Mutation `releaseCreate`を実行
2. 必要に応じてタグを作成
3. Releaseレコードを作成
4. アセットリンクを作成
5. マイルストーンを関連付け
6. 成功時：リリース一覧画面へリダイレクト
7. 失敗時：エラーメッセージを表示

**遷移先**: リリース一覧画面 または 同一画面（エラー時）

### 2-キャンセル

**トリガー**: 「Cancel」ボタン押下

**処理フロー**: リリース一覧画面へ遷移

**遷移先**: `/:namespace/:project/-/releases`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成 | releases | INSERT | リリースの作成 |
| 作成 | releases_links | INSERT | アセットリンクの作成 |
| 作成 | milestone_releases | INSERT | マイルストーン関連付け |
| 作成（タグ新規時） | Git | TAG CREATE | Gitタグの作成 |

### テーブル別更新項目詳細

#### releases

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | project_id | 現在のプロジェクトID | |
| INSERT | tag | タグ名 | |
| INSERT | name | リリース名（NULL可） | |
| INSERT | description | リリースノート | |
| INSERT | released_at | リリース日時 | |
| INSERT | author_id | 現在のユーザーID | |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | エラー | Tag name is required | タグ名未入力 |
| MSG-002 | エラー | Release already exists | 同じタグでリリース済み |
| MSG-003 | 情報 | Upcoming releases | 将来リリースの説明 |

## 例外処理

| 例外 | 原因 | 対処 |
|------|------|------|
| 403 Forbidden | create_release権限がない | アクセス拒否画面へリダイレクト |
| Validation Error | 入力値エラー | エラーメッセージを表示 |

## 備考

- タグが存在しない場合、リリース作成時に自動でタグも作成される
- 将来の日時を設定すると「Upcoming release」として扱われる
- Markdownプレビュー機能がある
- アセットリンクはリリース詳細画面でダウンロードリンクとして表示される

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | releases_controller.rb | `app/controllers/projects/releases_controller.rb` | newアクション |
| 1-2 | new.html.haml | `app/views/projects/releases/new.html.haml` | Vueマウントポイント |
| 1-3 | releases_helper.rb | `app/helpers/releases_helper.rb` | data_for_new_release_page |

**主要処理フロー**:
1. **9行目**: `authorize_create_release!`で作成権限チェック
2. **58-64行目** (helper): `data_for_new_release_page`でVueにデータ渡し

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| release.rb | `app/models/release.rb` | モデル | Releaseモデル定義 |
| releases_controller.rb | `app/controllers/projects/releases_controller.rb` | コントローラー | HTTPリクエスト処理 |
| new.html.haml | `app/views/projects/releases/new.html.haml` | ビュー | HTMLテンプレート |
| releases_helper.rb | `app/helpers/releases_helper.rb` | ヘルパー | ビューデータ生成 |
