# 画面設計書 87-リリース詳細

## 概要

本ドキュメントは、GitLabのリリース詳細画面の設計仕様を定義するものである。

### 本画面の処理概要

リリース詳細画面は、特定のリリースの詳細情報を表示するための画面である。リリースノート、関連するアセット（ダウンロードリンク）、マイルストーン、エビデンス、デプロイメント情報などを確認できる。

**業務上の目的・背景**：ソフトウェアの特定バージョンに関する情報を集約して表示する。利用者はこの画面から、リリースノートの確認、ソースコードやバイナリのダウンロード、関連するマイルストーンの確認、デプロイメント状況の把握を行う。外部ユーザーへの公開情報としても機能し、プロジェクトの変更履歴を伝える重要な画面である。

**画面へのアクセス方法**：リリース一覧画面からリリース名またはタグ名をクリック、またはURL直接アクセス。URLパターンは `/:namespace/:project/-/releases/:tag` となる。

**主要な操作・処理内容**：
1. リリース情報の表示（名前、タグ、日時、作成者）
2. リリースノート（Markdown）の表示
3. アセット（ソースコード、添付ファイル）のダウンロード
4. 関連マイルストーンの確認
5. エビデンス情報の確認
6. デプロイメント情報の確認
7. リリース編集画面への遷移

**画面遷移**：
- 遷移元：リリース一覧画面、タグ詳細画面、通知メール
- 遷移先：リリース編集画面、マイルストーン詳細画面、デプロイメント詳細画面

**権限による表示制御**：
- `read_release`権限がない場合はアクセス不可
- `update_release`権限を持つユーザーのみ編集ボタンが表示される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 73 | リリース作成 | 主機能 | リリース情報の表示 |
| 74 | リリースアセット | 補助機能 | アセットのダウンロード |

## 画面種別

詳細

## URL/ルーティング

```
GET /:namespace/:project/-/releases/:tag
```

## 入出力項目

### パスパラメータ

| 項目名 | データ型 | 必須 | 説明 |
|--------|----------|------|------|
| tag | String | 必須 | リリースに関連付けられたタグ名 |

## 表示項目

### リリース基本情報

| 項目名 | データ型 | 説明 | ソース |
|--------|----------|------|--------|
| リリース名 | String | リリースの名前（なければタグ名） | release.name |
| タグ名 | String | 関連するGitタグ | release.tag |
| リリース日時 | DateTime | リリース日時 | release.releasedAt |
| 作成者 | User | リリースを作成したユーザー | release.author |
| リリースノート | String | リリースノート（Markdown、HTMLレンダリング済み） | release.descriptionHtml |

### アセット情報

| 項目名 | データ型 | 説明 | ソース |
|--------|----------|------|--------|
| ソースコード（zip） | Link | ソースコードのZIPアーカイブ | release.assets.sources |
| ソースコード（tar.gz） | Link | ソースコードのtar.gzアーカイブ | release.assets.sources |
| 添付ファイル | Array<Link> | ユーザーが添付したファイル | release.assets.links |

### マイルストーン情報

| 項目名 | データ型 | 説明 | ソース |
|--------|----------|------|--------|
| マイルストーン一覧 | Array<Milestone> | 関連するマイルストーン | release.milestones |
| イシュー統計 | Object | オープン/クローズのイシュー数 | milestone.issueStats |

### エビデンス情報

| 項目名 | データ型 | 説明 | ソース |
|--------|----------|------|--------|
| エビデンス一覧 | Array<Evidence> | リリースエビデンス | release.evidences |
| 収集日時 | DateTime | エビデンス収集日時 | evidence.collectedAt |
| ファイルパス | String | エビデンスファイルへのパス | evidence.filepath |
| SHA | String | エビデンスのSHA256ハッシュ | evidence.sha |

### デプロイメント情報

| 項目名 | データ型 | 説明 | ソース |
|--------|----------|------|--------|
| 環境名 | String | デプロイ先環境の名前 | deployment.environment.name |
| デプロイ状態 | String | デプロイメントのステータス | deployment.status |
| コミット情報 | Object | デプロイされたコミット | deployment.commit |
| 実行者 | User | デプロイを実行したユーザー | deployment.triggerer |
| 完了日時 | DateTime | デプロイ完了日時 | deployment.finishedAt |

## イベント仕様

### 1-リリース編集

**トリガー**: 「Edit」ボタン押下

**前提条件**:
- `update_release`権限を持つ

**処理フロー**: リリース編集画面へ遷移

**遷移先**: `/:namespace/:project/-/releases/:tag/edit`

### 2-アセットダウンロード

**トリガー**: ダウンロードリンククリック

**処理フロー**:
1. ソースコード（zip/tar.gz）の場合：アーカイブ生成・ダウンロード
2. 添付ファイルの場合：ファイルダウンロード

**遷移先**: ファイルダウンロード

### 3-マイルストーン詳細表示

**トリガー**: マイルストーン名クリック

**処理フロー**: マイルストーン詳細画面へ遷移

**遷移先**: `/:namespace/:project/-/milestones/:id`

### 4-エビデンスダウンロード

**トリガー**: エビデンスのファイルパスクリック

**処理フロー**: エビデンスJSONファイルをダウンロード

**遷移先**: ファイルダウンロード

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | releases | SELECT | リリース情報の取得 |
| 画面表示 | releases_links | SELECT | リリースアセットの取得 |
| 画面表示 | milestone_releases | SELECT | マイルストーン関連の取得 |
| 画面表示 | releases_evidences | SELECT | エビデンスの取得 |
| 画面表示 | deployments | SELECT | デプロイメント情報の取得 |

### テーブル別更新項目詳細

#### releases

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, project_id, tag, name, description, description_html, released_at, created_at, author_id | project_id = プロジェクトID, tag = パスパラメータ | |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 情報 | Upcoming Release | 将来リリース時のバッジ |
| MSG-002 | エラー | Something went wrong fetching the release | 取得エラー時 |
| MSG-003 | ラベル | Assets | アセットセクションタイトル |
| MSG-004 | ラベル | Evidence collection | エビデンスセクションタイトル |

## 例外処理

| 例外 | 原因 | 対処 |
|------|------|------|
| 404 Not Found | 指定されたタグのリリースが存在しない | エラーページ表示 |
| 403 Forbidden | read_release権限がない | アクセス拒否画面へリダイレクト |

## 備考

- リリース詳細はGraphQL APIで取得される
- デプロイメント情報はヘルパーで事前に計算されJSONとして渡される
- 将来のリリース（released_at > 現在時刻）は「Upcoming Release」バッジが表示される
- エビデンスは自動収集されたリリース時点のスナップショット情報
- リリースノートはMarkdownからHTMLにレンダリング済みで表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | release.rb | `app/models/release.rb` | Releaseモデルの属性、アソシエーションを確認 |

**読解のコツ**: Releaseは`tag`をプライマリ識別子として使用。`related_deployments`メソッドでデプロイメント情報を取得。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | releases_controller.rb | `app/controllers/projects/releases_controller.rb` | showアクション、認可処理 |
| 2-2 | show.html.haml | `app/views/projects/releases/show.html.haml` | Vueマウントポイント |
| 2-3 | releases_helper.rb | `app/helpers/releases_helper.rb` | data_for_show_page |

**主要処理フロー**:
1. **7行目**: `authorize_read_release!`で読み取り権限チェック
2. **14行目**: `before_action :release`でリリース取得
3. **41-48行目** (helper): `data_for_show_page`でVueにデータ渡し
4. **88-122行目** (helper): `deployments_for_release`でデプロイメント情報を生成

#### Step 3: フロントエンド（Vue.js + GraphQL）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show_release_page.vue | `app/assets/javascripts/releases/components/show_release_page.vue` | メインコンポーネント |

**主要処理フロー**:
- GraphQLクエリ`oneRelease`でリリース詳細を取得
- デプロイメント情報はdata属性から取得（サーバーサイドで計算済み）

### プログラム呼び出し階層図

```
[ブラウザ]
    │
    ├─ GET /releases/:tag (HTML)
    │      └─ ReleasesController#show
    │             ├─ authorize_read_release!
    │             ├─ @release = Release.find_by_tag
    │             └─ HTML response (Vue mount point)
    │                    └─ data_for_show_page (deployments含む)
    │
    └─ POST /api/graphql (GraphQL)
           └─ oneRelease Query
                  └─ ReleasesFinder.find_by_tag
                         └─ Release + associations
```

### データフロー図

```
[リリースデータ取得]
    │
    ├─ GraphQL oneRelease クエリ
    │      └─ Release
    │             ├─ name, tag, description
    │             ├─ releasedAt, createdAt
    │             ├─ author
    │             ├─ assets (sources, links)
    │             ├─ milestones
    │             └─ evidences
    │
    └─ data属性 (サーバーサイド)
           └─ deployments_for_release
                  ├─ environment (name, url)
                  ├─ status
                  ├─ deployment (id, url)
                  ├─ commit (sha, title)
                  ├─ triggerer
                  ├─ created_at
                  └─ finished_at
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| release.rb | `app/models/release.rb` | モデル | Releaseモデル定義 |
| releases_controller.rb | `app/controllers/projects/releases_controller.rb` | コントローラー | HTTPリクエスト処理 |
| show.html.haml | `app/views/projects/releases/show.html.haml` | ビュー | HTMLテンプレート |
| releases_helper.rb | `app/helpers/releases_helper.rb` | ヘルパー | ビューデータ生成 |
| show_release_page.vue | `app/assets/javascripts/releases/components/show_release_page.vue` | Vueコンポーネント | 詳細画面 |
