# 画面設計書 9-OAuth認可画面

## 概要

本ドキュメントは、GitLabのOAuth認可画面の設計仕様を記載したものです。外部アプリケーションがユーザーのGitLabアカウントへのアクセス権を要求する際に表示される画面です。

### 本画面の処理概要

**業務上の目的・背景**：OAuth認可画面は、OAuth 2.0プロトコルに基づき、サードパーティアプリケーションがGitLabユーザーに代わってAPIにアクセスする許可を得るための画面を提供します。ユーザーはアプリケーションが要求するスコープ（権限範囲）を確認し、認可するかどうかを判断できます。これにより、ユーザーは自分のパスワードを外部アプリケーションに渡すことなく、安全にサービス連携を実現できます。管理者向けの警告や、アプリケーションの信頼性表示も含まれています。

**画面へのアクセス方法**：
- 外部アプリケーションからのOAuth認可フロー開始時に自動的にリダイレクト
- `/oauth/authorize` に認可パラメータ付きでアクセス

**主要な操作・処理内容**：
1. 認可を要求しているアプリケーション情報の表示
2. 要求されているスコープ（権限）の確認
3. アプリケーションの信頼性情報の確認
4. 認可の承認または拒否
5. 認可コードの発行とリダイレクト

**画面遷移**：
- 遷移元：外部アプリケーション（OAuth認可リクエスト）
- 遷移先：外部アプリケーション（認可コード付きリダイレクト）、外部アプリケーション（拒否時）

**権限による表示制御**：
- 認証済みユーザーのみがアクセス可能
- 管理者ユーザーには追加の警告メッセージが表示される
- GitLab提供のアプリケーションには信頼性バッジが表示される（GitLab.com）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 88 | OAuth2プロバイダ | 主機能 | OAuthアプリケーション認可の確認・許可処理 |

## 画面種別

確認・認可画面

## URL/ルーティング

| HTTPメソッド | URL | アクション |
|-------------|-----|----------|
| GET | `/oauth/authorize` | 認可画面表示 |
| POST | `/oauth/authorize` | 認可承認処理 |
| DELETE | `/oauth/authorize` | 認可拒否処理 |

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | 物理名 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| クライアントID | client_id | string | Yes | OAuthアプリケーションID |
| リダイレクトURI | redirect_uri | string | Yes | 認可後のリダイレクト先 |
| レスポンスタイプ | response_type | string | Yes | 通常 "code" |
| スコープ | scope | string | No | 要求する権限範囲 |
| ステート | state | string | 推奨 | CSRF防止用ランダム文字列 |
| ノンス | nonce | string | No | OIDC用ノンス |
| コードチャレンジ | code_challenge | string | No | PKCE用チャレンジ |
| コードチャレンジメソッド | code_challenge_method | string | No | PKCE用メソッド（S256） |

### 送信項目（隠しフィールド）

| 項目名 | 物理名 | 型 | 説明 |
|--------|--------|-----|------|
| クライアントID | client_id | string | アプリケーションID |
| リダイレクトURI | redirect_uri | string | コールバックURL |
| ステート | state | string | 状態維持用トークン |
| レスポンスタイプ | response_type | string | レスポンス形式 |
| スコープ | scope | string | 認可スコープ |
| ノンス | nonce | string | OIDC用 |
| コードチャレンジ | code_challenge | string | PKCE用 |
| コードチャレンジメソッド | code_challenge_method | string | PKCE用 |

## 表示項目

| 項目名 | 説明 | 条件 |
|--------|------|------|
| アプリケーション名 | 認可を要求しているアプリ名（太字） | 常時表示 |
| ユーザー情報 | 現在ログイン中のユーザーアバター・名前・ユーザー名 | 常時表示 |
| 管理者警告 | 管理者権限でのアクセスに関する警告 | 管理者ユーザー時 |
| スコープ一覧 | 要求されている権限の詳細（アコーディオン形式） | スコープ指定時 |
| 信頼性表示 | GitLab提供アプリの認証バッジ | GitLab.com + GitLab提供アプリ |
| 警告メッセージ | サードパーティアプリの信頼性確認促進 | サードパーティアプリ時 |
| アプリケーション情報 | 作成者、作成日時 | 常時表示 |
| リダイレクト先ドメイン | 認可後のリダイレクト先ドメイン | HTTP/HTTPS時 |
| Authorizeボタン | 認可承認ボタン | 常時表示 |
| Cancelボタン | 認可拒否ボタン | 常時表示 |

## イベント仕様

### 1-Authorizeボタン押下

**トリガー**: 「Authorize {アプリ名}」ボタンクリック

**処理フロー**:
1. 認可リクエストの検証
2. 認可コードの生成
3. OAuthアクセスグラントの作成
4. リダイレクトURIへの認可コード付きリダイレクト

**成功時**: 外部アプリケーションのリダイレクトURIに認可コードとstateを付けてリダイレクト
**失敗時**: エラー情報を付けてリダイレクト

### 2-Cancelボタン押下

**トリガー**: 「Cancel」ボタンクリック

**処理フロー**:
1. 認可拒否の処理
2. エラー情報を含むリダイレクト

**結果**: 外部アプリケーションのリダイレクトURIに `error=access_denied` を付けてリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 認可承認 | oauth_access_grants | INSERT | 認可コード作成 |
| トークン発行時 | oauth_access_tokens | INSERT | アクセストークン作成 |

### テーブル別更新項目詳細

#### oauth_access_grants

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | token | 認可コード（ハッシュ化） | Doorkeeper生成 |
| INSERT | resource_owner_id | ユーザーID | 認可したユーザー |
| INSERT | application_id | OAuthアプリケーションID | - |
| INSERT | redirect_uri | コールバックURL | - |
| INSERT | scopes | 認可されたスコープ | - |
| INSERT | expires_in | 有効期限（秒） | 通常10分 |
| INSERT | code_challenge | PKCEチャレンジ | PKCE使用時 |
| INSERT | code_challenge_method | PKCEメソッド | PKCE使用時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|---------------|----------|
| MSG001 | タイトル | {app_name} is requesting access to your account on {gitlab_title}. | 常時表示 |
| MSG002 | 警告 | You are an administrator, which means authorizing access to {app_name} will allow it to interact with GitLab as an administrator as well. | 管理者ユーザー時 |
| MSG003 | 成功 | This application is provided by GitLab. | GitLab提供アプリ時 |
| MSG004 | 警告 | Make sure you trust {app_name} before authorizing. | サードパーティアプリ時 |
| MSG005 | 情報 | {owner} {created_date} ago. You will be redirected to {domain} after authorizing. | 常時表示 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 未認証ユーザー | ログイン画面にリダイレクト後、認可フローを再開 |
| 無効なクライアントID | エラーページ表示 |
| 無効なリダイレクトURI | エラーページ表示（リダイレクトしない） |
| 無効なスコープ | エラー情報を付けてリダイレクト |
| アプリケーション無効 | エラーページ表示 |

## 備考

- Doorkeeper gemによりOAuth 2.0サーバー機能を提供
- PKCE（Proof Key for Code Exchange）をサポート
- OpenID Connect（OIDC）のスコープもサポート
- 認可コードの有効期限はデフォルト10分
- ポインターイベントは500msの遅延後に有効化（クリックジャッキング対策）
- 動的に登録されたアプリケーション（dynamic）も表示される
- localhostへのリダイレクトではドメイン表示をスキップ

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

OAuth認可に関連するモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | application.rb | `app/models/doorkeeper/application.rb` | OAuthアプリケーションモデル |
| 1-2 | access_grant.rb | `app/models/doorkeeper/access_grant.rb` | 認可コードモデル |

**読解のコツ**: DoorkeeperはOAuth 2.0サーバー実装のgemで、Railsの規約に従った構造を持つ。

#### Step 2: ビューテンプレートを理解する

画面の構成要素を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | new.html.haml | `app/views/doorkeeper/authorizations/new.html.haml` | 認可画面テンプレート |

**主要処理フロー**:
- **1-11行目**: ポインターイベント遅延のJavaScript（クリックジャッキング対策）
- **15-17行目**: アプリケーション名とリクエストメッセージ
- **18-24行目**: ユーザー情報表示
- **25-30行目**: 管理者警告（条件付き）
- **31-38行目**: スコープアコーディオン
- **39-58行目**: 信頼性情報とアプリケーション詳細
- **60-83行目**: 認可/キャンセルフォーム

### プログラム呼び出し階層図

```
Doorkeeper::AuthorizationsController#new
    │
    ├─ authorize_response (pre_auth検証)
    │      ├─ クライアント検証
    │      ├─ リダイレクトURI検証
    │      └─ スコープ検証
    │
    └─ render 'new'

Doorkeeper::AuthorizationsController#create
    │
    ├─ authorization.authorize (認可処理)
    │      ├─ AccessGrant.create
    │      └─ 認可コード生成
    │
    └─ redirect_to redirect_uri (認可コード付き)

Doorkeeper::AuthorizationsController#destroy
    │
    └─ redirect_to redirect_uri (error=access_denied)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

OAuth認可リクエスト    ───▶ AuthorizationsController#new ───▶ 認可画面表示
(client_id, redirect_uri,    │
 scope, state, etc.)         │
                             ▼
ユーザー認可承認      ───▶ AuthorizationsController#create ───▶ リダイレクト
                             │                                   (code, state)
                             ├─ AccessGrant.create ───▶ oauth_access_grants INSERT
                             │
                             └─ 認可コード生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| new.html.haml | `app/views/doorkeeper/authorizations/new.html.haml` | ビュー | OAuth認可画面テンプレート |
| application.rb | `app/models/doorkeeper/application.rb` | モデル | OAuthアプリケーションモデル |
| access_grant.rb | `app/models/doorkeeper/access_grant.rb` | モデル | 認可コードモデル |
| access_token.rb | `app/models/doorkeeper/access_token.rb` | モデル | アクセストークンモデル |
| doorkeeper.rb | `config/initializers/doorkeeper.rb` | 設定 | Doorkeeper設定 |
| routes.rb | `config/routes.rb` | 設定 | use_doorkeeper ルーティング |
