# 画面設計書 92-AWS設定

## 概要

本ドキュメントは、GitLabにおけるAWS連携設定画面の設計仕様を記述したものです。

### 本画面の処理概要

この画面では、GitLabプロジェクトとAmazon Web Services (AWS) の連携設定を管理します。現在は基本的なフレームワークのみが実装されており、具体的な設定項目はフロントエンドのVue.jsコンポーネントで提供される予定です。

**業務上の目的・背景**：
クラウドネイティブな開発環境において、GitLabのCI/CDパイプラインからAWSリソースへのアクセスが必要となるケースが増加しています。本画面は、AWSとGitLabプロジェクトを安全に連携させるための設定インターフェースを提供し、DevOpsワークフローを効率化することを目的としています。CloudSeed機能の一部として、AWSへのデプロイメント自動化やリソース管理を支援します。

**画面へのアクセス方法**：
1. プロジェクト画面から左側ナビゲーションの「インフラストラクチャ」セクションを展開
2. 「AWS」をクリック
3. 自動的に「Configuration」（設定）サブページにリダイレクト

**主要な操作・処理内容**：
1. AWS連携設定の表示（フロントエンド実装依存）
2. AWS認証情報の設定
3. デプロイメント先リージョンの設定

**画面遷移**：
- 遷移元：プロジェクトダッシュボード、インフラストラクチャメニュー
- 遷移先：（現在は設定画面のみ）

**権限による表示制御**：
- `admin_project_aws` 権限が必要
- `cloudseed_aws` フィーチャーフラグが有効である必要がある（ユーザー、グループ、またはプロジェクト単位で有効化）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 60 | Kubernetesクラスター連携 | 主機能 | AWS連携の設定 |
| 50 | CI変数管理 | 補助機能 | AWS認証情報のCI変数への保存 |

## 画面種別

設定画面

## URL/ルーティング

- URL: `/:namespace_id/:project_id/-/aws/configuration`
- ルート定義: `config/routes/project.rb`
- コントローラー: `Projects::Aws::ConfigurationController#index`

## 入出力項目

### 入力項目

本画面は現在主に表示用途であり、具体的な入力項目はフロントエンドコンポーネントに依存します。

### 出力項目（表示データ）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| js_data | Object | フロントエンドに渡されるJSON形式のデータ（現在は空オブジェクト） |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| AWS設定フォーム | Vue.jsコンポーネント | AWS連携設定用のUI（フロントエンド実装） |

## イベント仕様

### 1-画面表示

**処理フロー**：
1. ユーザーが画面URLにアクセス
2. `admin_project_aws!` で権限チェック
3. `feature_flag_enabled!` でフィーチャーフラグチェック
4. 空のjs_dataオブジェクトをJSON形式で生成
5. `track_event(:render_page)` でイベントトラッキング
6. Vue.jsコンポーネントをレンダリング

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | なし | - | 現在の実装では直接のDB操作なし |

### テーブル別更新項目詳細

現在の実装では、画面表示時にデータベースへの直接的な読み書きは行われません。フロントエンドからのAPI呼び出しにより、別途データベース操作が発生する可能性があります。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG-001 | エラー | Access Denied | admin_project_aws権限なし |
| MSG-002 | エラー | Access Denied | cloudseed_awsフィーチャーフラグ無効 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| cloudseed_awsフラグ無効 | 403エラー画面を表示、イベントトラッキングで記録 |
| 権限不足 | 403 Access Denied画面を表示、イベントトラッキングで記録 |
| プロジェクト未存在 | 404エラー画面を表示 |

## 備考

- 本画面はVue.jsコンポーネント（`#js-aws-configuration`）で実装されている
- 画面データは`@js_data`としてJSON形式でフロントエンドに渡される（現在は空オブジェクト）
- CloudSeed機能の一部として実装されており、フィーチャーフラグで有効化が必要
- `fluid_layout`でない場合、コンテンツ幅が`limit-container-width`に制限される
- この機能は https://gitlab.com/gitlab-org/gitlab/-/issues/478491 で削除予定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フロントエンドに渡されるデータ構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | configuration_controller.rb | `app/controllers/projects/aws/configuration_controller.rb` | js_dataの構造（現在は空オブジェクト） |

**読解のコツ**: 現在の実装は非常にシンプルで、空のJSONオブジェクトのみを渡しています。将来的な拡張を考慮した構造になっています。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | configuration_controller.rb | `app/controllers/projects/aws/configuration_controller.rb` | indexアクションの処理フロー |

**主要処理フロー**:
1. **6-10行**: `index`メソッドで空のjs_dataを構築
2. **7行**: 空のハッシュを生成
3. **8行**: JSON形式に変換
4. **9行**: イベントトラッキングを実行

#### Step 3: 基底コントローラーを理解する

認証・認可のロジックを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | base_controller.rb | `app/controllers/projects/aws/base_controller.rb` | before_actionフィルタの処理 |

**主要処理フロー**:
- **9行**: `admin_project_aws!` - 権限チェック
- **10行**: `feature_flag_enabled!` - フィーチャーフラグチェック
- **12-17行**: 権限チェックの実装
- **19-26行**: フィーチャーフラグチェックの実装

### プログラム呼び出し階層図

```
Projects::Aws::ConfigurationController#index
    │
    ├─ before_action: admin_project_aws! (BaseController)
    │      └─ can?(current_user, :admin_project_aws, project)
    │             └─ 権限がない場合: track_event(:error_invalid_user) → access_denied!
    │
    ├─ before_action: feature_flag_enabled! (BaseController)
    │      ├─ Feature.enabled?(:cloudseed_aws, current_user)
    │      ├─ Feature.enabled?(:cloudseed_aws, project.group)
    │      └─ Feature.enabled?(:cloudseed_aws, project)
    │             └─ すべて無効な場合: track_event(:error_feature_flag_not_enabled) → access_denied!
    │
    ├─ @js_data = Gitlab::Json.dump({})
    │
    └─ track_event(:render_page)
           └─ Gitlab::Tracking.event(...)
```

### データフロー図

```
[入力]               [処理]                    [出力]

リクエスト ───▶ ConfigurationController#index ───▶ @js_data (JSON: {})
                       │                              │
                       ├─ 権限チェック                │
                       │                              │
                       ├─ フィーチャーフラグチェック  │
                       │                              │
                       └─ イベントトラッキング        │
                                                      │
                                                      ▼
                                                Vue.js Component
                                                (#js-aws-configuration)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html.haml | `app/views/projects/aws/configuration/index.html.haml` | テンプレート | 画面のHTMLテンプレート |
| configuration_controller.rb | `app/controllers/projects/aws/configuration_controller.rb` | コントローラー | 画面のメインコントローラー |
| base_controller.rb | `app/controllers/projects/aws/base_controller.rb` | コントローラー | 共通認証・認可ロジック |
| project.rb | `config/routes/project.rb` | ルーティング | URLルーティング定義（326-329行） |
