# 画面設計書 93-パッケージ一覧

## 概要

本ドキュメントは、GitLabにおけるパッケージレジストリ一覧画面の設計仕様を記述したものです。

### 本画面の処理概要

この画面では、プロジェクトに登録されたパッケージ（Maven、npm、NuGet、PyPI、Composer、Generic、Helm、Terraformモジュール、Cargoなど）の一覧を表示・管理します。パッケージのフィルタリング、検索、削除機能を提供し、各種パッケージマネージャーとの連携情報も確認できます。

**業務上の目的・背景**：
ソフトウェア開発において、ライブラリやモジュールの管理は非常に重要です。GitLabパッケージレジストリは、様々なパッケージ形式をサポートする統合的なアーティファクト管理機能を提供します。本画面は、プロジェクト内で公開・管理されているパッケージを一覧表示し、バージョン管理、削除、設定へのナビゲーションを可能にします。これにより、開発者は自社ライブラリや依存関係を効率的に管理できます。

**画面へのアクセス方法**：
1. プロジェクト画面から左側ナビゲーションの「パッケージとレジストリ」セクションを展開
2. 「パッケージレジストリ」をクリック

**主要な操作・処理内容**：
1. パッケージ一覧の表示（ページネーション付き）
2. パッケージの検索・フィルタリング
3. パッケージの削除（権限がある場合）
4. パッケージ詳細画面への遷移
5. パッケージレジストリ設定画面への遷移

**画面遷移**：
- 遷移元：プロジェクトダッシュボード、パッケージメニュー
- 遷移先：パッケージ詳細画面、パッケージ設定画面、グループパッケージ一覧

**権限による表示制御**：
- `read_package` 権限でパッケージの閲覧が可能
- `destroy_package` 権限でパッケージの削除が可能
- `admin_package` 権限で設定画面へのリンクが表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | パッケージレジストリ | 主機能 | パッケージレジストリの一覧表示 |
| 63 | コンテナレジストリ | 関連機能 | レジストリ設定画面への遷移 |

## 画面種別

一覧画面

## URL/ルーティング

- URL: `/:namespace_id/:project_id/-/packages`
- ルート定義: `config/routes/project.rb`
- コントローラー: `Projects::Packages::PackagesController#index`

## 入出力項目

### 入力項目（検索・フィルタリング）

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| 検索キーワード | String | いいえ | パッケージ名での検索 |
| パッケージタイプ | String | いいえ | フィルタリング対象のパッケージ種別 |
| ソート順 | String | いいえ | 並び替え条件 |

### 出力項目（表示データ）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| パッケージ一覧 | Array | 表示対象パッケージのリスト |
| ページネーション情報 | Object | ページ番号、総ページ数など |
| 権限情報 | Boolean | 削除権限の有無 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| パッケージ名 | リンク | パッケージ詳細へのリンク |
| バージョン | テキスト | パッケージのバージョン |
| パッケージタイプ | バッジ | Maven、npm等のタイプ表示 |
| 公開日時 | 日時 | パッケージの公開日時 |
| サイズ | テキスト | パッケージファイルのサイズ |
| パイプライン | リンク | 関連するCI/CDパイプライン |
| 削除ボタン | ボタン | パッケージ削除（権限がある場合） |
| 設定リンク | リンク | パッケージ設定画面へ（権限がある場合） |

## イベント仕様

### 1-パッケージ検索

**処理フロー**：
1. 検索フォームにキーワードを入力
2. GraphQL APIでパッケージを検索
3. 検索結果を一覧に反映

### 2-パッケージ削除

**処理フロー**：
1. 削除ボタンをクリック
2. 確認ダイアログを表示
3. 確認後、GraphQL MutationでパッケージをDELETE
4. 一覧を更新

### 3-パッケージ詳細へ遷移

**処理フロー**：
1. パッケージ名リンクをクリック
2. `/packages/:id` へ遷移
3. パッケージ詳細画面を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | packages_packages | SELECT | パッケージ一覧の取得 |
| 検索 | packages_packages | SELECT | 条件に一致するパッケージの検索 |
| 削除 | packages_packages | UPDATE | ステータスをpending_destructionに変更 |

### テーブル別更新項目詳細

#### packages_packages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, version, package_type, created_at | project_id = 対象プロジェクト | 一覧表示用 |
| UPDATE | status | pending_destruction | 削除時（論理削除） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG-001 | 成功 | Package deleted successfully | パッケージ削除成功 |
| MSG-002 | エラー | Failed to delete package | パッケージ削除失敗 |
| MSG-003 | 情報 | No packages to show | パッケージが存在しない |
| MSG-004 | エラー | Access Denied | read_package権限なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | 403 Access Denied画面を表示 |
| プロジェクト未存在 | 404エラー画面を表示 |
| API通信エラー | エラーメッセージを表示、リトライを促す |

## 備考

- 本画面はVue.jsコンポーネント（`#js-vue-packages-list`）で実装されている
- パッケージ一覧データはGraphQL APIで取得される
- 削除は論理削除で、バックグラウンドジョブで物理削除が実行される
- グループに所属するプロジェクトの場合、グループパッケージ一覧へのリンクも表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、パッケージのデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | package.rb | `app/models/packages/package.rb` | パッケージの属性、enumの定義 |
| 1-2 | packages_helper.rb | `app/helpers/packages_helper.rb` | テンプレートデータの構築 |

**読解のコツ**: `package_type` enumで対応するパッケージ形式を確認。`status` enumで状態管理の仕組みを理解。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | packages_controller.rb | `app/controllers/projects/packages/packages_controller.rb` | indexアクションの処理（シンプル） |

**主要処理フロー**:
1. **11行**: `index`メソッド（空実装、ビューのみレンダリング）
2. **14-16行**: `show`メソッドもindexをレンダリング（フロントエンドルーティング対応）

#### Step 3: ヘルパーを理解する

フロントエンドに渡すデータ構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | packages_helper.rb | `app/helpers/packages_helper.rb` | project_packages_template_dataメソッド |

**主要処理フロー**:
- **109-125行**: `project_packages_template_data`でテンプレートデータを構築
- **111行**: `can_delete_packages`で削除権限を判定
- **119-123行**: 設定画面へのパスを条件付きで設定

### プログラム呼び出し階層図

```
Projects::Packages::PackagesController#index
    │
    ├─ include PackagesAccess
    │      └─ before_action: verify_packages_enabled!
    │
    └─ Render: index.html.haml
           │
           └─ project_packages_template_data(@project)
                  ├─ can_delete_packages?(project)
                  │      └─ Ability.allowed?(:destroy_package, project)
                  │
                  ├─ show_package_registry_settings(project)
                  │      └─ Ability.allowed?(:admin_package, project)
                  │
                  └─ packages_template_data (private)
                         └─ 共通データの構築
```

### データフロー図

```
[入力]               [処理]                    [出力]

リクエスト ───▶ PackagesController#index ───▶ テンプレートデータ(JSON)
                       │                              │
                       ├─ PackagesAccess検証          ├─ endpoint
                       │                              │
                       └─ ヘルパーでデータ構築        ├─ can_delete_packages
                                                      │
                                                      ├─ settings_path
                                                      │
                                                      └─ npm_instance_url
                                                      │
                                                      ▼
                                                Vue.js Component
                                                (#js-vue-packages-list)
                                                      │
                                                      └─ GraphQL API
                                                             └─ packages_packages テーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html.haml | `app/views/projects/packages/packages/index.html.haml` | テンプレート | 画面のHTMLテンプレート |
| packages_controller.rb | `app/controllers/projects/packages/packages_controller.rb` | コントローラー | 画面のメインコントローラー |
| packages_helper.rb | `app/helpers/packages_helper.rb` | ヘルパー | テンプレートデータの構築 |
| package.rb | `app/models/packages/package.rb` | モデル | パッケージのデータモデル |
| packages_access.rb | `app/controllers/concerns/packages_access.rb` | Concern | パッケージアクセス制御 |
| project.rb | `config/routes/project.rb` | ルーティング | URLルーティング定義（43行） |
