# 画面設計書 94-インフラレジストリ一覧

## 概要

本ドキュメントは、GitLabにおけるTerraformモジュールレジストリ一覧画面（インフラストラクチャレジストリ）の設計仕様を記述したものです。

### 本画面の処理概要

この画面では、プロジェクトに登録されたTerraformモジュールパッケージの一覧を表示します。Terraform Infrastructure as Code（IaC）で使用するモジュールを管理・配布するためのレジストリ機能を提供します。

**業務上の目的・背景**：
Infrastructure as Code（IaC）の普及により、Terraformを使用したインフラ管理が一般的になっています。GitLabのTerraformモジュールレジストリは、組織内で再利用可能なTerraformモジュールを管理・共有するための機能を提供します。本画面は、プロジェクト内で公開されているTerraformモジュールを一覧表示し、バージョン管理やモジュールの配布を支援します。これにより、インフラチームは標準化されたモジュールを効率的に管理・利用できます。

**画面へのアクセス方法**：
1. プロジェクト画面から左側ナビゲーションの「パッケージとレジストリ」セクションを展開
2. 「Terraformモジュール」をクリック
3. または「インフラストラクチャレジストリ」からリダイレクト

**主要な操作・処理内容**：
1. Terraformモジュール一覧の表示
2. モジュールの検索・フィルタリング
3. モジュール詳細画面への遷移

**画面遷移**：
- 遷移元：プロジェクトダッシュボード、パッケージメニュー
- 遷移先：インフラレジストリ詳細画面（モジュール詳細）

**権限による表示制御**：
- `read_package` 権限でモジュールの閲覧が可能
- パッケージレジストリ機能が有効である必要がある

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | パッケージレジストリ | 主機能 | インフラストラクチャレジストリの一覧表示 |

## 画面種別

一覧画面

## URL/ルーティング

- URL: `/:namespace_id/:project_id/-/terraform_module_registry`
- 旧URL（リダイレクト）: `/:namespace_id/:project_id/-/infrastructure_registry`
- ルート定義: `config/routes/project.rb`
- コントローラー: `Projects::Packages::InfrastructureRegistryController#index`

## 入出力項目

### 入力項目（検索・フィルタリング）

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| 検索キーワード | String | いいえ | モジュール名での検索 |

### 出力項目（表示データ）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| モジュール一覧 | Array | 表示対象Terraformモジュールのリスト |
| ページネーション情報 | Object | ページ番号、総ページ数など |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| モジュール名 | リンク | モジュール詳細へのリンク |
| バージョン | テキスト | モジュールの最新バージョン |
| 公開日時 | 日時 | モジュールの公開日時 |
| 空状態イラスト | 画像 | モジュールが存在しない場合の表示 |

## イベント仕様

### 1-モジュール一覧表示

**処理フロー**：
1. 画面アクセス時にVue.jsコンポーネントがマウント
2. GraphQL APIでTerraformモジュール一覧を取得
3. 一覧を表示

### 2-モジュール詳細へ遷移

**処理フロー**：
1. モジュール名リンクをクリック
2. `/terraform_module_registry/:id` へ遷移
3. モジュール詳細画面を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | packages_packages | SELECT | Terraformモジュール一覧の取得 |

### テーブル別更新項目詳細

#### packages_packages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, version, created_at | project_id = 対象プロジェクト AND package_type = 'terraform_module' | 一覧表示用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG-001 | 情報 | No Terraform modules to show | モジュールが存在しない |
| MSG-002 | エラー | Access Denied | read_package権限なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | 403 Access Denied画面を表示 |
| プロジェクト未存在 | 404エラー画面を表示 |
| パッケージ機能無効 | 404エラー画面を表示 |

## 備考

- 本画面はVue.jsコンポーネント（`#js-vue-packages-list`）で実装されている
- パッケージタイプが`terraform_module`のパッケージのみが対象
- 旧URL（infrastructure_registry）からは自動的にリダイレクトされる
- page_typeは`project`として設定される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Terraformモジュールパッケージのデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | package.rb | `app/models/packages/package.rb` | package_type: terraform_module の定義 |
| 1-2 | terraform_module.rb | `app/models/packages/terraform_module/package.rb` | Terraformモジュール固有の実装 |

**読解のコツ**: `inheritance_column_to_class_map`でterraform_moduleがどのクラスにマッピングされるか確認。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | infrastructure_registry_controller.rb | `app/controllers/projects/packages/infrastructure_registry_controller.rb` | indexアクションがないことを確認（暗黙的レンダリング） |

**主要処理フロー**:
- コントローラーにindexアクションの明示的な定義がないため、デフォルトでindex.html.hamlがレンダリングされる
- showアクション（11-16行）でパッケージ詳細を取得

#### Step 3: ビューテンプレートを理解する

フロントエンドに渡すデータ構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/projects/packages/infrastructure_registry/index.html.haml` | js-vue-packages-listにセットされるdata属性 |

**主要処理フロー**:
- **3-5行**: resource_id、page_type、empty_list_illustrationを設定
- フロントエンドのVue.jsコンポーネントがこのデータを使用

### プログラム呼び出し階層図

```
Projects::Packages::InfrastructureRegistryController
    │
    ├─ include PackagesAccess
    │      └─ before_action: verify_packages_enabled!
    │
    └─ Render: index.html.haml
           │
           └─ Vue.js Component (#js-vue-packages-list)
                  │
                  ├─ data.resource_id = @project.id
                  ├─ data.page_type = 'project'
                  └─ data.empty_list_illustration = image_path(...)
```

### データフロー図

```
[入力]               [処理]                    [出力]

リクエスト ───▶ InfrastructureRegistryController ───▶ テンプレートデータ
                       │                                    │
                       ├─ PackagesAccess検証                ├─ resource_id
                       │                                    │
                       └─ HAMLレンダリング                  ├─ page_type
                                                            │
                                                            └─ empty_list_illustration
                                                            │
                                                            ▼
                                                      Vue.js Component
                                                      (#js-vue-packages-list)
                                                            │
                                                            └─ GraphQL API
                                                                   │
                                                                   └─ packages_packages
                                                                      (package_type = terraform_module)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html.haml | `app/views/projects/packages/infrastructure_registry/index.html.haml` | テンプレート | 画面のHTMLテンプレート |
| infrastructure_registry_controller.rb | `app/controllers/projects/packages/infrastructure_registry_controller.rb` | コントローラー | 画面のメインコントローラー |
| package.rb | `app/models/packages/package.rb` | モデル | パッケージの基底モデル |
| packages_access.rb | `app/controllers/concerns/packages_access.rb` | Concern | パッケージアクセス制御 |
| project.rb | `config/routes/project.rb` | ルーティング | URLルーティング定義（50-51行） |
