# 画面設計書 95-インフラレジストリ詳細

## 概要

本ドキュメントは、GitLabにおけるTerraformモジュールレジストリ詳細画面（インフラストラクチャレジストリ詳細）の設計仕様を記述したものです。

### 本画面の処理概要

この画面では、特定のTerraformモジュールパッケージの詳細情報を表示します。モジュールの使用方法、バージョン情報、削除機能を提供し、Terraformでのモジュール利用を支援します。

**業務上の目的・背景**：
Infrastructure as Code（IaC）においてTerraformモジュールを利用する際、モジュールの詳細情報（バージョン、使用方法、ソースURL）を確認する必要があります。本画面は、開発者がTerraformモジュールを適切に利用するために必要な情報を一元的に提供します。これにより、モジュールの設定方法やインストール手順を迅速に把握でき、インフラ構築の効率化に貢献します。

**画面へのアクセス方法**：
1. プロジェクト画面から左側ナビゲーションの「パッケージとレジストリ」セクションを展開
2. 「Terraformモジュール」をクリック
3. モジュール一覧から対象モジュールをクリック

**主要な操作・処理内容**：
1. Terraformモジュールの詳細情報表示
2. モジュールの使用方法（Terraform設定コード）の表示
3. モジュールの削除（権限がある場合）
4. 一覧画面への戻り

**画面遷移**：
- 遷移元：インフラレジストリ一覧画面
- 遷移先：インフラレジストリ一覧画面（削除後、戻る操作時）

**権限による表示制御**：
- `read_package` 権限でモジュールの閲覧が可能
- `destroy_package` 権限でモジュールの削除が可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | パッケージレジストリ | 主機能 | インフラパッケージの詳細表示 |

## 画面種別

詳細画面

## URL/ルーティング

- URL: `/:namespace_id/:project_id/-/terraform_module_registry/:id`
- ルート定義: `config/routes/project.rb`
- コントローラー: `Projects::Packages::InfrastructureRegistryController#show`

## 入出力項目

### 入力項目

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| id | Integer | はい | モジュールパッケージのID（URLパラメータ） |

### 出力項目（表示データ）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| package | Object | Terraformモジュールパッケージ情報 |
| can_delete | Boolean | 削除権限の有無 |
| project_name | String | プロジェクト名 |
| project_path | String | プロジェクトのルートパス |
| gitlab_host | String | GitLabホスト名 |
| project_list_url | String | 一覧画面へのURL |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| モジュール名 | テキスト | Terraformモジュール名 |
| バージョン | テキスト | モジュールのバージョン |
| 公開日時 | 日時 | モジュールの公開日時 |
| 使用方法 | コードブロック | Terraformでの利用コード |
| ソースURL | テキスト | モジュールのソースURL |
| パイプライン情報 | リンク | 関連するCI/CDパイプライン |
| 削除ボタン | ボタン | モジュール削除（権限がある場合） |
| 戻るリンク | リンク | 一覧画面へ |

## イベント仕様

### 1-モジュール詳細表示

**処理フロー**：
1. URLパラメータからパッケージIDを取得
2. Packages::TerraformModule::Package から該当パッケージを検索
3. TerraformModulePackagePresenter で表示用データに変換
4. Vue.jsコンポーネントでレンダリング

### 2-モジュール削除

**処理フロー**：
1. 削除ボタンをクリック
2. 確認ダイアログを表示
3. 確認後、GraphQL Mutationでパッケージを削除
4. 一覧画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | packages_packages | SELECT | Terraformモジュールの取得 |
| 画面表示 | ci_pipelines | SELECT | 関連パイプラインの取得 |
| 削除 | packages_packages | UPDATE | ステータスをpending_destructionに変更 |

### テーブル別更新項目詳細

#### packages_packages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全項目 | id = パラメータID AND project_id = 対象プロジェクト | 詳細表示用 |
| UPDATE | status | pending_destruction | 削除時（論理削除） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG-001 | 成功 | Module deleted successfully | モジュール削除成功 |
| MSG-002 | エラー | Failed to delete module | モジュール削除失敗 |
| MSG-003 | エラー | Module not found | モジュールが存在しない |
| MSG-004 | エラー | Access Denied | read_package権限なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| モジュール未存在 | 404エラー画面を表示 |
| 権限不足 | 403 Access Denied画面を表示 |
| プロジェクト未存在 | 404エラー画面を表示 |

## 備考

- 本画面はVue.jsコンポーネント（`#js-vue-packages-detail`）で実装されている
- パッケージデータはTerraformModulePackagePresenterで整形されてJSONとして渡される
- pipelines_with_user_project_namespace_routeをpreloadして関連データを効率的に取得
- GitLabホスト名を使用してTerraformのソースURLを構築

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Terraformモジュールパッケージのプレゼンター構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | package.rb | `app/models/packages/package.rb` | パッケージの基底モデル |
| 1-2 | package_presenter.rb | `app/presenters/packages/terraform_module/package_presenter.rb` | プレゼンターの実装 |

**読解のコツ**: プレゼンターがどのようにパッケージデータをJSON形式に変換しているかを確認。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | infrastructure_registry_controller.rb | `app/controllers/projects/packages/infrastructure_registry_controller.rb` | showアクションの処理 |

**主要処理フロー**:
1. **11-16行**: `show`メソッドでパッケージを取得
2. **12-15行**: `Packages::TerraformModule::Package.preload_pipelines_with_user_project_namespace_route.for_projects(project).find(params[:id])` でパッケージを検索

#### Step 3: ビューテンプレートを理解する

フロントエンドに渡すデータ構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/packages/infrastructure_registry/show.html.haml` | js-vue-packages-detailにセットされるdata属性 |

**主要処理フロー**:
- **6-14行**: packageデータ、can_delete、各種URLを設定
- **8行**: `terraform_module_presenter(@package)` でプレゼンターを使用

### プログラム呼び出し階層図

```
Projects::Packages::InfrastructureRegistryController#show
    │
    ├─ include PackagesAccess
    │      └─ before_action: verify_packages_enabled!
    │
    ├─ Packages::TerraformModule::Package
    │      ├─ .preload_pipelines_with_user_project_namespace_route
    │      ├─ .for_projects(project)
    │      └─ .find(params[:id])
    │
    └─ Render: show.html.haml
           │
           ├─ terraform_module_presenter(@package)
           │      └─ Packages::TerraformModule::PackagePresenter#to_json
           │
           ├─ can?(current_user, :destroy_package, @project)
           │
           └─ Vue.js Component (#js-vue-packages-detail)
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ InfrastructureRegistryController#show ───▶ テンプレートデータ
(id)                    │                                          │
                        ├─ PackagesAccess検証                      ├─ package (JSON)
                        │                                          │
                        ├─ TerraformModule::Package.find           ├─ can_delete
                        │      └─ preload関連データ                │
                        │                                          ├─ project_name
                        └─ PackagePresenter#to_json                │
                                                                   ├─ project_path
                                                                   │
                                                                   └─ gitlab_host
                                                                   │
                                                                   ▼
                                                             Vue.js Component
                                                             (#js-vue-packages-detail)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| show.html.haml | `app/views/projects/packages/infrastructure_registry/show.html.haml` | テンプレート | 画面のHTMLテンプレート |
| infrastructure_registry_controller.rb | `app/controllers/projects/packages/infrastructure_registry_controller.rb` | コントローラー | 画面のメインコントローラー |
| packages_helper.rb | `app/helpers/packages_helper.rb` | ヘルパー | terraform_module_presenterメソッド |
| package.rb | `app/models/packages/package.rb` | モデル | パッケージの基底モデル |
| package_presenter.rb | `app/presenters/packages/terraform_module/package_presenter.rb` | プレゼンター | 表示用データ変換 |
| packages_access.rb | `app/controllers/concerns/packages_access.rb` | Concern | パッケージアクセス制御 |
| project.rb | `config/routes/project.rb` | ルーティング | URLルーティング定義（50行） |
