# 画面設計書 96-コンテナレジストリ

## 概要

本ドキュメントは、GitLabにおけるコンテナレジストリ（Dockerレジストリ）一覧画面の設計仕様を記述したものです。

### 本画面の処理概要

この画面では、プロジェクトに登録されたDockerコンテナイメージのリポジトリ一覧を表示・管理します。コンテナイメージの検索、リポジトリの削除、タグ管理機能への遷移を提供し、CI/CDパイプラインで構築されたDockerイメージの管理を支援します。

**業務上の目的・背景**：
コンテナ技術の普及により、アプリケーションのDockerイメージを効率的に管理する必要性が高まっています。GitLabコンテナレジストリは、GitLabの統合機能としてDockerイメージのビルド、保存、配布を一元管理する機能を提供します。本画面は、プロジェクト内で管理されているコンテナリポジトリを一覧表示し、イメージの検索、リポジトリの削除、クリーンアップポリシーの設定へのナビゲーションを可能にします。これにより、開発者はDockerイメージのライフサイクルを効率的に管理できます。

**画面へのアクセス方法**：
1. プロジェクト画面から左側ナビゲーションの「パッケージとレジストリ」セクションを展開
2. 「コンテナレジストリ」をクリック

**主要な操作・処理内容**：
1. コンテナリポジトリ一覧の表示（GraphQL API経由）
2. リポジトリの検索・フィルタリング
3. リポジトリの削除（権限がある場合）
4. リポジトリ詳細（タグ一覧）画面への遷移
5. クリーンアップポリシー設定画面への遷移

**画面遷移**：
- 遷移元：プロジェクトダッシュボード、パッケージメニュー
- 遷移先：リポジトリ詳細画面、クリーンアップポリシー設定画面、コンテナレジストリ設定画面

**権限による表示制御**：
- `read_container_image` 権限でリポジトリの閲覧が可能
- `update_container_image` 権限でリポジトリの削除が可能
- `admin_container_image` 権限で設定画面へのリンクが表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | コンテナレジストリ | 主機能 | Dockerコンテナレジストリの表示 |

## 画面種別

一覧画面

## URL/ルーティング

- URL: `/:namespace_id/:project_id/container_registry`
- ルート定義: `config/routes/project.rb`
- コントローラー: `Projects::Registry::RepositoriesController#index`

## 入出力項目

### 入力項目（検索・フィルタリング）

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| 検索キーワード | String | いいえ | リポジトリ名での検索 |
| ソート順 | String | いいえ | 並び替え条件 |

### 出力項目（表示データ）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| コンテナリポジトリ一覧 | Array | 表示対象リポジトリのリスト |
| レジストリURL | String | Docker pushで使用するURL |
| 接続エラー | Boolean | レジストリ接続エラーの有無 |
| パスエラー | Boolean | 無効なパスエラーの有無 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| リポジトリ名 | リンク | タグ一覧へのリンク |
| タグ数 | テキスト | リポジトリ内のタグ数 |
| サイズ | テキスト | リポジトリの総サイズ |
| 最終更新日時 | 日時 | 最後に更新された日時 |
| 削除ボタン | ボタン | リポジトリ削除（権限がある場合） |
| レジストリURL | テキスト | docker push/pullで使用するURL |
| クリーンアップポリシーリンク | リンク | ポリシー設定画面へ（条件付き） |
| 設定リンク | リンク | レジストリ設定画面へ（権限がある場合） |

## イベント仕様

### 1-リポジトリ一覧表示

**処理フロー**：
1. 画面アクセス時にensure_root_container_repository!を実行
2. ルートパスにコンテナリポジトリが存在しない場合、タグがあれば自動作成
3. GraphQL API（get_container_repositories）でリポジトリ一覧を取得
4. Vue.jsコンポーネントで一覧を表示

### 2-リポジトリ削除

**処理フロー**：
1. 削除ボタンをクリック
2. 確認ダイアログを表示
3. 確認後、DESTROYリクエストをAPIに送信
4. リポジトリのステータスをdelete_scheduledに更新
5. バックグラウンドジョブで実際の削除を実行
6. 一覧を更新

### 3-リポジトリ詳細へ遷移

**処理フロー**：
1. リポジトリ名リンクをクリック
2. `/container_registry/:id` へ遷移
3. タグ一覧画面を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | container_repositories | SELECT | リポジトリ一覧の取得 |
| 画面表示（初回） | container_repositories | INSERT | ルートリポジトリの自動作成 |
| 削除 | container_repositories | UPDATE | ステータスをdelete_scheduledに変更 |

### テーブル別更新項目詳細

#### container_repositories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, project_id, created_at | project_id = 対象プロジェクト | 一覧表示用 |
| INSERT | name, project_id | プロジェクトフルパス | ルートリポジトリ作成 |
| UPDATE | status | delete_scheduled | 削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG-001 | 成功 | Repository deleted successfully | リポジトリ削除成功 |
| MSG-002 | エラー | Failed to delete repository | リポジトリ削除失敗 |
| MSG-003 | 情報 | No container images to show | リポジトリが存在しない |
| MSG-004 | エラー | Connection to the container registry failed | レジストリ接続エラー |
| MSG-005 | エラー | Access Denied | read_container_image権限なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| レジストリ無効 | 404エラー画面を表示 |
| 権限不足 | 403 Access Denied画面を表示 |
| レジストリ接続エラー | エラーメッセージを表示、接続状況を示す |
| 無効なパス | エラーメッセージを表示 |
| プロジェクト未存在 | 404エラー画面を表示 |

## 備考

- 本画面はVue.jsコンポーネント（`#js-container-registry`）で実装されている
- GraphQL APIでコンテナリポジトリ一覧を取得（Startup Call対応）
- レジストリはGitlab.config.registry.enabledで有効/無効を制御
- GitLab APIクライアント（gitlab_api_client）による拡張機能サポート
- コンテナ有効期限ポリシー（container_expiration_policy）との連携あり

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、コンテナリポジトリのデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | container_repository.rb | `app/models/container_repository.rb` | リポジトリのステータス、スコープ |
| 1-2 | container_registry_helper.rb | `app/helpers/container_registry/container_registry_helper.rb` | テンプレートデータの構築 |

**読解のコツ**: `status` enumでリポジトリの状態管理（delete_scheduled、delete_failed等）を確認。`expiration_policy_cleanup_status`でクリーンアップ処理の状態を理解。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repositories_controller.rb | `app/controllers/projects/registry/repositories_controller.rb` | indexアクションの処理 |
| 2-2 | application_controller.rb | `app/controllers/projects/registry/application_controller.rb` | 共通の認証・検証ロジック |

**主要処理フロー**:
1. **11-15行**: `index`メソッドでHTML/JSON形式を分岐
2. **13行**: HTML形式の場合、`ensure_root_container_repository!`を実行
3. **44-52行**: ルートリポジトリの自動作成ロジック

#### Step 3: ヘルパーを理解する

フロントエンドに渡すデータ構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | container_registry_helper.rb | `app/helpers/container_registry/container_registry_helper.rb` | project_container_registry_template_dataメソッド |

**主要処理フロー**:
- **9-31行**: `project_container_registry_template_data`でテンプレートデータを構築
- 各種URLパス、エラー状態、設定オプションを設定

### プログラム呼び出し階層図

```
Projects::Registry::RepositoriesController#index
    │
    ├─ before_action: verify_registry_enabled! (ApplicationController)
    │      └─ Gitlab.config.registry.enabled をチェック
    │
    ├─ before_action: authorize_read_container_image! (ApplicationController)
    │      └─ can?(current_user, :read_container_image, @project)
    │
    ├─ HTML形式の場合
    │      └─ ensure_root_container_repository!
    │             ├─ ContainerRegistry::Path.new(@project.full_path)
    │             └─ ContainerRepository.build_from_path(path).save! (タグがある場合)
    │
    └─ Render: index.html.haml
           │
           └─ project_container_registry_template_data(@project, @connection_error, @invalid_path_error)
                  ├─ show_cleanup_policy_link(project)
                  ├─ show_container_registry_settings(project)
                  └─ ContainerRegistry::GitlabApiClient.supports_gitlab_api?
```

### データフロー図

```
[入力]               [処理]                    [出力]

リクエスト ───▶ RepositoriesController#index ───▶ テンプレートデータ(JSON)
                       │                              │
                       ├─ レジストリ有効確認          ├─ endpoint
                       │                              │
                       ├─ 権限チェック                ├─ repository_url
                       │                              │
                       ├─ ルートリポジトリ確認        ├─ connection_error
                       │                              │
                       └─ ヘルパーでデータ構築        └─ show_cleanup_policy_link
                                                      │
                                                      ▼
                                                Vue.js Component
                                                (#js-container-registry)
                                                      │
                                                      └─ GraphQL API
                                                         (get_container_repositories)
                                                             │
                                                             └─ container_repositories テーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html.haml | `app/views/projects/registry/repositories/index.html.haml` | テンプレート | 画面のHTMLテンプレート |
| repositories_controller.rb | `app/controllers/projects/registry/repositories_controller.rb` | コントローラー | 画面のメインコントローラー |
| application_controller.rb | `app/controllers/projects/registry/application_controller.rb` | コントローラー | 共通の認証・検証ロジック |
| container_registry_helper.rb | `app/helpers/container_registry/container_registry_helper.rb` | ヘルパー | テンプレートデータの構築 |
| container_repository.rb | `app/models/container_repository.rb` | モデル | コンテナリポジトリのデータモデル |
| project.rb | `config/routes/project.rb` | ルーティング | URLルーティング定義（576-589行） |
