# 画面設計書 97-Harbor連携

## 概要

本ドキュメントは、GitLabにおけるHarbor連携リポジトリ一覧画面の設計仕様を記述したものです。

### 本画面の処理概要

この画面では、外部のHarborレジストリと連携したコンテナイメージリポジトリの一覧を表示します。Harborは人気のあるオープンソースのコンテナレジストリであり、GitLabとの連携により既存のHarbor環境をGitLab UIから管理できます。

**業務上の目的・背景**：
エンタープライズ環境では、セキュリティやコンプライアンス要件から、独自のコンテナレジストリ（Harbor）を運用しているケースがあります。GitLabのHarbor連携機能は、既存のHarbor環境をGitLabのインターフェースから参照可能にし、開発者が複数のツールを切り替えることなくコンテナイメージを管理できるようにします。本画面は、プロジェクトに設定されたHarbor連携からリポジトリ一覧を取得・表示し、アーティファクトやタグの詳細へのナビゲーションを提供します。

**画面へのアクセス方法**：
1. プロジェクト画面から左側ナビゲーションの「パッケージとレジストリ」セクションを展開
2. 「Harbor Registry」をクリック
3. Harbor連携が設定されていることが前提条件

**主要な操作・処理内容**：
1. Harborリポジトリ一覧の表示
2. リポジトリの検索・フィルタリング
3. アーティファクト一覧画面への遷移

**画面遷移**：
- 遷移元：プロジェクトダッシュボード、パッケージメニュー
- 遷移先：Harborアーティファクト一覧画面、Harborタグ一覧画面

**権限による表示制御**：
- `read_harbor_registry` 権限でリポジトリの閲覧が可能
- Harbor連携が有効である必要がある

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | コンテナレジストリ | 主機能 | Harbor連携リポジトリの表示 |

## 画面種別

一覧画面

## URL/ルーティング

- URL: `/:namespace_id/:project_id/-/harbor/repositories`
- ルート定義: `config/routes/project.rb`
- コントローラー: `Projects::Harbor::RepositoriesController#index`

## 入出力項目

### 入力項目（検索・フィルタリング）

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| search | String | いいえ | リポジトリ名での検索 |
| sort | String | いいえ | 並び替え条件 |
| page | Integer | いいえ | ページ番号 |
| limit | Integer | いいえ | 1ページあたりの件数 |

### 出力項目（表示データ）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| リポジトリ一覧 | Array | Harborリポジトリのリスト |
| レジストリURL | String | HarborレジストリのベースURL |
| プロジェクト名 | String | Harbor側のプロジェクト名 |
| 接続エラー | Boolean | Harbor接続エラーの有無 |
| パスエラー | Boolean | 無効なパスエラーの有無 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| リポジトリ名 | リンク | アーティファクト一覧へのリンク |
| アーティファクト数 | テキスト | リポジトリ内のアーティファクト数 |
| プルカウント | テキスト | イメージのプル回数 |
| 最終更新日時 | 日時 | 最後に更新された日時 |
| レジストリURL | テキスト | HarborレジストリのURL |
| 空状態イラスト | 画像 | リポジトリが存在しない場合の表示 |
| エラーイラスト | 画像 | 接続エラー時の表示 |

## イベント仕様

### 1-リポジトリ一覧表示（HTML）

**処理フロー**：
1. 画面アクセス時にVue.jsコンポーネントがマウント
2. コンポーネントからJSON APIを呼び出し
3. Harbor APIからリポジトリ一覧を取得
4. 一覧を表示

### 2-リポジトリ一覧取得（JSON API）

**処理フロー**：
1. クエリパラメータ（search, sort, page, limit）を取得
2. Gitlab::Harbor::Queryでパラメータを検証
3. Harbor APIにリクエストを送信
4. HarborSerializers::RepositorySerializerでレスポンスを整形
5. ページネーション付きでJSONを返却

### 3-アーティファクト一覧へ遷移

**処理フロー**：
1. リポジトリ名リンクをクリック
2. `/harbor/repositories/:id/artifacts` へ遷移
3. アーティファクト一覧画面を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | integrations | SELECT | Harbor連携設定の取得 |

### テーブル別更新項目詳細

#### integrations（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | type, properties | type = 'Integrations::Harbor' AND project_id = 対象プロジェクト | Harbor連携設定取得 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG-001 | 情報 | No repositories to show | リポジトリが存在しない |
| MSG-002 | エラー | Connection to Harbor registry failed | Harbor接続エラー |
| MSG-003 | エラー | Invalid parameters | パラメータ検証エラー |
| MSG-004 | エラー | Access Denied | read_harbor_registry権限なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| Harbor連携未設定 | 404エラー画面を表示 |
| 権限不足 | 404エラー画面を表示（403ではなく404） |
| Harbor接続エラー | エラーメッセージを表示、接続状況を示す |
| 無効なパラメータ | 422エラーとエラーメッセージを返却 |

## 備考

- 本画面はVue.jsコンポーネント（`#js-harbor-registry-list-project`）で実装されている
- Harbor APIへのプロキシとして動作し、直接Harbor APIを呼び出さない
- 連携設定はIntegrations::Harborで管理される
- Gitlab::Harbor::Queryでパラメータの検証を行う
- ページネーションはAPIレスポンスのヘッダーで制御

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Harbor連携の設定構造とクエリ処理を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | harbor.rb | `app/models/integrations/harbor.rb` | Harbor連携設定のモデル |
| 1-2 | query.rb | `lib/gitlab/harbor/query.rb` | クエリパラメータの検証・処理 |

**読解のコツ**: Harbor連携の設定（hostname, project_name）がどのように保存・取得されるかを確認。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repositories_controller.rb | `app/controllers/projects/harbor/repositories_controller.rb` | シンプルなコントローラー構造 |
| 2-2 | repository.rb | `app/controllers/concerns/harbor/repository.rb` | index/showアクションの実装 |
| 2-3 | application_controller.rb | `app/controllers/projects/harbor/application_controller.rb` | 共通の認証ロジック |

**主要処理フロー**:
1. **concern/repository.rb 5-12行**: `index`メソッドでHTML/JSON形式を分岐
2. **concern/repository.rb 29-45行**: `repositories`メソッドでHarbor APIを呼び出し
3. **concern/repository.rb 26-27行**: Gitlab::Harbor::Queryでクエリ処理

#### Step 3: 認証・認可を理解する

Harbor連携のアクセス制御を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | access.rb | `app/controllers/concerns/harbor/access.rb` | before_actionの設定 |
| 3-2 | application_controller.rb | `app/controllers/projects/harbor/application_controller.rb` | authorize_read_harbor_registry!の実装 |

### プログラム呼び出し階層図

```
Projects::Harbor::RepositoriesController
    │
    ├─ include Harbor::Repository (concern)
    │      ├─ index
    │      │      ├─ HTML形式: ビューをレンダリング
    │      │      └─ JSON形式: repositories メソッド呼び出し
    │      │
    │      └─ repositories (private)
    │             ├─ Gitlab::Harbor::Query.new(container.harbor_integration, query_params)
    │             │      └─ パラメータ検証
    │             │
    │             └─ query.repositories
    │                    └─ Harbor API呼び出し
    │
    ├─ include Harbor::Access (concern)
    │      └─ before_action: authorize_read_harbor_registry!
    │
    └─ container メソッド
           └─ @project を返す
```

### データフロー図

```
[入力]               [処理]                    [出力]

リクエスト ───▶ RepositoriesController ───▶ テンプレートデータ (HTML)
                       │                            │
                       ├─ Access検証                ├─ endpoint
                       │                            │
                       └─ harbor_integration取得    ├─ repository_url
                                                    │
                                                    └─ connection_error
                                                    │
                                                    ▼
                                              Vue.js Component
                                              (#js-harbor-registry-list-project)
                                                    │
                                                    └─ JSON API呼び出し
                                                           │
                                                           ▼
                                              RepositoriesController#index (JSON)
                                                           │
                                                           ├─ Gitlab::Harbor::Query
                                                           │      └─ パラメータ検証
                                                           │
                                                           └─ Harbor API
                                                                  │
                                                                  └─ 外部Harborサーバー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html.haml | `app/views/projects/harbor/repositories/index.html.haml` | テンプレート | 画面のHTMLテンプレート |
| repositories_controller.rb | `app/controllers/projects/harbor/repositories_controller.rb` | コントローラー | 画面のメインコントローラー |
| repository.rb | `app/controllers/concerns/harbor/repository.rb` | Concern | index/showアクションの実装 |
| access.rb | `app/controllers/concerns/harbor/access.rb` | Concern | アクセス制御の共通処理 |
| application_controller.rb | `app/controllers/projects/harbor/application_controller.rb` | コントローラー | 共通の認証ロジック |
| query.rb | `lib/gitlab/harbor/query.rb` | ライブラリ | Harborクエリパラメータ処理 |
| repository_serializer.rb | `app/serializers/integrations/harbor_serializers/repository_serializer.rb` | シリアライザー | APIレスポンスの整形 |
| project.rb | `config/routes/project.rb` | ルーティング | URLルーティング定義（478-483行） |
