# 画面設計書 98-インシデント一覧

## 概要

本ドキュメントは、GitLabにおけるインシデント一覧画面の設計仕様を記述したものです。

### 本画面の処理概要

この画面では、プロジェクトに登録されたインシデント（障害情報）の一覧を表示・管理します。インシデントはGitLabのIssueシステムを拡張した機能であり、運用上の障害や問題を追跡・管理するために使用されます。

**業務上の目的・背景**：
DevOps/SREの実践において、インシデント管理は重要な役割を果たします。GitLabのインシデント管理機能は、アラートから自動的にインシデントを作成し、対応状況を追跡し、事後分析を行うための統合的なプラットフォームを提供します。本画面は、プロジェクト内で発生したインシデントを一覧表示し、優先度やステータスによるフィルタリング、担当者へのアサイン、詳細画面への遷移を可能にします。これにより、運用チームはインシデントのライフサイクルを効率的に管理できます。

**画面へのアクセス方法**：
1. プロジェクト画面から左側ナビゲーションの「モニタリング」セクションを展開
2. 「インシデント」をクリック

**主要な操作・処理内容**：
1. インシデント一覧の表示（ページネーション付き）
2. インシデントの検索・フィルタリング（作成者、担当者、テキスト検索）
3. 新規インシデントの作成
4. インシデント詳細画面への遷移

**画面遷移**：
- 遷移元：プロジェクトダッシュボード、モニタリングメニュー、アラート管理画面
- 遷移先：インシデント詳細画面、新規インシデント作成画面

**権限による表示制御**：
- `read_issue` 権限でインシデントの閲覧が可能
- インシデントタイプのIssue作成権限で新規作成が可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 45 | インシデント管理 | 主機能 | インシデントの一覧表示 |
| 36 | イシュー作成 | 遷移先機能 | 新規インシデント作成 |

## 画面種別

一覧画面

## URL/ルーティング

- URL: `/:namespace_id/:project_id/-/incidents`
- ルート定義: `config/routes/project.rb`
- コントローラー: `Projects::IncidentsController#index`

## 入出力項目

### 入力項目（検索・フィルタリング）

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| search | String | いいえ | テキスト検索キーワード |
| author_username | String | いいえ | 作成者のユーザー名でフィルタ |
| assignee_username | String | いいえ | 担当者のユーザー名でフィルタ |

### 出力項目（表示データ）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| プロジェクトパス | String | プロジェクトのフルパス |
| 新規作成URL | String | 新規インシデント作成画面のURL |
| インシデントテンプレート名 | String | 使用するテンプレート名（'incident'） |
| インシデントタイプ | String | Issueタイプ（'incident'） |
| Issue一覧URL | String | 関連するIssue一覧へのURL |
| 空状態イラスト | String | インシデントがない場合の画像パス |
| 作成権限 | Boolean | インシデント作成権限の有無 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| インシデントタイトル | リンク | 詳細画面へのリンク |
| ステータス | バッジ | オープン/クローズ状態 |
| 重大度 | バッジ | 重大度レベル（Critical, High, Medium, Low, Info） |
| 作成者 | アバター+リンク | 作成者のプロフィールへのリンク |
| 担当者 | アバター+リンク | 担当者のプロフィールへのリンク |
| 作成日時 | 日時 | インシデント作成日時 |
| 更新日時 | 日時 | 最終更新日時 |
| 新規作成ボタン | ボタン | 新規インシデント作成（権限がある場合） |

## イベント仕様

### 1-インシデント一覧表示

**処理フロー**：
1. 画面アクセス時にVue.jsコンポーネントがマウント
2. incidents_dataヘルパーでテンプレートデータを構築
3. GraphQL APIでインシデント一覧を取得
4. 一覧を表示

### 2-インシデント検索

**処理フロー**：
1. 検索フォームにキーワードを入力
2. GraphQL APIでインシデントを検索
3. 検索結果を一覧に反映

### 3-新規インシデント作成

**処理フロー**：
1. 「新規インシデント」ボタンをクリック
2. 新規Issue作成画面へ遷移（issue_type=incident）
3. インシデントテンプレートが自動適用される

### 4-インシデント詳細へ遷移

**処理フロー**：
1. インシデントタイトルをクリック
2. `/incidents/:id` へ遷移
3. インシデント詳細画面を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | issues | SELECT | インシデント一覧の取得 |

### テーブル別更新項目詳細

#### issues

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, title, state, created_at, author_id, etc. | project_id = 対象プロジェクト AND issue_type = 'incident' | 一覧表示用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG-001 | 情報 | No incidents to show | インシデントが存在しない |
| MSG-002 | エラー | Access Denied | read_issue権限なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| インシデント機能フラグ無効 | 404エラー画面を表示 |
| 権限不足 | 403 Access Denied画面を表示 |
| プロジェクト未存在 | 404エラー画面を表示 |

## 備考

- 本画面はVue.jsコンポーネント（`#js-incidents`）で実装されている
- インシデントはissue_type='incident'のIssueとして管理される
- IssuesFinder経由でインシデントタイプのIssueのみを取得
- IncidentManagementFeatureFlagでフィーチャーフラグ制御
- notifications_todos_buttonsフィーチャーフラグも考慮

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、インシデントがIssueの拡張であることを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | issue.rb | `app/models/issue.rb` | issue_typeの定義、incidentとの関係 |
| 1-2 | incidents_helper.rb | `app/helpers/projects/incidents_helper.rb` | テンプレートデータの構築 |

**読解のコツ**: インシデントは独自のモデルを持たず、Issue.issue_type='incident'で識別されることを理解。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | incidents_controller.rb | `app/controllers/projects/incidents_controller.rb` | indexアクションの処理 |

**主要処理フロー**:
1. **8行**: `authorize_read_issue!` - 権限チェック
2. **10-12行**: `before_action` - フィーチャーフラグチェック、Todosボタンフラグ
3. **18行**: `index`メソッド（空実装、ビューのみレンダリング）

#### Step 3: ヘルパーを理解する

フロントエンドに渡すデータ構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | incidents_helper.rb | `app/helpers/projects/incidents_helper.rb` | incidents_dataメソッド |

**主要処理フロー**:
- **4-17行**: `incidents_data`でテンプレートデータを構築
- **6-7行**: 新規Issue作成パスとテンプレート名を設定
- **15行**: `create_issue_type_allowed?`で作成権限を判定

#### Step 4: ファインダーを理解する

インシデントの取得ロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | incidents_controller.rb | `app/controllers/projects/incidents_controller.rb` | incident_finderメソッド |

**主要処理フロー**:
- **43-45行**: `IssuesFinder.new(current_user, project_id: @project.id, issue_types: :incident)` でインシデントのみを取得

### プログラム呼び出し階層図

```
Projects::IncidentsController#index
    │
    ├─ include IssuableActions
    │
    ├─ include IncidentManagementFeatureFlag
    │      └─ check_incidents_feature_flag
    │
    ├─ before_action: authorize_read_issue!
    │      └─ can?(current_user, :read_issue, @project)
    │
    ├─ before_action: push_frontend_feature_flag
    │      └─ :notifications_todos_buttons
    │
    └─ Render: index.html.haml
           │
           └─ incidents_data(@project, params)
                  ├─ new_project_issue_path
                  ├─ project_issues_path
                  ├─ create_issue_type_allowed?
                  └─ 検索パラメータの受け渡し
```

### データフロー図

```
[入力]               [処理]                    [出力]

リクエスト ───▶ IncidentsController#index ───▶ テンプレートデータ(JSON)
(params)                │                              │
                        ├─ 権限チェック                ├─ project-path
                        │                              │
                        ├─ フラグチェック              ├─ new-issue-path
                        │                              │
                        └─ ヘルパーでデータ構築        ├─ can-create-incident
                                                       │
                                                       └─ text-query, author-username-query...
                                                       │
                                                       ▼
                                                 Vue.js Component
                                                 (#js-incidents)
                                                       │
                                                       └─ GraphQL API
                                                              │
                                                              └─ issues テーブル
                                                                 (issue_type = 'incident')
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html.haml | `app/views/projects/incidents/index.html.haml` | テンプレート | 画面のHTMLテンプレート |
| incidents_controller.rb | `app/controllers/projects/incidents_controller.rb` | コントローラー | 画面のメインコントローラー |
| incidents_helper.rb | `app/helpers/projects/incidents_helper.rb` | ヘルパー | テンプレートデータの構築 |
| issue.rb | `app/models/issue.rb` | モデル | Issue（インシデント含む）のデータモデル |
| issues_finder.rb | `app/finders/issues_finder.rb` | ファインダー | インシデント検索 |
| project.rb | `config/routes/project.rb` | ルーティング | URLルーティング定義（379行） |
