# 画面設計書 99-インシデント詳細

## 概要

本ドキュメントは、GitLabにおけるインシデント詳細画面の設計仕様を記述したものです。

### 本画面の処理概要

この画面では、特定のインシデント（障害情報）の詳細情報を表示・編集します。インシデントの説明、タイムライン、コメント、関連するアラートやIssueなど、インシデント対応に必要な情報を一元的に管理します。

**業務上の目的・背景**：
インシデント対応において、詳細な情報の記録と共有は非常に重要です。本画面は、インシデントの発生から解決までのライフサイクルを管理するための中心的なインターフェースを提供します。対応状況のトラッキング、タイムラインの記録、関係者とのコミュニケーション、事後分析のための情報収集など、インシデント管理に必要な機能を統合しています。これにより、運用チームは迅速かつ効果的なインシデント対応を実現できます。

**画面へのアクセス方法**：
1. インシデント一覧画面からインシデントタイトルをクリック
2. または直接URL（`/-/incidents/:id`）にアクセス
3. アラート管理画面から関連インシデントへ遷移

**主要な操作・処理内容**：
1. インシデント詳細情報の表示
2. インシデントのステータス変更（オープン/クローズ/解決）
3. コメントの追加
4. タイムラインイベントの記録
5. 担当者のアサイン
6. 関連Issueのリンク
7. エスカレーションステータスの管理

**画面遷移**：
- 遷移元：インシデント一覧画面、アラート管理画面、通知
- 遷移先：インシデント一覧画面、関連Issue詳細画面、関連アラート詳細画面

**権限による表示制御**：
- `read_issue` 権限でインシデントの閲覧が可能
- `update_issue` 権限でインシデントの編集が可能
- `admin_issue` 権限で管理操作が可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 45 | インシデント管理 | 主機能 | インシデントの詳細表示 |
| 37 | イシュー編集 | 補助機能 | インシデントの編集処理 |
| 38 | イシュークローズ/再オープン | 補助機能 | ステータス変更 |
| 131 | アラート管理 | 関連機能 | アラートからのインシデント作成 |

## 画面種別

詳細画面

## URL/ルーティング

- URL: `/:namespace_id/:project_id/-/incidents/:id`
- ルート定義: `config/routes/project.rb`
- コントローラー: `Projects::IncidentsController#show`

## 入出力項目

### 入力項目

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| id | Integer | はい | インシデントのIID（URLパラメータ） |

### 出力項目（表示データ）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| issue | Object | インシデント（Issue）オブジェクト |
| noteable | Object | コメント対象のオブジェクト |
| note | Object | 新規ノート用オブジェクト |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| タイトル | テキスト（編集可） | インシデントのタイトル |
| 説明 | Markdown | インシデントの詳細説明 |
| ステータス | バッジ（ドロップダウン） | オープン/クローズ/解決状態 |
| 重大度 | ドロップダウン | Critical/High/Medium/Low/Info |
| 担当者 | アバター（選択可） | 担当者の一覧 |
| ラベル | バッジ | 関連ラベル |
| マイルストーン | リンク | 関連マイルストーン |
| 作成日時 | 日時 | インシデント作成日時 |
| 更新日時 | 日時 | 最終更新日時 |
| タイムライン | リスト | インシデント対応のタイムラインイベント |
| コメント | リスト | ディスカッションコメント |
| 関連Issue | リンクリスト | 関連付けられたIssue |
| アラート | リスト | 関連するアラート情報 |

## イベント仕様

### 1-インシデント詳細表示

**処理フロー**：
1. URLパラメータからインシデントIIDを取得
2. IssuesFinder経由でincidentタイプのIssueを検索
3. inc_relations_for_viewで関連データをプリロード
4. details_content部分テンプレートをレンダリング

### 2-ステータス変更

**処理フロー**：
1. ステータス変更ドロップダウンで新しいステータスを選択
2. GraphQL MutationまたはIssuable APIでステータスを更新
3. 画面を更新

### 3-コメント追加

**処理フロー**：
1. コメントフォームにテキストを入力
2. Notes APIでコメントを作成
3. コメント一覧を更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | issues | SELECT | インシデント詳細の取得 |
| 画面表示 | notes | SELECT | コメント一覧の取得 |
| ステータス変更 | issues | UPDATE | stateの更新 |
| コメント追加 | notes | INSERT | 新規コメントの作成 |

### テーブル別更新項目詳細

#### issues

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全項目 | project_id = 対象プロジェクト AND iid = パラメータIID AND issue_type = 'incident' | 詳細表示用 |
| UPDATE | state_id | 1(opened), 2(closed) | ステータス変更 |
| UPDATE | closed_at | 現在日時 / NULL | クローズ/再オープン時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG-001 | 成功 | Status changed | ステータス変更成功 |
| MSG-002 | 成功 | Comment added | コメント追加成功 |
| MSG-003 | エラー | Incident not found | インシデントが存在しない |
| MSG-004 | エラー | Access Denied | read_issue権限なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| インシデント未存在 | 404エラー画面を表示 |
| 権限不足 | 404エラー画面を表示（403ではなく404） |
| プロジェクト未存在 | 404エラー画面を表示 |
| リロケーション先がある場合 | canonical URLを設定 |

## 備考

- インシデント詳細はIssue詳細画面（details_content）を再利用している
- インシデント固有のスタイル（incidents.scss）が追加で適用される
- デザイン管理機能のスタイルも読み込まれる
- issuable_stylesheetが適用される
- relocation_targetがある場合、canonical URLが設定される
- noteableとしてインシデントを設定し、コメント機能を提供

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、インシデント（Issue）のデータ構造と関連データを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | issue.rb | `app/models/issue.rb` | Issueモデル、issue_typeとinc_relations_for_viewスコープ |

**読解のコツ**: インシデントはIssue.issue_type='incident'であり、専用の詳細画面があるが、基本的なデータ構造はIssueと同じ。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | incidents_controller.rb | `app/controllers/projects/incidents_controller.rb` | showアクションへの流れ |

**主要処理フロー**:
1. **9行**: `load_incident`がbefore_actionで実行
2. **22-30行**: `incident`メソッドでIssuesFinderを使用してインシデントを取得
3. **33-39行**: `load_incident`で@issueと@noteableを設定
4. **17行**: ビューテンプレートはshow.html.hamlをレンダリング

#### Step 3: ビューテンプレートを理解する

表示の仕組みを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/incidents/show.html.haml` | breadcrumb、スタイル読み込み、details_content部分テンプレートの呼び出し |

**主要処理フロー**:
- **1-2行**: breadcrumbの設定
- **4-8行**: ページメタデータの設定
- **10-13行**: スタイルシートの読み込み
- **17行**: `projects/issues/details_content`部分テンプレートをレンダリング

### プログラム呼び出し階層図

```
Projects::IncidentsController#show (暗黙)
    │
    ├─ include IssuableActions
    │      └─ showアクションを提供
    │
    ├─ before_action: authorize_read_issue!
    │      └─ can?(current_user, :read_issue, @project)
    │
    ├─ before_action: load_incident
    │      ├─ incident
    │      │      ├─ incident_finder.execute
    │      │      ├─ .inc_relations_for_view
    │      │      ├─ .iid_in(params[:id])
    │      │      └─ .take
    │      │
    │      └─ 設定: @issue, @noteable, @note
    │
    └─ Render: show.html.haml
           │
           ├─ breadcrumb設定
           ├─ page_title設定
           ├─ スタイルシート読み込み
           │      ├─ design_management
           │      ├─ incidents
           │      └─ issues_show
           │
           └─ render 'projects/issues/details_content'
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ IncidentsController ───▶ @issue (Issue)
(iid)                   │                        │
                        ├─ 権限チェック          ├─ @noteable
                        │                        │
                        ├─ incident_finder       └─ @note
                        │      └─ IssuesFinder
                        │             └─ issue_types: :incident
                        │
                        └─ load_incident
                               │
                               └─ inc_relations_for_view
                                      └─ 関連データのプリロード
                                               │
                                               ▼
                                         show.html.haml
                                               │
                                               └─ details_content
                                                      │
                                                      └─ Issue表示用コンポーネント
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| show.html.haml | `app/views/projects/incidents/show.html.haml` | テンプレート | インシデント詳細のメインテンプレート |
| incidents_controller.rb | `app/controllers/projects/incidents_controller.rb` | コントローラー | 画面のメインコントローラー |
| details_content.html.haml | `app/views/projects/issues/_details_content.html.haml` | 部分テンプレート | Issue詳細表示の共通テンプレート |
| issue.rb | `app/models/issue.rb` | モデル | Issueのデータモデル |
| issues_finder.rb | `app/finders/issues_finder.rb` | ファインダー | Issue検索 |
| issuable_actions.rb | `app/controllers/concerns/issuable_actions.rb` | Concern | showアクションの提供 |
| project.rb | `config/routes/project.rb` | ルーティング | URLルーティング定義（379行） |
