---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：1-ログイン画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **最大ログイン失敗回数の設定値**：コード上のデフォルト値と実際のDevise設定の確認が必要
  2. **reCAPTCHA表示の失敗回数閾値**：コード確認済みだが設定による変更可能性あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/devise/sessions/new.html.haml` - ログイン画面ビューテンプレート
- E-02: `app/controllers/sessions_controller.rb` - セッションコントローラー（1-391行目）
- E-03: `app/views/devise/sessions/_new_base.html.haml` - 標準ログインフォーム（1-47行目）
- E-04: `app/views/devise/shared/_tabs_ldap.html.haml` - LDAP/標準認証タブ（1-29行目）
- E-05: `app/views/devise/shared/_omniauth_box.html.haml` - OAuthボタン群（1-25行目）
- E-06: `app/models/user.rb` - ユーザーモデル（1-150行目確認）
- E-07: `config/routes/user.rb` - ルーティング設定（1-130行目）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-10: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/users/sign_in` でログイン画面にアクセス | E-07 (42行目 devise_for) | ○ |
| C-02 | ユーザー名またはメールアドレスでログイン可能 | E-03 (21-22行目) | ○ |
| C-03 | LDAPタブが設定時に表示される | E-04 (4-8行目), E-01 (14行目) | ○ |
| C-04 | OAuthボタンが設定時に表示される | E-01 (38-39行目), E-05 | ○ |
| C-05 | Passkeyボタンがフィーチャーフラグで制御される | E-03 (43-46行目) | ○ |
| C-06 | Remember meオプションが利用可能 | E-03 (36-38行目) | ○ |
| C-07 | 2FA有効ユーザーは追加認証が必要 | E-02 (26-27行目) | ○ |
| C-08 | reCAPTCHAがログイン失敗時に表示される | E-02 (149-155行目), E-03 (33-34行目) | ○ |
| C-09 | 5回の失敗でreCAPTCHAが表示される | E-02 (64行目 MAX_FAILED_LOGIN_ATTEMPTS = 5) | ○ |
| C-10 | ログイン成功時にreset_password_tokenがクリアされる | E-02 (85行目) | ○ |
| C-11 | 非アクティブアカウントが再有効化される | E-02 (87-89行目) | ○ |
| C-12 | ログイン成功時に監査ログが記録される | E-02 (99行目, 328-348行目) | ○ |
| C-13 | sign_in_countがインクリメントされる | E-06 (119行目 devise :trackable) | ○ |
| C-14 | 利用規約リンクが設定時に表示される | E-01 (24-27行目) | ○ |
| C-15 | 新規登録リンクがサインアップ許可時に表示される | E-01 (29-36行目) | ○ |
| C-16 | パスワードリセットリンクが表示される | E-03 (30行目) | ○ |
| C-17 | パスワード認証無効時は標準フォームが非表示 | E-01 (16-17行目), E-02 (234-235行目) | ○ |
| C-18 | 認証方式未設定時はメッセージが表示される | E-01 (20-22行目) | ○ |
| C-19 | ブロードキャストメッセージが表示される | E-01 (7-8行目) | ○ |
| C-20 | 初期セットアップ時にリダイレクトされる | E-02 (228-231行目) | ○ |
| C-21 | ログイン失敗時にfailed_attemptsがカウントされる | E-02 (208-211行目) | ○ |
| C-22 | OAuthエラー時にリダイレクト処理される | E-07 (71-78行目) | ○ |
| C-23 | 関連機能No.76,88,89,90が正しくマッピングされている | E-08 (2-5行目) | ○ |
| C-24 | 画面遷移（2FA画面への遷移）が正しい | E-10 (50-55行目) | ○ |
| C-25 | POST /users/sign_in でログイン処理が実行される | E-07 (42行目), E-02 (82行目) | ○ |
| C-26 | セッションCookieが作成される | E-02 (Devise::SessionsController継承) | ○ |
| C-27 | 10回の失敗でアカウントがロックされる | **根拠なし**（Devise設定ファイル未確認） | △ |
| C-28 | ログアウト時にCookieがクリアされる | E-02 (104-119行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-27**: アカウントロックの失敗回数閾値（10回）はDevise設定ファイル（`config/initializers/devise.rb`）で定義されているが、本レビュー時に未確認
  - 候補：`config/initializers/devise.rb` / Devise gem デフォルト設定 / 環境変数

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分の主張がソースコードで裏付けられている
- **1（中リスク）**: 設定値（ロック閾値等）は環境により異なる可能性があるため、デプロイ環境での確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Devise設定ファイル（`config/initializers/devise.rb`）でロック閾値を確認
- [ ] 本番環境でのOAuthプロバイダ設定状況を確認
- [ ] reCAPTCHA設定の有効化状況を確認
- [ ] Passkeyフィーチャーフラグの有効化状況を確認
