---
generated_at: 2026-01-22 12:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：10-デバイス認可画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **デバイスコードの有効期限設定**：設定ファイルでの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/doorkeeper/device_authorization_grant/index.html.haml` - ユーザーコード入力画面（16行）
- E-02: `app/views/doorkeeper/device_authorization_grant/authorize.html.haml` - 認可確認画面（33行）
- E-03: `app/controllers/oauth/device_authorizations_controller.rb` - コントローラー（29行）
- E-04: `app/models/doorkeeper/device_authorization_grant/device_grant.rb` - デバイスグラントモデル（14行）
- E-05: `config/routes/device_auth.rb` - ルーティング設定（7行）
- E-06: `config/initializers/doorkeeper_device_authorization_grant.rb` - デバイス認可設定（34行）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GET `/oauth/device` でユーザーコード入力画面を表示 | E-03 (7-14行目 index) | ○ |
| C-02 | POST `/oauth/device/confirm` でユーザーコード検証 | E-05 (5行目), E-03 (16-27行目) | ○ |
| C-03 | ユーザーコード入力フィールドが存在する | E-01 (9-10行目) | ○ |
| C-04 | Authorizeボタンでconfirmへ遷移 | E-01 (12-15行目) | ○ |
| C-05 | 認可確認画面でユーザー情報が表示される | E-02 (7-13行目) | ○ |
| C-06 | 管理者には警告メッセージが表示される | E-02 (14-17行目 current_user.admin?) | ○ |
| C-07 | スコープが表示される | E-02 (19-22行目), E-03 (20行目 @scopes) | ○ |
| C-08 | Confirmボタンで最終認可処理が行われる | E-02 (24-32行目) | ○ |
| C-09 | minimalレイアウトを使用 | E-03 (5行目 layout 'minimal') | ○ |
| C-10 | DeviceGrantモデルがOrganizationと関連付けられている | E-04 (11行目 belongs_to :organization) | ○ |
| C-11 | user_codeでDeviceGrantを検索 | E-03 (18行目 find_by(user_code:)) | ○ |
| C-12 | 関連機能No.88「OAuth2プロバイダ」が正しい | E-07 | ○ |
| C-13 | ユーザーコードが隠しフィールドで引き継がれる | E-02 (27行目 hidden_field :user_code) | ○ |
| C-14 | タイトルメッセージが正しく表示される | E-01 (4行目), E-02 (4行目) | ○ |
| C-15 | 確認メッセージが表示される | E-02 (5-6行目) | ○ |
| C-16 | デバイスコードの有効期限は300秒（5分） | **根拠不足**（設定ファイルでコメントアウト） | △ |

## 4) 不足情報（Unknown / Missing）
- **C-16**: デバイスコードの有効期限（300秒）はDoorkeeper Device Authorization Grantのデフォルト値だが、`config/initializers/doorkeeper_device_authorization_grant.rb` では `device_code_expires_in 300` がコメントアウトされており、実際の設定値は確認が必要
  - 候補：Doorkeeper gemのデフォルト設定

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: RFC 8628に準拠した標準的なデバイス認可フロー
- **1（中リスク）**: Organization関連付けの必須化による既存アプリケーションへの影響

## 6) レビュアーチェックリスト（最小）
- [ ] デバイスコードの有効期限設定を確認
- [ ] ポーリング間隔の設定を確認
- [ ] ユーザーコードのフォーマット・生成方法を確認
- [ ] Organization必須化の影響範囲を確認
- [ ] 管理者警告表示の適切性を確認
