---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：100-アラート管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL APIの詳細実装**：フロントエンド側のAPI呼び出し未検証
  2. **Vue.jsコンポーネントの実装詳細**：根拠不足
  3. **Escalatableモジュールの詳細**：concernファイル未読込

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/alert_management/index.html.haml`（1-4行）
- E-02: `app/views/projects/alert_management/details.html.haml`（1-5行）
- E-03: `app/controllers/projects/alert_management_controller.rb`（1-17行）
- E-04: `app/helpers/projects/alert_management_helper.rb`（1-44行）
- E-05: `app/models/alert_management/alert.rb`（1-100行）
- E-06: `config/routes/project.rb`（353-359行）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（141行）
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv`（101行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: `/:namespace_id/:project_id/-/alert_management` | E-06 (353行) | ○ |
| C-02 | コントローラー: `Projects::AlertManagementController#index` | E-03 | ○ |
| C-03 | IncidentManagementFeatureFlagをinclude | E-03 (4行) | ○ |
| C-04 | authorize_read_alert_management_alert!で権限チェック | E-03 (6行) | ○ |
| C-05 | check_incidents_feature_flagでフラグチェック | E-03 (7行) | ○ |
| C-06 | indexアクションは空実装（ビューのみ） | E-03 (12行) | ○ |
| C-07 | detailsで@alert_idを設定 | E-03 (14-16行) | ○ |
| C-08 | Vue.jsコンポーネント(#js-alert_management)で実装 | E-01 (4行) | ○ |
| C-09 | alert_management_dataでテンプレートデータを構築 | E-01 (4行), E-04 | ○ |
| C-10 | page_title設定 | E-01 (1行) | ○ |
| C-11 | paginated_tableスタイルを読み込み | E-01 (2行) | ○ |
| C-12 | project-pathを設定 | E-04 (6行) | ○ |
| C-13 | enable-alert-management-pathを設定 | E-04 (7-10行) | ○ |
| C-14 | alerts-help-urlを設定 | E-04 (11行) | ○ |
| C-15 | user-can-enable-alert-managementでadmin_operations権限を判定 | E-04 (17行) | ○ |
| C-16 | alert-management-enabledでアラート管理有効状態を判定 | E-04 (18行) | ○ |
| C-17 | alert_management_enabled?でアラートまたはHTTP統合の存在を確認 | E-04 (38-43行) | ○ |
| C-18 | 関連機能No.131 アラート管理 | E-07 | ○ |
| C-19 | severity enumで6段階の重大度を定義 | E-05 (63-70行) | ○ |
| C-20 | Escalatableをincludeしてステータス管理 | E-05 (18行) | ○ |
| C-21 | GraphQL APIの詳細実装 | **根拠なし** | △ |
| C-22 | Vue.jsコンポーネントの詳細な実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GraphQL APIのスキーマ定義を読み込んでいないため、APIの詳細については根拠が不足
  - 候補：`app/graphql/types/alert_management/alert_type.rb`, `app/graphql/resolvers/alert_management/alerts_resolver.rb`
- Vue.jsフロントエンドコンポーネントのソースコードを読み込んでいないため、UIの詳細な挙動については根拠が不足
  - 候補：`app/assets/javascripts/alert_management/` 配下のファイル
- IncidentManagement::Escalatable concernの詳細
  - 候補：`app/models/concerns/incident_management/escalatable.rb`
- IncidentManagementFeatureFlag concernの詳細
  - 候補：`app/controllers/concerns/incident_management_feature_flag.rb`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - URL/ルーティング定義
- **0: 低リスク** - コントローラーの基本構造
- **0: 低リスク** - ヘルパーでのテンプレートデータ構築
- **0: 低リスク** - モデルの重大度・ステータス定義
- **1: 中リスク** - フロントエンドの詳細実装（未検証）
- **1: 中リスク** - GraphQL APIの詳細（未検証）
- **1: 中リスク** - Escalatableモジュールの詳細（未検証）

## 6) レビュアーチェックリスト（最小）
- [ ] IncidentManagementFeatureFlag concernの実装を確認
- [ ] read_alert_management_alert権限のポリシー定義が存在するか確認
- [ ] admin_operations権限のポリシー定義が存在するか確認
- [ ] Vue.jsコンポーネントがGraphQL APIを正しく呼び出しているか確認
- [ ] AlertManagement::HttpIntegrationsFinder の動作を確認
- [ ] Escalatableモジュールのステータス管理を確認
- [ ] アラート詳細画面（details.html.haml）のVue.jsコンポーネント実装を確認
