---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：101-エラートラッキング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **ポーリング間隔の制御**：フロントエンドコードの確認が必要
  2. **ユーザー影響数の表示項目**：Sentry APIレスポンス仕様の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/error_tracking_controller.rb`（行1-115）
- E-02: `app/views/projects/error_tracking/index.html.haml`（行1-4）
- E-03: `app/helpers/projects/error_tracking_helper.rb`（行1-52）
- E-04: `app/models/error_tracking/project_error_tracking_setting.rb`（行1-303）
- E-05: `config/routes/project.rb`（行389-405）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行142）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが`/:namespace_id/:project_id/-/error_tracking`である | E-05 | ○ |
| C-02 | `read_sentry_issue`権限が必要 | E-01（行6） | ○ |
| C-03 | `update_sentry_issue`権限がステータス更新に必要 | E-01（行7） | ○ |
| C-04 | HTML/JSON両形式に対応 | E-01（行16-22） | ○ |
| C-05 | ListIssuesServiceでエラー一覧取得 | E-01（行49-54） | ○ |
| C-06 | IssueUpdateServiceでステータス更新 | E-01（行36-37） | ○ |
| C-07 | search_term, sort, cursor, issue_statusパラメータ | E-01（行82-83） | ○ |
| C-08 | Vueコンポーネントをマウント | E-02（行4） | ○ |
| C-09 | error_tracking_dataでデータ属性生成 | E-03（行4-17） | ○ |
| C-10 | integrated_error_trackingフィーチャーフラグ | E-01（行12）, E-03（行37-43） | ○ |
| C-11 | admin_operations権限で設定リンク表示 | E-03（行9） | ○ |
| C-12 | Sentry連携と統合モードの切り替え | E-04（行58-68） | ○ |
| C-13 | 関連機能No.132 エラートラッキング | E-06 | ○ |
| C-14 | 画面種別が一覧である | E-01, E-02 | ○ |
| C-15 | hide_error_tracking_featuresフラグで404 | E-01（行110-114） | ○ |
| C-16 | ポーリングによるリアルタイム更新 | E-01（行19） set_polling_interval | ○ |
| C-17 | ポーリング間隔がレスポンスヘッダーで制御 | **根拠なし** | △ |
| C-18 | ユーザー影響数の表示 | **根拠なし**（Sentry API仕様依存） | △ |

## 4) 不足情報（Unknown / Missing）
- ポーリング間隔の具体的な制御ロジック
  - 候補：フロントエンドJavaScriptコード / Vueコンポーネント / polling_interval_header.rb
- ユーザー影響数（userCount）の表示有無
  - 候補：Sentry API仕様書 / ErrorSerializerの実装詳細

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面構造・ルーティング・権限制御は確認済み
- 1: 中リスク - フロントエンド（Vue）側の詳細実装は未確認
- 1: 中リスク - Sentry API連携の詳細仕様は外部依存

## 6) レビュアーチェックリスト（最小）
- [ ] エラートラッキング設定画面からの動線が正しく記載されているか
- [ ] フィーチャーフラグの説明が現在の実装と一致しているか
- [ ] 表示項目（エラータイトル、カウント等）がフロントエンドの実装と一致しているか
- [ ] 権限チェックの記載が`before_action`と一致しているか
