---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 17
  claims_with_evidence: 15
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：102-サイクルアナリティクス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：15 / 17、根拠なし：2
- 優先レビュー（高）
  1. **各ステージの具体的な定義**：ステージ定義の詳細確認が必要
  2. **ライセンス機能の詳細**：EE機能との差異確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/cycle_analytics_controller.rb`（行1-86）
- E-02: `app/views/projects/cycle_analytics/show.html.haml`（行1-5）
- E-03: `config/routes/project.rb`（行273-289）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行143）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが`value_stream_analytics`である | E-03（行273） | ○ |
| C-02 | `/cycle_analytics`からリダイレクトされる | E-03（行285） | ○ |
| C-03 | `read_cycle_analytics`権限が必要 | E-01（行12） | ○ |
| C-04 | HTML/JSON両形式に対応 | E-01（行40-48） | ○ |
| C-05 | ProjectLevelでサマリー取得 | E-01（行34-37） | ○ |
| C-06 | RequestParamsでパラメータ処理 | E-01（行38） | ○ |
| C-07 | view_cycle_analyticsイベント追跡 | E-01（行42） | ○ |
| C-08 | Vueコンポーネントをマウント | E-02（行5） | ○ |
| C-09 | cycle_analytics_for_projectsライセンス機能 | E-01（行28-29） | ○ |
| C-10 | group_level_analytics_dashboardライセンス機能 | E-01（行24-26） | ○ |
| C-11 | p_analytics_valuestreamでトラッキング | E-01（行14-18） | ○ |
| C-12 | GracefulTimeoutHandlingを含む | E-01（行7） | ○ |
| C-13 | 関連機能No.128 バリューストリームアナリティクス | E-04 | ○ |
| C-14 | Value Streamのデフォルト値自動生成 | E-01（行60-62） | ○ |
| C-15 | feature_category :value_stream_management | E-01（行20） | ○ |
| C-16 | 7つのステージ（Issue, Plan, Code, Test, Review, Staging, Production） | **根拠なし** | △ |
| C-17 | 各ステージの詳細イベント一覧表示機能 | **根拠なし**（別コントローラ） | △ |

## 4) 不足情報（Unknown / Missing）
- 各ステージの具体的な定義と計算ロジック
  - 候補：`lib/gitlab/analytics/cycle_analytics/stage.rb` / ステージ定義ファイル
- ライセンス機能による機能差異の詳細
  - 候補：EE拡張ファイル / ライセンス定義ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面構造・ルーティング・権限制御は確認済み
- 1: 中リスク - ステージ定義の詳細はProjectLevel実装に依存
- 1: 中リスク - EE機能との差異は`prepend_mod`で拡張される可能性

## 6) レビュアーチェックリスト（最小）
- [ ] 各ステージの名称と順序が実際の画面表示と一致しているか
- [ ] ライセンス機能の説明が正確か（CE/EE差異）
- [ ] トラッキングイベントの記載が実装と一致しているか
- [ ] リダイレクト動作が正しく記載されているか
