---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：103-実験一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **候補数の表示**：フロントエンドでの表示実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/ml/experiments_controller.rb`（行1-66）
- E-02: `app/views/projects/ml/experiments/index.html.haml`（行1-8）
- E-03: `app/models/ml/experiment.rb`（行1-81）
- E-04: `app/helpers/projects/ml/mlflow_helper.rb`（行1-15）
- E-05: `config/routes/project.rb`（行486-492）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行144）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが`/ml/experiments`である | E-05（行487） | ○ |
| C-02 | `read_model_experiments`権限が必要 | E-01（行51-53） | ○ |
| C-03 | `write_model_experiments`権限が削除に必要 | E-01（行55-57） | ○ |
| C-04 | indexアクションが空メソッド | E-01（行16） | ○ |
| C-05 | destroyでExperiment removed メッセージ | E-01（行45-46） | ○ |
| C-06 | Vueコンポーネントをマウント | E-02（行4） | ○ |
| C-07 | mlflow_tracking_urlを渡す | E-02（行7） | ○ |
| C-08 | MLflow互換APIのURL生成 | E-04（行6-11） | ○ |
| C-09 | モデル関連実験の削除防止 | E-03（行44-51） | ○ |
| C-10 | has_many :candidates | E-03（行17） | ○ |
| C-11 | feature_category :mlops | E-01（行12） | ○ |
| C-12 | 関連機能No.135 MLモデルレジストリ | E-06 | ○ |
| C-13 | by_project_id_and_iidで実験取得 | E-01（行60）, E-03（行54-56） | ○ |
| C-14 | model_idがnilでない場合は削除不可 | E-03（行44-50） | ○ |
| C-15 | 候補数（candidate_count）の表示 | **根拠なし**（Vue側実装） | △ |

## 4) 不足情報（Unknown / Missing）
- フロントエンドでの候補数表示実装
  - 候補：Vueコンポーネント / GraphQL API

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面構造・ルーティング・権限制御は確認済み
- 0: 低リスク - モデルとの関連による削除制約は明確に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 実験一覧の表示項目がフロントエンドの実装と一致しているか
- [ ] MLflow Tracking URLの生成ロジックが正確か
- [ ] モデル関連実験の削除防止メッセージが正しいか
- [ ] 権限チェックの記載が`before_action`と一致しているか
