---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：104-実験詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **CandidateFinderの詳細実装**：Finderクラスの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/ml/experiments_controller.rb`（行1-66）
- E-02: `app/views/projects/ml/experiments/show.html.haml`（行1-21）
- E-03: `app/helpers/projects/ml/experiments_helper.rb`（行1-105）
- E-04: `app/models/ml/candidate.rb`（行1-116）
- E-05: `config/routes/project.rb`（行486-492）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行145）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが`/ml/experiments/:iid`である | E-05（行487） | ○ |
| C-02 | `read_model_experiments`権限が必要 | E-01（行8, 51-53） | ○ |
| C-03 | MAX_CANDIDATES_PER_PAGE = 30 | E-01（行14） | ○ |
| C-04 | CSV形式でのエクスポート対応 | E-01（行25-29） | ○ |
| C-05 | keyset_paginateでページネーション | E-01（行33） | ○ |
| C-06 | experiment_as_dataでデータ整形 | E-02（行6）, E-03（行9-25） | ○ |
| C-07 | candidates_table_itemsで候補データ整形 | E-02（行7）, E-03（行27-42） | ○ |
| C-08 | unique_logged_namesでメトリクス/パラメータ名取得 | E-02（行8-9）, E-03（行44-46） | ○ |
| C-09 | formatted_page_infoでページ情報整形 | E-02（行10）, E-03（行57-59） | ○ |
| C-10 | can_write_model_experimentsをフロントエンドに渡す | E-02（行20） | ○ |
| C-11 | 候補ステータスが5種類（running等） | E-04（行9） | ○ |
| C-12 | latest_metricsスコープ | E-04（行26） | ○ |
| C-13 | order_by_metricスコープ | E-04（行40-61） | ○ |
| C-14 | CandidatesCsvPresenterでCSV生成 | E-01（行27） | ○ |
| C-15 | link_to_artifactでパッケージリンク生成 | E-03（行61-67） | ○ |
| C-16 | link_to_detailsで候補詳細リンク生成 | E-03（行69-71） | ○ |
| C-17 | job_infoでCI Jobリンク生成 | E-03（行73-82） | ○ |
| C-18 | CandidateFinderでパラメータベース検索 | **根拠なし**（Finderクラス未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- CandidateFinderクラスの詳細実装
  - 候補：`app/finders/ml/candidate_finder.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面構造・データフローは確認済み
- 0: 低リスク - ヘルパー関数の実装は詳細に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 候補の表示項目がフロントエンドの実装と一致しているか
- [ ] CSVエクスポートの出力形式が正しいか
- [ ] ページネーションのカーソル処理が正確か
- [ ] メトリクスによるソートが正しく動作するか
