---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：106-モデル新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **GraphQL Mutationの詳細**：実際のMutation実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/ml/models_controller.rb`（行1-46）
- E-02: `app/views/projects/ml/models/new.html.haml`（行1-4）
- E-03: `app/helpers/projects/ml/model_registry_helper.rb`（行21-29）
- E-04: `app/models/ml/model.rb`（行1-68）
- E-05: `config/routes/project.rb`（行493）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行147）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが`/ml/models/new`である | E-05 | ○ |
| C-02 | `write_model_registry`権限が必要 | E-01（行7, 35-37） | ○ |
| C-03 | newアクションが空メソッド | E-01（行15） | ○ |
| C-04 | Vueコンポーネントをマウント | E-02（行4） | ○ |
| C-05 | new_ml_model_dataでデータ整形 | E-02（行4）, E-03（行21-29） | ○ |
| C-06 | index_models_path渡し | E-03（行23） | ○ |
| C-07 | projectPath渡し | E-03（行24） | ○ |
| C-08 | can_write_model_registry渡し | E-03（行25） | ○ |
| C-09 | markdown_preview_path渡し | E-03（行26） | ○ |
| C-10 | モデル名最大255文字 | E-04（行16） | ○ |
| C-11 | 説明最大10,000文字 | E-04（行19-20） | ○ |
| C-12 | EXPERIMENT_NAME_PREFIXが`[model]` | E-04（行9） | ○ |
| C-13 | 関連機能No.135 MLモデルレジストリ | E-06 | ○ |
| C-14 | GraphQL Mutationでモデル作成 | **根拠なし**（Vue/GraphQL実装） | △ |

## 4) 不足情報（Unknown / Missing）
- GraphQL Mutationの詳細実装
  - 候補：`app/graphql/mutations/ml/models/create.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バックエンド側の構造は確認済み
- 1: 中リスク - フロントエンド（Vue/GraphQL）の実装詳細は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] モデル名の命名規則（regex）が正しく記載されているか
- [ ] デフォルト実験の自動作成ロジックが正確か
- [ ] バリデーションエラーメッセージが実装と一致しているか
