---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：107-モデル詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。低優先度でのレビュー推奨。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/ml/models_controller.rb`（行1-46）
- E-02: `app/views/projects/ml/models/show.html.haml`（行1-5）
- E-03: `app/helpers/projects/ml/model_registry_helper.rb`（行32-50）
- E-04: `app/models/ml/model.rb`（行1-68）
- E-05: `app/models/ml/model_version.rb`（行1-87）
- E-06: `config/routes/project.rb`（行493）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行148）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが`/ml/models/:model_id`である | E-06 | ○ |
| C-02 | `read_model_registry`権限が必要 | E-01（行6, 31-33） | ○ |
| C-03 | `write_model_registry`権限が編集・削除に必要 | E-01（行7, 35-37） | ○ |
| C-04 | set_modelでモデルをロード | E-01（行8, 39-43） | ○ |
| C-05 | showアクションが空メソッド | E-01（行17） | ○ |
| C-06 | destroyでModel removedメッセージ | E-01（行24-26） | ○ |
| C-07 | Vueコンポーネントをマウント | E-02（行5） | ○ |
| C-08 | show_ml_model_dataでデータ整形 | E-02（行5）, E-03（行32-50） | ○ |
| C-09 | edit_model_path渡し | E-03（行38） | ○ |
| C-10 | create_model_version_path渡し | E-03（行39） | ○ |
| C-11 | mlflow_tracking_url渡し | E-03（行41） | ○ |
| C-12 | latest_version渡し | E-03（行45） | ○ |
| C-13 | has_one :latest_version | E-04（行28） | ○ |
| C-14 | latest_by_modelスコープ | E-05（行32-35） | ○ |
| C-15 | セマンティックバージョニング形式 | E-05（行7, 12-16） | ○ |
| C-16 | 関連機能No.135 MLモデルレジストリ | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目に根拠確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] モデル詳細の表示項目がフロントエンドの実装と一致しているか
- [ ] バージョン一覧の取得方法が正確か
- [ ] 削除時のCASCADE動作が正しく記載されているか
