---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：108-モデル編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。低優先度でのレビュー推奨。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/ml/models_controller.rb`（行1-46）
- E-02: `app/views/projects/ml/models/edit.html.haml`（行1-5）
- E-03: `app/helpers/projects/ml/model_registry_helper.rb`（行52-66）
- E-04: `app/models/ml/model.rb`（行1-68）
- E-05: `config/routes/project.rb`（行493）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行149）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが`/ml/models/:model_id/edit`である | E-05 | ○ |
| C-02 | `write_model_registry`権限が必要 | E-01（行7, 35-37） | ○ |
| C-03 | set_modelでモデルをロード | E-01（行8, 39-43） | ○ |
| C-04 | editアクションが空メソッド | E-01（行19） | ○ |
| C-05 | Vueコンポーネントをマウント | E-02（行5） | ○ |
| C-06 | edit_ml_model_dataでデータ整形 | E-02（行5）, E-03（行52-66） | ○ |
| C-07 | model_path渡し | E-03（行59） | ○ |
| C-08 | model_id渡し | E-03（行60） | ○ |
| C-09 | model_name渡し | E-03（行61） | ○ |
| C-10 | model_description渡し | E-03（行62） | ○ |
| C-11 | 説明最大10,000文字 | E-04（行19-20） | ○ |
| C-12 | cache_markdown_field :description | E-04（行43） | ○ |
| C-13 | 関連機能No.135 MLモデルレジストリ | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目に根拠確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] モデル名が編集不可であることがフロントエンドで正しく実装されているか
- [ ] Markdown説明のプレビュー機能が動作するか
- [ ] バリデーションエラーメッセージが実装と一致しているか
