---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：109-モデルバージョン詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。低優先度でのレビュー推奨。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/ml/model_versions_controller.rb`（行1-44）
- E-02: `app/views/projects/ml/model_versions/show.html.haml`（行1-6）
- E-03: `app/helpers/projects/ml/model_registry_helper.rb`（行83-102）
- E-04: `app/models/ml/model_version.rb`（行1-87）
- E-05: `config/routes/project.rb`（行494-495）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行150）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが`/ml/models/:model_id/versions/:model_version_id`である | E-05 | ○ |
| C-02 | `read_model_registry`権限が必要 | E-01（行7, 23-25） | ○ |
| C-03 | `write_model_registry`権限が編集に必要 | E-01（行8, 27-29） | ○ |
| C-04 | set_model_versionでバージョンをロード | E-01（行9, 31-37） | ○ |
| C-05 | showアクションが空メソッド | E-01（行11） | ○ |
| C-06 | @model = @model_version.model | E-01（行36） | ○ |
| C-07 | Vueコンポーネントをマウント | E-02（行6） | ○ |
| C-08 | show_ml_model_version_dataでデータ整形 | E-02（行6）, E-03（行83-102） | ○ |
| C-09 | model_id渡し | E-03（行88） | ○ |
| C-10 | model_version_id渡し | E-03（行89） | ○ |
| C-11 | import_path渡し | E-03（行93） | ○ |
| C-12 | edit_model_version_path渡し | E-03（行95-96） | ○ |
| C-13 | セマンティックバージョニング形式 | E-04（行7, 12-16） | ○ |
| C-14 | belongs_to :package | E-04（行25） | ○ |
| C-15 | 関連機能No.135 MLモデルレジストリ | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目に根拠確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] バージョン詳細の表示項目がフロントエンドの実装と一致しているか
- [ ] アーティファクトインポートのAPI呼び出しが正確か
- [ ] セマンティックバージョニングの検証が正しく動作するか
