---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：11-プロジェクト一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **Vue.jsアプリケーションの詳細仕様**：フロントエンドコードの詳細解析が不足
  2. **スター操作API仕様**：Star API の詳細仕様の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/dashboard/projects/index.html.haml`
- E-02: `app/controllers/dashboard/projects_controller.rb`
- E-03: `app/finders/projects_finder.rb`
- E-04: `config/routes/dashboard.rb`
- E-05: `app/models/project.rb`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは `/dashboard/projects` である | E-04 (Line 27-35) | ○ |
| C-02 | コントローラは Dashboard::ProjectsController である | E-02 | ○ |
| C-03 | ビューファイルは index.html.haml である | E-01 | ○ |
| C-04 | ページタイトルは "Projects" である | E-01 (Line 7) | ○ |
| C-05 | ATOMフィード対応している | E-01 (Line 1-2), E-02 (Line 27-30) | ○ |
| C-06 | ProjectsFinderを使用してプロジェクトを取得する | E-02 (Line 37-39) | ○ |
| C-07 | ソート機能をサポートしている | E-02 (Line 48-59) | ○ |
| C-08 | before_actionでset_non_archived_paramが実行される | E-02 (Line 12) | ○ |
| C-09 | before_actionでset_sortingが実行される | E-02 (Line 13) | ○ |
| C-10 | Vue.jsアプリケーションがマウントされる | E-01 (Line 17) | ○ |
| C-11 | dashboard_projects_app_dataがアプリデータとして渡される | E-01 (Line 17) | ○ |
| C-12 | 画面番号は11である | E-06 | ○ |
| C-13 | カテゴリはダッシュボードである | E-06 | ○ |
| C-14 | 関連機能はプロジェクトダッシュボード(123)である | E-07 | ○ |
| C-15 | 関連機能にプロジェクトスター(6)がある | E-07 | ○ |
| C-16 | ウェルカムページ表示条件の分岐がある | E-01 (Line 13-17) | ○ |
| C-17 | last_pushパーシャルがレンダリングされる | E-01 (Line 11) | ○ |
| C-18 | personal, contributed, starred, member, inactiveのサブルートがある | E-04 (Line 29-33) | ○ |
| C-19 | feature_categoryはgroups_and_projectsである | E-02 (Line 16) | ○ |
| C-20 | urgencyはlowである | E-02 (Line 17) | ○ |
| C-21 | cross_project_access_checkがスキップされる | E-02 (Line 14) | ○ |
| C-22 | default_sort_orderはsort_value_nameである | E-02 (Line 48-50) | ○ |
| C-23 | sorting_fieldはProject::SORTING_PREFERENCE_FIELDである | E-02 (Line 52-54) | ○ |
| C-24 | Vue.jsアプリケーションの詳細な動作仕様 | **根拠なし** | △ |
| C-25 | スター操作のAPI詳細仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **Vue.jsフロントエンドコードの詳細解析**
  - 候補：`app/assets/javascripts/dashboard/projects/` / `ee/app/assets/javascripts/`
- **スター操作APIエンドポイントの仕様**
  - 候補：`app/controllers/projects/starrers_controller.rb` / API routes

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 基本的な画面構成とルーティングは明確
- **1: 中リスク** - フロントエンド（Vue.js）部分の詳細仕様は要確認
- **0: 低リスク** - データベーステーブルの更新仕様は標準的なRailsパターン

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターン `/dashboard/projects` が正しいか確認
- [ ] Vue.jsアプリケーションのマウントポイント `#js-your-work-projects-app` が実際に存在するか確認
- [ ] ProjectsFinderのフィルタリング条件が正確に記載されているか確認
- [ ] 権限による表示制御の記載が実装と一致しているか確認
