---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：110-候補詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。低優先度でのレビュー推奨。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/ml/candidates_controller.rb`（行1-45）
- E-02: `app/views/projects/ml/candidates/show.html.haml`（行1-8）
- E-03: `app/presenters/ml/candidate_details_presenter.rb`（行1-116）
- E-04: `app/models/ml/candidate.rb`（行1-116）
- E-05: `config/routes/project.rb`（行488-491）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行151）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが`/ml/candidates/:iid`である | E-05（行488） | ○ |
| C-02 | `read_model_experiments`権限が必要 | E-01（行37） | ○ |
| C-03 | `write_model_experiments`権限が削除に必要 | E-01（行41） | ○ |
| C-04 | set_candidateで候補をロード | E-01（行6, 30-34） | ○ |
| C-05 | showアクションが空メソッド | E-01（行12） | ○ |
| C-06 | destroyでRun removedメッセージ | E-01（行19-20） | ○ |
| C-07 | destroyでFailed to remove runメッセージ | E-01（行22） | ○ |
| C-08 | CandidateDetailsPresenterを使用 | E-02（行6） | ○ |
| C-09 | Vueコンポーネントをマウント | E-02（行8） | ○ |
| C-10 | presentメソッドでデータ構造化 | E-03（行10-41） | ○ |
| C-11 | present_as_jsonでJSON変換 | E-03（行44-46） | ○ |
| C-12 | link_to_artifactでパッケージリンク | E-03（行90-96） | ○ |
| C-13 | job_infoでCI Job情報取得 | E-03（行52-63） | ○ |
| C-14 | can_promoteでプロモート可否判定 | E-03（行110-114） | ○ |
| C-15 | statusがenum（5種類） | E-04（行9） | ○ |
| C-16 | from_ci?メソッド | E-04（行79-81） | ○ |
| C-17 | check_model_versionで削除制約 | E-04（行109-114） | ○ |
| C-18 | with_project_id_and_iidで候補取得 | E-01（行31）, E-04（行94-98） | ○ |
| C-19 | has_many :metrics, :params, :metadata | E-04（行23-25） | ○ |
| C-20 | 関連機能No.135 MLモデルレジストリ | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目に根拠確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 候補詳細の表示項目がフロントエンドの実装と一致しているか
- [ ] プロモート機能の条件が正しく実装されているか
- [ ] CI/CDジョブ情報の表示条件（read_build権限）が正しいか
- [ ] モデルバージョン関連候補の削除防止が動作するか
