---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：111-リポジトリ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **メッセージIDの命名規則**：独自に付与したIDのため要確認
  2. **EE専用機能の詳細**：プッシュルール等のEE機能の詳細仕様

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/settings/repository_controller.rb`
- E-02: `app/views/projects/settings/repository/show.html.haml`
- E-03: `config/routes/project.rb`
- E-04: `app/models/protected_branch.rb`（存在前提）
- E-05: `app/models/deploy_token.rb`（存在前提）
- E-06: `画面一覧.csv` No.111
- E-07: `画面機能マッピング.csv` No.111関連行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/:namespace/:project/-/settings/repository` | E-03 | ○ |
| C-02 | コントローラーは `Projects::Settings::RepositoryController` | E-01 | ○ |
| C-03 | showアクションで画面表示 | E-01 (22-24行目) | ○ |
| C-04 | admin_project権限でブランチデフォルト設定を表示 | E-02 (6-8行目) | ○ |
| C-05 | admin_push_rules権限でプッシュルールを表示 | E-02 (10-11行目) | ○ |
| C-06 | admin_protected_branch権限で保護ブランチを表示 | E-02 (20-21行目) | ○ |
| C-07 | manage_deploy_tokens権限でデプロイトークンを表示 | E-02 (23-24行目) | ○ |
| C-08 | create_deploy_tokenアクションでトークン作成 | E-01 (39-65行目) | ○ |
| C-09 | cleanupアクションでリポジトリクリーンアップ | E-01 (26-37行目) | ○ |
| C-10 | デプロイトークン作成時にCreateServiceを使用 | E-01 (40行目) | ○ |
| C-11 | デプロイトークンパラメータに各種権限が含まれる | E-01 (129-142行目) | ○ |
| C-12 | 保護ブランチはページネーション対応 | E-01 (120-122行目) | ○ |
| C-13 | define_variablesでデプロイキー、トークン、保護ブランチを準備 | E-01 (88-96行目) | ○ |
| C-14 | feature_categoryはsource_code_management | E-01 (18行目) | ○ |
| C-15 | layout は project_settings | E-01 (8行目) | ○ |
| C-16 | 関連機能No.25は保護ブランチ | E-07 | ○ |
| C-17 | 関連機能No.26は保護タグ | E-07 | ○ |
| C-18 | 関連機能No.27はリポジトリミラーリング | E-07 | ○ |
| C-19 | 画面カテゴリはプロジェクト設定 | E-06 | ○ |
| C-20 | テンプレートファイルパスが正しい | E-06 | ○ |
| C-21 | デプロイトークン作成成功メッセージ | E-01 (51行目) | ○ |
| C-22 | 設定更新成功メッセージ | E-01 (71行目) | ○ |
| C-23 | クリーンアップ開始成功メッセージ | E-01 (31行目) | ○ |
| C-24 | クリーンアップ失敗メッセージ | E-01 (33行目) | ○ |
| C-25 | プロジェクト設定更新にUpdateServiceを使用 | E-01 (68行目) | ○ |
| C-26 | プロジェクトパラメータにdefault_branch等が含まれる | E-01 (148-154行目) | ○ |
| C-27 | メッセージIDの命名規則（MSG-111-XX） | **独自定義** | △ |
| C-28 | EE機能の詳細仕様（プッシュルール等） | **EEコード未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **メッセージIDの命名規則**
  - 理由：設計書内で独自に定義したID体系であり、実際のコードベースには存在しない
  - 対応：レビュー時に命名規則の妥当性を確認する
- **EE専用機能の詳細**
  - 理由：`render_if_exists`で呼び出されるEE専用テンプレート・コントローラーの詳細は未確認
  - 候補：`ee/app/views/projects/push_rules/`、`ee/app/controllers/`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: URL/ルーティング、コントローラー構成
- **0（低リスク）**: 権限制御の記載
- **1（中リスク）**: データベース更新仕様（実際のマイグレーションとの整合性確認推奨）
- **1（中リスク）**: EE機能との境界が不明確

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターンが実際のルーティングと一致しているか
- [ ] 権限チェックの記載がコントローラーのbefore_actionと一致しているか
- [ ] デプロイトークンのパラメータ一覧が最新か
- [ ] 保護ブランチの入出力項目が実際のフォームと一致しているか
- [ ] EE専用機能の境界が明確に記載されているか
