---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：112-CI/CD設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **CI/CD変数の詳細仕様**：フロントエンドコンポーネント未確認
  2. **セキュアファイル機能の詳細**：条件付き表示の詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/settings/ci_cd_controller.rb`
- E-02: `app/views/projects/settings/ci_cd/show.html.haml`
- E-03: `config/routes/project.rb`
- E-04: `画面一覧.csv` No.112
- E-05: `画面機能マッピング.csv` No.112関連行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/:namespace/:project/-/settings/ci_cd` | E-03 (116行目) | ○ |
| C-02 | コントローラーは `Projects::Settings::CiCdController` | E-01 | ○ |
| C-03 | showアクションで画面表示 | E-01 (27-40行目) | ○ |
| C-04 | updateアクションで設定更新 | E-01 (42-56行目) | ○ |
| C-05 | reset_cacheアクションでキャッシュリセット | E-01 (58-68行目) | ○ |
| C-06 | reset_registration_tokenアクションでトークンリセット | E-01 (70-75行目) | ○ |
| C-07 | admin_pipeline権限で一般設定を表示 | E-02 (10行目) | ○ |
| C-08 | admin_runners権限でRunner設定を表示 | E-02 (35行目) | ○ |
| C-09 | admin_cicd_variables権限で変数設定を表示 | E-02 (55行目) | ○ |
| C-10 | admin_pipeline権限でトリガー設定を表示 | E-02 (65行目) | ○ |
| C-11 | UpdateServiceでプロジェクト設定を更新 | E-01 (43行目) | ○ |
| C-12 | ResetProjectCacheServiceでキャッシュリセット | E-01 (59行目) | ○ |
| C-13 | Ci::Runners::ResetRegistrationTokenServiceでトークンリセット | E-01 (71行目) | ○ |
| C-14 | 設定更新成功メッセージ | E-01 (46-47行目) | ○ |
| C-15 | 登録トークンリセット成功メッセージ | E-01 (73行目) | ○ |
| C-16 | Auto DevOpsパイプライン作成メッセージ | E-01 (190行目) | ○ |
| C-17 | 空リポジトリ時の通知メッセージ | E-01 (182行目) | ○ |
| C-18 | feature_categoryはcontinuous_integration | E-01 (24行目) | ○ |
| C-19 | layout は project_settings | E-01 (8行目) | ○ |
| C-20 | 関連機能No.50はCI変数管理 | E-05 | ○ |
| C-21 | 関連機能No.51はRunnerレジストレーション | E-05 | ○ |
| C-22 | 関連機能No.54はトリガー管理 | E-05 | ○ |
| C-23 | 許可されるプロジェクトパラメータ一覧 | E-01 (158-170行目) | ○ |
| C-24 | 許可されるCI/CD設定パラメータ一覧 | E-01 (172-176行目) | ○ |
| C-25 | run_autodevops_pipelineでパイプライン自動作成 | E-01 (178-191行目) | ○ |
| C-26 | CreatePipelineWorkerで非同期パイプライン作成 | E-01 (187行目) | ○ |
| C-27 | define_ci_variablesで変数を準備 | E-01 (200-205行目) | ○ |
| C-28 | define_triggers_variablesでトリガーを準備 | E-01 (207-213行目) | ○ |
| C-29 | 監査ログ記録処理 | E-01 (103-120行目) | ○ |
| C-30 | トリガーのJSON変換処理 | E-01 (31-35行目) | ○ |
| C-31 | CI/CD変数のフロントエンド詳細 | **フロントエンドコード未確認** | △ |
| C-32 | セキュアファイルの表示条件詳細 | **条件関数未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **CI/CD変数のフロントエンド詳細**
  - 理由：変数管理は`#js-cicd-variables-settings`でVueコンポーネントとして実装されている
  - 候補：`app/assets/javascripts/ci/ci_variable_list/`配下のコンポーネント
- **セキュアファイルの表示条件**
  - 理由：`show_secure_files_setting`ヘルパーの詳細実装未確認
  - 候補：`app/helpers/projects/settings/ci_cd_helper.rb`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: URL/ルーティング、コントローラー構成
- **0（低リスク）**: 権限制御の記載
- **1（中リスク）**: CI/CD変数の暗号化仕様（実装詳細確認推奨）
- **1（中リスク）**: Auto DevOpsパイプライン自動作成のタイミング

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターンが実際のルーティングと一致しているか
- [ ] 権限チェックの記載がコントローラーのbefore_actionと一致しているか
- [ ] CI/CD変数のパラメータ一覧が最新か
- [ ] トリガーのパラメータ一覧が最新か
- [ ] 監査ログに記録される情報が正確か
