---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：113-MR設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **EE機能の詳細仕様**：承認ルール、サジェストレビュアー等の詳細未確認
  2. **マージコミットテンプレートの変数一覧**：使用可能な変数の完全な一覧

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/settings/merge_requests_controller.rb`
- E-02: `app/views/projects/settings/merge_requests/show.html.haml`
- E-03: `config/routes/project.rb`
- E-04: `画面一覧.csv` No.113
- E-05: `画面機能マッピング.csv` No.113関連行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/:namespace/:project/-/settings/merge_requests` | E-03 (169行目) | ○ |
| C-02 | コントローラーは `Projects::Settings::MergeRequestsController` | E-01 | ○ |
| C-03 | updateアクションで設定更新 | E-01 (14-25行目) | ○ |
| C-04 | merge_requests_enabled?でMR機能有効確認 | E-01 (8行目、29-31行目) | ○ |
| C-05 | authorize_admin_project!で権限確認 | E-01 (10行目) | ○ |
| C-06 | UpdateServiceでプロジェクト設定を更新 | E-01 (15行目) | ○ |
| C-07 | 設定更新成功メッセージ | E-01 (17-18行目) | ○ |
| C-08 | feature_categoryはcode_review_workflow | E-01 (12行目) | ○ |
| C-09 | layout は project_settings | E-01 (6行目) | ○ |
| C-10 | 関連機能No.30はマージリクエストマージ | E-05 | ○ |
| C-11 | 関連機能No.33は自動マージ | E-05 | ○ |
| C-12 | 許可されるプロジェクトパラメータ一覧 | E-01 (46-61行目) | ○ |
| C-13 | 許可されるプロジェクト設定属性一覧 | E-01 (38-44行目) | ○ |
| C-14 | SettingsSectionComponentでセクション表示 | E-02 (5-17行目) | ○ |
| C-15 | render_if_existsでEE機能を条件付き表示 | E-02 (19-22行目) | ○ |
| C-16 | MR機能無効時は404を表示 | E-01 (29-31行目) | ○ |
| C-17 | フォームはproject_settings_merge_requests_pathにPOST | E-02 (14行目) | ○ |
| C-18 | multipart formで送信 | E-02 (14行目) | ○ |
| C-19 | update_sectionにjs-merge-request-settingsを設定 | E-02 (15行目) | ○ |
| C-20 | 保存ボタンのテキストは「Save changes」 | E-02 (17行目) | ○ |
| C-21 | project_setting_attributesにsquash_option等が含まれる | E-01 (38-44行目) | ○ |
| C-22 | merge_request_title_regexパラメータが許可される | E-01 (59-60行目) | ○ |
| C-23 | EE機能の詳細仕様（承認ルール等） | **EEコード未確認** | △ |
| C-24 | マージコミットテンプレートで使用可能な変数一覧 | **ドキュメント未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **EE機能の詳細仕様**
  - 理由：`render_if_exists`で呼び出されるEE専用テンプレートの詳細は未確認
  - 候補：`ee/app/views/projects/settings/merge_requests/`配下のパーシャル
- **マージコミットテンプレートの変数一覧**
  - 理由：使用可能な変数（%{title}等）の完全な一覧は公式ドキュメント参照が必要
  - 候補：GitLabヘルプドキュメント

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: URL/ルーティング、コントローラー構成
- **0（低リスク）**: 権限制御の記載
- **1（中リスク）**: 入出力項目の完全性（EE機能含む）
- **1（中リスク）**: マージコミットテンプレートの変数仕様

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターンが実際のルーティングと一致しているか
- [ ] 許可パラメータ一覧がコントローラーのproject_paramsと一致しているか
- [ ] project_setting_attributesが最新か
- [ ] EE専用機能の境界が明確に記載されているか
- [ ] マージコミットテンプレートの変数がドキュメントと一致しているか
