---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：114-運用設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **アラート統合の詳細仕様**：HTTP統合/Prometheus統合のパラメータ詳細
  2. **インシデント管理トラッキングキーの一覧**：トラッキング対象の完全一覧

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/settings/operations_controller.rb`
- E-02: `app/views/projects/settings/operations/show.html.haml`
- E-03: `app/views/projects/settings/operations/_error_tracking.html.haml`
- E-04: `app/views/projects/settings/operations/_alert_management.html.haml`
- E-05: `app/views/projects/settings/operations/_incidents.html.haml`
- E-06: `config/routes/project.rb`
- E-07: `画面一覧.csv` No.114
- E-08: `画面機能マッピング.csv` No.114関連行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/:namespace/:project/-/settings/operations` | E-06 (124-128行目) | ○ |
| C-02 | コントローラーは `Projects::Settings::OperationsController` | E-01 | ○ |
| C-03 | updateアクションで設定更新 | E-01 (21-26行目) | ○ |
| C-04 | reset_pagerduty_tokenアクションでトークンリセット | E-01 (28-41行目) | ○ |
| C-05 | authorize_admin_operations!で権限確認 | E-01 (7行目) | ○ |
| C-06 | Operations::UpdateServiceで設定を更新 | E-01 (22行目) | ○ |
| C-07 | 設定更新成功メッセージ | E-01 (71行目) | ○ |
| C-08 | feature_categoryはincident_management | E-01 (18行目) | ○ |
| C-09 | layout は project_settings | E-01 (6行目) | ○ |
| C-10 | 関連機能No.131はアラート管理 | E-08 | ○ |
| C-11 | 関連機能No.132はエラートラッキング | E-08 | ○ |
| C-12 | 許可されるエラートラッキングパラメータ一覧 | E-01 (117-124行目) | ○ |
| C-13 | 許可されるインシデント管理パラメータ一覧 | E-01 (114-116行目) | ○ |
| C-14 | エラートラッキングセクションの表示 | E-02 (6行目) | ○ |
| C-15 | アラート管理セクションの表示 | E-02 (7行目) | ○ |
| C-16 | インシデント管理セクションの表示 | E-02 (8行目) | ○ |
| C-17 | admin_operations権限チェック | E-03 (1行目)、E-04 (1行目) | ○ |
| C-18 | Vueコンポーネントでの設定UI実装 | E-03 (11-18行目)、E-04 (14行目)、E-05 (1行目) | ○ |
| C-19 | PagerDutyトークンリセットでJSONレスポンス返却 | E-01 (37行目) | ○ |
| C-20 | track_eventsでトラッキング記録 | E-01 (45-51行目) | ○ |
| C-21 | アラート統合の詳細パラメータ | **フロントエンドコード未確認** | △ |
| C-22 | インシデント管理トラッキングキー一覧 | **Gitlab::Tracking::IncidentManagement未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **アラート統合の詳細パラメータ**
  - 理由：`alerts_settings_data`ヘルパーとVueコンポーネントの詳細実装未確認
  - 候補：`app/helpers/projects/settings/operations_helper.rb`、`app/assets/javascripts/alerts_settings/`
- **インシデント管理トラッキングキー一覧**
  - 理由：`Gitlab::Tracking::IncidentManagement.tracking_keys`の詳細実装未確認
  - 候補：`lib/gitlab/tracking/incident_management.rb`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: URL/ルーティング、コントローラー構成
- **0（低リスク）**: 権限制御の記載
- **1（中リスク）**: アラート統合設定の入出力項目（フロントエンド確認推奨）
- **1（中リスク）**: PagerDutyトークンの暗号化仕様

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターンが実際のルーティングと一致しているか
- [ ] 権限チェックの記載がコントローラーのbefore_actionと一致しているか
- [ ] エラートラッキングのパラメータ一覧が最新か
- [ ] インシデント管理のパラメータ一覧が最新か
- [ ] PagerDutyトークンリセットのレスポンス形式が正確か
