---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 17
  claims_without_evidence: 3
confidence_derived: 0.85
---

# 根拠レポート：115-パッケージ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：17 / 20、根拠なし：3
- 優先レビュー（高）
  1. **GraphQL APIの詳細仕様**：Vueコンポーネントが使用するmutation/queryの詳細
  2. **パッケージ保護ルールのパラメータ詳細**：フロントエンドコンポーネント未確認
  3. **settings_dataヘルパーの戻り値**：Vueコンポーネントに渡されるデータ構造

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/settings/packages_and_registries_controller.rb`
- E-02: `app/views/projects/settings/packages_and_registries/show.html.haml`
- E-03: `config/routes/project.rb`
- E-04: `画面一覧.csv` No.115
- E-05: `画面機能マッピング.csv` No.115関連行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/:namespace/:project/-/settings/packages_and_registries` | E-03 (166-168行目) | ○ |
| C-02 | コントローラーは `Projects::Settings::PackagesAndRegistriesController` | E-01 | ○ |
| C-03 | showアクションで画面表示 | E-01 (16行目) | ○ |
| C-04 | cleanup_tagsアクションでクリーンアップタグ設定 | E-01 (18-22行目) | ○ |
| C-05 | authorize_admin_project!で権限確認 | E-01 (8行目) | ○ |
| C-06 | packages_and_registries_settings_enabled!で設定可能か確認 | E-01 (9行目、26-28行目) | ○ |
| C-07 | feature_categoryはpackage_registry | E-01 (13行目) | ○ |
| C-08 | layout は project_settings | E-01 (6行目) | ○ |
| C-09 | 関連機能No.62はパッケージレジストリ | E-05 | ○ |
| C-10 | 関連機能No.63はコンテナレジストリ | E-05 | ○ |
| C-11 | Vueコンポーネント#js-registry-settingsでUI実装 | E-02 (7行目) | ○ |
| C-12 | settings_data(@project)でデータを渡す | E-02 (7行目) | ○ |
| C-13 | packages_protected_packages_delete Feature flagのプッシュ | E-01 (35-37行目) | ○ |
| C-14 | container_registry_protected_containers_delete Feature flagのプッシュ | E-01 (39-41行目) | ○ |
| C-15 | view_package_registry_project_settings権限チェック | E-01 (27行目) | ○ |
| C-16 | registry_settings_enabled!でレジストリ設定可能か確認 | E-01 (30-33行目) | ○ |
| C-17 | cleanup_tags時にhide_search_settingsをtrue設定 | E-01 (21行目) | ○ |
| C-18 | GraphQL APIの詳細仕様 | **フロントエンドコード未確認** | △ |
| C-19 | パッケージ保護ルールのパラメータ詳細 | **モデル/GraphQL未確認** | △ |
| C-20 | settings_dataヘルパーの戻り値構造 | **ヘルパー未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **GraphQL APIの詳細仕様**
  - 理由：Vueコンポーネントが使用するGraphQL mutation/queryの詳細実装未確認
  - 候補：`app/graphql/mutations/packages/`、`app/graphql/mutations/container_registry/`
- **パッケージ保護ルールのパラメータ詳細**
  - 理由：パッケージ保護ルールモデルの詳細属性未確認
  - 候補：`app/models/packages/protection/rule.rb`
- **settings_dataヘルパーの戻り値**
  - 理由：Vueコンポーネントに渡されるデータ構造の詳細未確認
  - 候補：`app/helpers/projects/settings/packages_and_registries_helper.rb`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: URL/ルーティング、コントローラー構成
- **0（低リスク）**: 権限制御の記載
- **2（高リスク）**: GraphQL APIの入出力仕様（フロントエンド確認必須）
- **1（中リスク）**: Feature flagによる機能制御の詳細

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターンが実際のルーティングと一致しているか
- [ ] 権限チェックの記載がコントローラーのbefore_actionと一致しているか
- [ ] settings_dataヘルパーの戻り値が正確に記載されているか
- [ ] GraphQL mutationのパラメータが最新か
- [ ] Feature flagの制御範囲が正確か
