---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：116-インテグレーション一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **利用可能なインテグレーションの完全な一覧**：一部のインテグレーションは未列挙の可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/settings/integrations_controller.rb`
- E-02: `app/views/projects/settings/integrations/index.html.haml`
- E-03: `app/views/shared/integrations/_index.html.haml`
- E-04: `config/routes/project.rb`
- E-05: `画面一覧.csv` No.116
- E-06: `画面機能マッピング.csv` No.116関連行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/:namespace/:project/-/settings/integrations` | E-04 (130行目) | ○ |
| C-02 | コントローラーは `Projects::Settings::IntegrationsController` | E-01 | ○ |
| C-03 | indexアクションで画面表示 | E-01 (27-29行目) | ○ |
| C-04 | authorize_admin_integrations!で権限確認 | E-01 (9行目) | ○ |
| C-05 | @integrationsでインテグレーション一覧を取得 | E-01 (28行目) | ○ |
| C-06 | feature_categoryはintegrations | E-01 (24行目) | ○ |
| C-07 | layout は project_settings | E-01 (22行目) | ○ |
| C-08 | 関連機能No.95はSlack連携 | E-06 | ○ |
| C-09 | 関連機能No.96はJira連携 | E-06 | ○ |
| C-10 | 関連機能No.97はMattermost連携 | E-06 | ○ |
| C-11 | Slack Notifications非推奨警告の表示 | E-02 (5行目) | ○ |
| C-12 | PageHeadingComponentでヘッダー表示 | E-02 (8-13行目) | ○ |
| C-13 | shared/integrations/indexパーシャルで一覧表示 | E-02 (15行目) | ○ |
| C-14 | .js-integrations-listでVueコンポーネントマウント | E-03 (1行目) | ○ |
| C-15 | integration_list_dataでデータ準備 | E-03 (1行目) | ○ |
| C-16 | Webhookは別画面で管理（project_hooks_path） | E-02 (11行目) | ○ |
| C-17 | Project#find_or_initialize_integrationsで一覧取得 | E-01 (28行目) | ○ |
| C-18 | 利用可能なインテグレーションの完全な一覧 | **app/models/integrations/未完全確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **利用可能なインテグレーションの完全な一覧**
  - 理由：`app/models/integrations/`配下のすべてのインテグレーションクラスを完全に列挙していない可能性
  - 候補：`app/models/integrations/`配下のファイル一覧

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: URL/ルーティング、コントローラー構成
- **0（低リスク）**: 権限制御の記載
- **1（中リスク）**: インテグレーション一覧の完全性

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターンが実際のルーティングと一致しているか
- [ ] 権限チェックの記載がコントローラーのbefore_actionと一致しているか
- [ ] integration_list_dataの戻り値が正確に記載されているか
- [ ] 利用可能なインテグレーション一覧が最新か
