---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：117-インテグレーション編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **各インテグレーション固有の設定項目**：インテグレーションごとに設定項目が異なる
  2. **トリガーイベントの完全な一覧**：一部のイベントは未列挙の可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/settings/integrations_controller.rb`
- E-02: `app/views/projects/settings/integrations/edit.html.haml`
- E-03: `config/routes/project.rb`
- E-04: `画面一覧.csv` No.117
- E-05: `画面機能マッピング.csv` No.117関連行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/:namespace/:project/-/settings/integrations/:id/edit` | E-03 (130-133行目) | ○ |
| C-02 | コントローラーは `Projects::Settings::IntegrationsController` | E-01 | ○ |
| C-03 | editアクションで画面表示 | E-01 (31行目) | ○ |
| C-04 | updateアクションで設定更新 | E-01 (33-62行目) | ○ |
| C-05 | testアクションで接続テスト | E-01 (64-71行目) | ○ |
| C-06 | ensure_integration_enabledでインテグレーション有効確認 | E-01 (10行目、135-137行目) | ○ |
| C-07 | integrationでインテグレーションを取得 | E-01 (121-123行目) | ○ |
| C-08 | default_integrationでデフォルト設定を取得 | E-01 (125-127行目) | ○ |
| C-09 | use_inherited_settings?で継承判定 | E-01 (145-147行目) | ○ |
| C-10 | BulkUpdateServiceで設定継承同期 | E-01 (40行目) | ○ |
| C-11 | integration.saveで保存 | E-01 (45行目) | ○ |
| C-12 | context: :manual_changeで保存コンテキスト | E-01 (39行目、45行目) | ○ |
| C-13 | 成功メッセージ（有効時） | E-01 (114-115行目) | ○ |
| C-14 | 成功メッセージ（無効時） | E-01 (116-118行目) | ○ |
| C-15 | バリデーションエラーメッセージ | E-01 (85-89行目) | ○ |
| C-16 | 接続テスト失敗メッセージ | E-01 (93-100行目) | ○ |
| C-17 | レート制限超過メッセージ | E-01 (150-156行目) | ○ |
| C-18 | Integrations::Test::ProjectServiceでテスト実行 | E-01 (92行目) | ○ |
| C-19 | check_rate_limit!でレート制限チェック | E-01 (14行目、149-156行目) | ○ |
| C-20 | Webhookログの表示 | E-02 (7-9行目) | ○ |
| C-21 | web_hook_logsでログ取得 | E-01 (129-133行目) | ○ |
| C-22 | redirect_pathでリダイレクト先決定 | E-01 (74-78行目) | ○ |
| C-23 | serialize_as_jsonでJSON変換 | E-01 (139-143行目) | ○ |
| C-24 | Prometheus（remove_monitor_metrics有効時）は404 | E-01 (16-18行目) | ○ |
| C-25 | 各インテグレーション固有の設定項目の完全一覧 | **各インテグレーションモデル未確認** | △ |
| C-26 | トリガーイベントの完全な一覧 | **integration.rb未完全確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **各インテグレーション固有の設定項目**
  - 理由：`app/models/integrations/`配下の各インテグレーションの設定項目を完全に確認していない
  - 候補：`app/models/integrations/slack.rb`、`app/models/integrations/jira.rb`等
- **トリガーイベントの完全な一覧**
  - 理由：`Integration`基底クラスおよび各サブクラスのサポートするイベント一覧を完全に確認していない
  - 候補：`app/models/integration.rb`のevent関連定義

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: URL/ルーティング、コントローラー構成
- **0（低リスク）**: 権限制御の記載
- **1（中リスク）**: インテグレーション固有設定項目の網羅性
- **1（中リスク）**: トリガーイベントの完全性

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターンが実際のルーティングと一致しているか
- [ ] 権限チェックの記載がコントローラーのbefore_actionと一致しているか
- [ ] 接続テストのエラーメッセージが正確か
- [ ] レート制限の設定が正確か
- [ ] Webhookログの表示条件が正確か
