---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：118-アクセストークン一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **利用可能なスコープの完全な一覧**：一部のスコープは未列挙の可能性
  2. **トークン作成サービスの詳細パラメータ**：CreateServiceの詳細実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/settings/access_tokens_controller.rb`
- E-02: `app/views/projects/settings/access_tokens/index.html.haml`
- E-03: `config/routes/project.rb`
- E-04: `画面一覧.csv` No.118
- E-05: `画面機能マッピング.csv` No.118関連行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/:namespace/:project/-/settings/access_tokens` | E-03 (155-164行目) | ○ |
| C-02 | コントローラーは `Projects::Settings::AccessTokensController` | E-01 | ○ |
| C-03 | feature_categoryはsystem_access | E-01 (10行目) | ○ |
| C-04 | layout は project_settings | E-01 (9行目) | ○ |
| C-05 | 関連機能No.81は個人アクセストークン | E-05 | ○ |
| C-06 | resourceメソッドでprojectを返却 | E-01 (12行目) | ○ |
| C-07 | resource_access_tokens_pathでパスを返却 | E-01 (14-16行目) | ○ |
| C-08 | representでProjectAccessTokenSerializerを使用 | E-01 (20-22行目) | ○ |
| C-09 | rotate_serviceでRotateServiceを使用 | E-01 (24-26行目) | ○ |
| C-10 | SettingsSectionComponentでセクション表示 | E-02 (7行目) | ○ |
| C-11 | help_page_pathでヘルプページリンク | E-02 (9行目) | ○ |
| C-12 | create_resource_access_tokens権限でフォーム表示 | E-02 (10-11行目、30-31行目、35-36行目) | ○ |
| C-13 | #js-new-access-token-appでVueコンポーネントマウント | E-02 (21行目) | ○ |
| C-14 | CrudComponentでアクティブトークン一覧 | E-02 (23-39行目) | ○ |
| C-15 | CrudComponentで非アクティブトークン一覧 | E-02 (41-46行目) | ○ |
| C-16 | backend_pagination: trueでバックエンドページネーション | E-02 (39行目) | ○ |
| C-17 | inactive_project_settings_access_tokens_urlで非アクティブ取得 | E-02 (46行目) | ○ |
| C-18 | グループ設定で作成無効時の説明表示 | E-02 (13-18行目) | ○ |
| C-19 | admin_group権限でグループ設定リンク表示 | E-02 (16-18行目) | ○ |
| C-20 | js-toggle-containerでトグル表示 | E-02 (28行目) | ○ |
| C-21 | show_roleをtrueでロール列表示 | E-02 (39行目) | ○ |
| C-22 | access_token_typeでトークンタイプ設定 | E-02 (21行目、39行目) | ○ |
| C-23 | 利用可能なスコープの完全な一覧 | **PersonalAccessToken未完全確認** | △ |
| C-24 | トークン作成サービスの詳細パラメータ | **CreateService未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **利用可能なスコープの完全な一覧**
  - 理由：`PersonalAccessToken`モデルのスコープ定義を完全に確認していない
  - 候補：`app/models/personal_access_token.rb`、`lib/gitlab/auth.rb`
- **トークン作成サービスの詳細パラメータ**
  - 理由：`ResourceAccessTokens::CreateService`の詳細実装を確認していない
  - 候補：`app/services/resource_access_tokens/create_service.rb`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: URL/ルーティング、コントローラー構成
- **0（低リスク）**: 権限制御の記載
- **1（中リスク）**: 利用可能なスコープ一覧の完全性
- **1（中リスク）**: トークン作成時の必須パラメータ

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターンが実際のルーティングと一致しているか
- [ ] 権限チェックの記載がコントローラーのbefore_actionと一致しているか
- [ ] スコープ一覧が最新か
- [ ] グループ設定による制限の説明が正確か
- [ ] Vueコンポーネントに渡されるデータが正確か
