---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：119-ブランチルール一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **EE機能の表示項目詳細**：承認ルール、ステータスチェック、コードオーナーの詳細表示

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/settings/branch_rules_controller.rb`
- E-02: `app/views/projects/settings/branch_rules/index.html.haml`
- E-03: `app/helpers/projects/settings/branch_rules_helper.rb`
- E-04: `app/graphql/resolvers/projects/branch_rules_resolver.rb`
- E-05: `app/finders/projects/branch_rules_finder.rb`
- E-06: `app/models/projects/branch_rule.rb`
- E-07: `config/routes/project.rb`
- E-08: `画面一覧.csv` No.119
- E-09: `画面機能マッピング.csv` No.119関連行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/:namespace/:project/-/settings/branch_rules` | E-07 (152行目) | ○ |
| C-02 | コントローラーは `Projects::Settings::BranchRulesController` | E-01 | ○ |
| C-03 | authorize_admin_project!で権限確認 | E-01 (6行目) | ○ |
| C-04 | edit_branch_rulesフィーチャーフラグをフロントエンドに渡す | E-01 (7-9行目) | ○ |
| C-05 | feature_categoryはsource_code_management | E-01 (11行目) | ○ |
| C-06 | indexアクションで画面表示 | E-01 (13行目) | ○ |
| C-07 | #js-branch-rulesでVueコンポーネントマウント | E-02 (6行目) | ○ |
| C-08 | branch_rules_dataでVueにデータ渡し | E-02 (6行目)、E-03 (6-20行目) | ○ |
| C-09 | パンくずリストにリポジトリ設定を含む | E-02 (1行目) | ○ |
| C-10 | パンくずリストにブランチルールを含む | E-02 (2行目) | ○ |
| C-11 | BranchRulesResolverでGraphQL取得 | E-04 | ○ |
| C-12 | BranchRulesFinderでブランチルール検索 | E-04 (38行目)、E-05 | ○ |
| C-13 | AllBranchesRuleで全ブランチルール | E-04 (30行目) | ○ |
| C-14 | Projects::BranchRuleでProtectedBranchをラップ | E-06 (21-24行目) | ○ |
| C-15 | matching_branches_countでマッチブランチ数計算 | E-06 (30-34行目) | ○ |
| C-16 | can_admin_protected_branchesでブランチ編集権限チェック | E-03 (18行目) | ○ |
| C-17 | 関連機能No.74はブランチ保護 | E-09 | ○ |
| C-18 | EE機能（承認ルール、ステータスチェック、コードオーナー）の詳細表示 | **EE拡張ファイル未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **EE機能の表示項目詳細**
  - 理由：`app/models/projects/branch_rule.rb`のEE拡張（prepend_mod）を確認していない
  - 候補：`ee/app/models/projects/branch_rule.rb`、EE版GraphQL Resolver

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: URL/ルーティング、コントローラー構成
- **0（低リスク）**: 権限制御の記載
- **1（中リスク）**: EE機能の表示項目の網羅性

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターンが実際のルーティングと一致しているか
- [ ] 権限チェックの記載がコントローラーのbefore_actionと一致しているか
- [ ] branch_rules_dataの戻り値が正確に記載されているか
- [ ] GraphQL Resolverの動作が正確か
- [ ] EE機能の表示項目が正確か
