---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：12-グループ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Vue.jsアプリケーションの詳細仕様**：フロントエンドコードの詳細解析が不足

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/dashboard/groups/index.html.haml`
- E-02: `app/controllers/dashboard/groups_controller.rb`
- E-03: `app/finders/groups_finder.rb`
- E-04: `config/routes/dashboard.rb`
- E-05: `app/models/group.rb`
- E-06: `app/helpers/groups_helper.rb`
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは `/dashboard/groups` である | E-04 (Line 17-22) | ○ |
| C-02 | コントローラは Dashboard::GroupsController である | E-02 | ○ |
| C-03 | ビューファイルは index.html.haml である | E-01 | ○ |
| C-04 | ページタイトルは "Groups" である | E-01 (Line 1) | ○ |
| C-05 | GroupsFinderを使用してグループを取得する | E-02 (Line 12-18) | ○ |
| C-06 | all_available: falseでメンバーのグループのみ取得 | E-02 (Line 14-15) | ○ |
| C-07 | Current.organizationによる組織スコープフィルタリング | E-02 (Line 16) | ○ |
| C-08 | GroupTreeモジュールをincludeしている | E-02 (Line 4) | ○ |
| C-09 | render_group_treeメソッドを使用している | E-02 (Line 20) | ○ |
| C-10 | Vue.jsアプリケーションがマウントされる | E-01 (Line 7) | ○ |
| C-11 | groups_list_with_filtered_search_app_dataがアプリデータとして渡される | E-01 (Line 7), E-06 (Line 235-241) | ○ |
| C-12 | 画面番号は12である | E-07 | ○ |
| C-13 | カテゴリはダッシュボードである | E-07 | ○ |
| C-14 | 関連機能はグループダッシュボード(122)である | E-08 | ○ |
| C-15 | member, inactiveのサブルートがある | E-04 (Line 18-21) | ○ |
| C-16 | feature_categoryはgroups_and_projectsである | E-02 (Line 8) | ○ |
| C-17 | urgencyはlowである | E-02 (Line 10) | ○ |
| C-18 | cross_project_access_checkがスキップされる | E-02 (Line 6) | ○ |
| C-19 | GroupはNamespaceを継承している | E-05 (Line 5) | ○ |
| C-20 | activeパラメータによるフィルタリングをサポート | E-02 (Line 17), E-03 (Line 177-180) | ○ |
| C-21 | JSON形式のレスポンスをサポート | E-01 (Line 7), E-06 (Line 235-241) | ○ |
| C-22 | Vue.jsアプリケーションの詳細な動作仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **Vue.jsフロントエンドコードの詳細解析**
  - 候補：`app/assets/javascripts/groups/` / `ee/app/assets/javascripts/`
- **GroupTreeコンサーンの詳細実装**
  - 候補：`app/controllers/concerns/group_tree.rb`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 基本的な画面構成とルーティングは明確
- **1: 中リスク** - フロントエンド（Vue.js）部分の詳細仕様は要確認
- **0: 低リスク** - データベーステーブルの参照仕様は標準的なRailsパターン

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターン `/dashboard/groups` が正しいか確認
- [ ] Vue.jsアプリケーションのマウントポイント `#js-your-work-groups-app` が実際に存在するか確認
- [ ] GroupsFinderのall_availableパラメータの動作が正確に記載されているか確認
- [ ] 組織スコープフィルタリング（Current.organization）の動作確認
