---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：120-バッジ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Vueコンポーネントの詳細実装**：フロントエンドのVueコンポーネント実装詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/badges_controller.rb`
- E-02: `app/views/projects/settings/badges/index.html.haml`
- E-03: `app/views/shared/badges/_badge_settings.html.haml`
- E-04: `app/models/badge.rb`
- E-05: `app/models/badges/project_badge.rb`
- E-06: `config/routes/project.rb`
- E-07: `画面一覧.csv` No.120
- E-08: `画面機能マッピング.csv` No.120関連行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/:namespace/:project/-/badges` | E-06 (615行目) | ○ |
| C-02 | コントローラーは `Projects::BadgesController` | E-01 | ○ |
| C-03 | authorize_admin_project!で権限確認（indexアクション） | E-01 (5行目) | ○ |
| C-04 | layout は project_settings | E-01 (4行目) | ○ |
| C-05 | feature_categoryはcontinuous_integration（index, pipeline） | E-01 (9行目) | ○ |
| C-06 | feature_categoryはgroups_and_projects（custom） | E-01 (10行目) | ○ |
| C-07 | feature_categoryはcode_testing（coverage） | E-01 (11行目) | ○ |
| C-08 | feature_categoryはrelease_orchestration（release） | E-01 (12行目) | ○ |
| C-09 | pipelineアクションでパイプラインバッジ生成 | E-01 (14-23行目) | ○ |
| C-10 | coverageアクションでカバレッジバッジ生成 | E-01 (25-37行目) | ○ |
| C-11 | releaseアクションでリリースバッジ生成 | E-01 (39-49行目) | ○ |
| C-12 | customアクションでカスタムバッジ生成 | E-01 (51-65行目) | ○ |
| C-13 | custom_project_badgesフィーチャーフラグでカスタムバッジ制御 | E-01 (52行目) | ○ |
| C-14 | shared/badges/badge_settingsパーシャルを使用 | E-02 (4行目) | ○ |
| C-15 | #badge-settingsでVueコンポーネントマウント | E-03 (1行目) | ○ |
| C-16 | api_endpoint_urlをdata属性で渡す | E-03 (1行目) | ○ |
| C-17 | Badgeモデルでプレースホルダー定義 | E-04 (9-23行目) | ○ |
| C-18 | rendered_link_urlでプレースホルダー展開 | E-04 (41-43行目) | ○ |
| C-19 | rendered_image_urlでプレースホルダー展開 | E-04 (45-49行目) | ○ |
| C-20 | ProjectBadgeはBadgeを継承 | E-05 (3行目) | ○ |
| C-21 | ProjectBadgeはproject belongs_to | E-05 (8行目) | ○ |
| C-22 | Vueコンポーネントの詳細実装（REST API呼び出し） | **フロントエンド未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **Vueコンポーネントの詳細実装**
  - 理由：`#badge-settings`に対応するVueコンポーネントの実装を確認していない
  - 候補：`app/assets/javascripts/badges/`配下のファイル

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: URL/ルーティング、コントローラー構成
- **0（低リスク）**: 権限制御の記載
- **0（低リスク）**: バッジ画像生成の各アクション
- **1（中リスク）**: Vueコンポーネントの詳細動作

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターンが実際のルーティングと一致しているか
- [ ] 権限チェックの記載がコントローラーのbefore_actionと一致しているか
- [ ] プレースホルダー一覧が最新か
- [ ] REST APIのエンドポイントが正確か
- [ ] バッジ画像生成のパラメータが正確か
